/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ElementDeserializationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Deprecated(since="2023.4")
public class ChainElementDeserializer
extends StdDeserializer<ElementDeserializationResult> {
    private static final Logger log = LoggerFactory.getLogger(ChainElementDeserializer.class);
    private final LibraryElementsService libraryService;
    private final ElementRepository elementRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public ChainElementDeserializer(LibraryElementsService libraryService, ElementRepository elementRepository, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        super((Class)null);
        this.libraryService = libraryService;
        this.elementRepository = elementRepository;
        this.objectMapper = objectMapper;
    }

    public ElementDeserializationResult deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Object resultElement;
        ElementDeserializationResult deserializationResult = new ElementDeserializationResult();
        YAMLMapper mapper = (YAMLMapper)parser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(parser);
        JsonNode idNode = node.get("id");
        JsonNode nameNode = node.get("name");
        JsonNode descriptionNode = node.get("description");
        String elementType = node.at(ExportImportUtils.toJsonPointer((String[])new String[]{"element-type"})).asText();
        String swimlaneId = node.at(ExportImportUtils.toJsonPointer((String[])new String[]{"swimlane-id"})).asText(null);
        JsonNode filenamePropertyNode = node.get("properties-filename");
        ObjectNode propertiesNode = (ObjectNode)node.get("properties");
        JsonNode childrenNode = node.get("children");
        Optional elementOptional = this.elementRepository.findById((Object)idNode.asText());
        if (elementOptional.isPresent()) {
            resultElement = (ChainElement)elementOptional.get();
            if (resultElement instanceof ContainerChainElement) {
                ContainerChainElement container = (ContainerChainElement)resultElement;
                container.getElements().clear();
            } else if (resultElement instanceof SwimlaneChainElement) {
                SwimlaneChainElement swimlane = (SwimlaneChainElement)resultElement;
                swimlane.getElements().clear();
            }
            resultElement.setModifiedWhen(new Timestamp(System.currentTimeMillis()));
        } else {
            if (!"container".equals(elementType)) {
                ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(elementType);
                if (elementDescriptor == null) {
                    throw new IllegalArgumentException("Element type " + elementType + " not found");
                }
                resultElement = elementDescriptor.isContainer() ? new ContainerChainElement() : (ElementType.SWIMLANE == elementDescriptor.getType() ? new SwimlaneChainElement() : new ChainElement());
            } else {
                resultElement = new ContainerChainElement();
            }
            resultElement.setId(idNode.asText());
            resultElement.setCreatedWhen(new Timestamp(System.currentTimeMillis()));
        }
        resultElement.setParent(null);
        resultElement.setName(nameNode != null ? nameNode.asText() : null);
        resultElement.setDescription(descriptionNode != null ? descriptionNode.asText() : null);
        resultElement.setType(elementType);
        resultElement.setModifiedWhen(Timestamp.valueOf(LocalDateTime.now()));
        if (filenamePropertyNode != null) {
            if (deserializationResult.getElementPropertiesFilenames() == null) {
                deserializationResult.setElementPropertiesFilenames(new HashMap());
            }
            deserializationResult.getElementPropertiesFilenames().put(resultElement.getId(), filenamePropertyNode.asText());
        }
        if (swimlaneId != null) {
            deserializationResult.getElementToSwimlaneRelations().put(resultElement.getId(), swimlaneId);
        }
        this.restoreProperties(propertiesNode, resultElement);
        deserializationResult.setElement(resultElement);
        this.restoreChildElements(childrenNode, deserializationResult, resultElement, mapper);
        return deserializationResult;
    }

    private void restoreProperties(ObjectNode propertiesNode, ChainElement resultElement) {
        Map elementProperties = new HashMap();
        if (propertiesNode != null) {
            elementProperties = (Map)this.objectMapper.convertValue((Object)propertiesNode, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        resultElement.setProperties(elementProperties);
    }

    private void restoreChildElements(JsonNode childrenNode, ElementDeserializationResult resultDeserializeEntity, ChainElement resultElement, YAMLMapper mapper) throws JsonProcessingException {
        if (childrenNode != null && resultElement instanceof ContainerChainElement) {
            ArrayList<ChainElement> deserializedChildren = new ArrayList<ChainElement>();
            for (JsonNode childElementNode : childrenNode) {
                ElementDeserializationResult childDeserializationResult = (ElementDeserializationResult)mapper.readValue(childElementNode.toString(), ElementDeserializationResult.class);
                ChainElement deserializedChild = childDeserializationResult.getElement();
                deserializedChildren.add(deserializedChild);
                if (!CollectionUtils.isEmpty((Map)childDeserializationResult.getElementPropertiesFilenames())) {
                    if (resultDeserializeEntity.getElementPropertiesFilenames() == null) {
                        resultDeserializeEntity.setElementPropertiesFilenames(new HashMap());
                    }
                    resultDeserializeEntity.getElementPropertiesFilenames().putAll(childDeserializationResult.getElementPropertiesFilenames());
                }
                resultDeserializeEntity.getElementToSwimlaneRelations().putAll(childDeserializationResult.getElementToSwimlaneRelations());
            }
            ((ContainerChainElement)resultElement).addChildrenElements(deserializedChildren);
        }
    }
}

