package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationStatus;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationAlertsSet;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.DiagnosticValidationDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationChainEntityDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.diagnostic.ValidationStatusDTO;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.AbstractValidation;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-05T17:48:57+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class DiagnosticValidationMapperImpl implements DiagnosticValidationMapper {

    @Override
    public DiagnosticValidationDTO asDTO(AbstractValidation validation, ValidationStatusDTO status, ValidationAlertsSet alertsSet) {
        if ( validation == null && status == null && alertsSet == null ) {
            return null;
        }

        DiagnosticValidationDTO.DiagnosticValidationDTOBuilder diagnosticValidationDTO = DiagnosticValidationDTO.builder();

        if ( validation != null ) {
            diagnosticValidationDTO.id( validation.getId() );
            diagnosticValidationDTO.title( validation.getTitle() );
            diagnosticValidationDTO.description( validation.getDescription() );
            diagnosticValidationDTO.suggestion( validation.getSuggestion() );
            diagnosticValidationDTO.entityType( validation.getEntityType() );
            diagnosticValidationDTO.implementationType( validation.getImplementationType() );
            diagnosticValidationDTO.severity( validation.getSeverity() );
            diagnosticValidationDTO.properties( stringSerializableMapToStringObjectMap( validation.getProperties() ) );
        }
        if ( alertsSet != null ) {
            diagnosticValidationDTO.alertsCount( alertsSet.getAlertsCount() );
            diagnosticValidationDTO.chainEntities( asChainEntityDTO( alertsSet.getChainAlerts() ) );
        }
        diagnosticValidationDTO.status( status );

        return diagnosticValidationDTO.build();
    }

    @Override
    public ValidationStatusDTO asStatusDTO(ValidationStatus currentStatus) {
        if ( currentStatus == null ) {
            return null;
        }

        ValidationStatusDTO.ValidationStatusDTOBuilder validationStatusDTO = ValidationStatusDTO.builder();

        validationStatusDTO.state( currentStatus.getState() );
        validationStatusDTO.startedWhen( currentStatus.getStartedWhen() );
        validationStatusDTO.message( currentStatus.getMessage() );

        return validationStatusDTO.build();
    }

    @Override
    public List<ValidationChainEntityDTO> asChainEntityDTO(List<ValidationChainAlert> chainEntities) {
        if ( chainEntities == null ) {
            return null;
        }

        List<ValidationChainEntityDTO> list = new ArrayList<ValidationChainEntityDTO>( chainEntities.size() );
        for ( ValidationChainAlert validationChainAlert : chainEntities ) {
            list.add( asChainEntityDTO( validationChainAlert ) );
        }

        return list;
    }

    @Override
    public ValidationChainEntityDTO asChainEntityDTO(ValidationChainAlert entity) {
        if ( entity == null ) {
            return null;
        }

        ValidationChainEntityDTO.ValidationChainEntityDTOBuilder validationChainEntityDTO = ValidationChainEntityDTO.builder();

        validationChainEntityDTO.chainId( entityChainId( entity ) );
        validationChainEntityDTO.chainName( entityChainName( entity ) );
        validationChainEntityDTO.elementId( entityElementId( entity ) );
        validationChainEntityDTO.elementName( entityElementName( entity ) );
        validationChainEntityDTO.elementType( entityElementType( entity ) );
        Map<String, Object> map = entity.getProperties();
        if ( map != null ) {
            validationChainEntityDTO.properties( new LinkedHashMap<String, Object>( map ) );
        }

        return validationChainEntityDTO.build();
    }

    protected Map<String, Object> stringSerializableMapToStringObjectMap(Map<String, Serializable> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, Object> map1 = new LinkedHashMap<String, Object>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, Serializable> entry : map.entrySet() ) {
            String key = entry.getKey();
            Object value = entry.getValue();
            map1.put( key, value );
        }

        return map1;
    }

    private String entityChainId(ValidationChainAlert validationChainAlert) {
        if ( validationChainAlert == null ) {
            return null;
        }
        Chain chain = validationChainAlert.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String entityChainName(ValidationChainAlert validationChainAlert) {
        if ( validationChainAlert == null ) {
            return null;
        }
        Chain chain = validationChainAlert.getChain();
        if ( chain == null ) {
            return null;
        }
        String name = chain.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String entityElementId(ValidationChainAlert validationChainAlert) {
        if ( validationChainAlert == null ) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if ( element == null ) {
            return null;
        }
        String id = element.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String entityElementName(ValidationChainAlert validationChainAlert) {
        if ( validationChainAlert == null ) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if ( element == null ) {
            return null;
        }
        String name = element.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    private String entityElementType(ValidationChainAlert validationChainAlert) {
        if ( validationChainAlert == null ) {
            return null;
        }
        ChainElement element = validationChainAlert.getElement();
        if ( element == null ) {
            return null;
        }
        String type = element.getType();
        if ( type == null ) {
            return null;
        }
        return type;
    }
}
