/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.model.exportimport.system;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.ImportSystemStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.remote.SystemCompareAction;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Schema(description="Result object of service import")
public class ImportSystemResult {
    @Schema(description="Id")
    private String id;
    @Schema(description="Name")
    private String name;
    @Schema(description="Archive name that service were imported from")
    private String archiveName;
    @Schema(description="Timestamp of last modification date")
    private Long modified;
    @Schema(description="Service import status")
    private ImportSystemStatus status;
    @Schema(description="Service import action")
    private SystemCompareAction requiredAction;
    @Schema(description="Type of the service")
    @Deprecated
    private String systemType;
    @Schema(description="Service import instruction action")
    private ImportInstructionAction instructionAction;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Schema(description="Warning or error message (if any)")
    private String message;

    protected ImportSystemResult(ImportSystemResultBuilder<?, ?> b) {
        this.id = b.id;
        this.name = b.name;
        this.archiveName = b.archiveName;
        this.modified = b.modified;
        this.status = b.status;
        this.requiredAction = b.requiredAction;
        this.systemType = b.systemType;
        this.instructionAction = b.instructionAction;
        this.message = b.message;
    }

    public static ImportSystemResultBuilder<?, ?> builder() {
        return new ImportSystemResultBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public Long getModified() {
        return this.modified;
    }

    public ImportSystemStatus getStatus() {
        return this.status;
    }

    public SystemCompareAction getRequiredAction() {
        return this.requiredAction;
    }

    @Deprecated
    public String getSystemType() {
        return this.systemType;
    }

    public ImportInstructionAction getInstructionAction() {
        return this.instructionAction;
    }

    public String getMessage() {
        return this.message;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public void setModified(Long modified) {
        this.modified = modified;
    }

    public void setStatus(ImportSystemStatus status) {
        this.status = status;
    }

    public void setRequiredAction(SystemCompareAction requiredAction) {
        this.requiredAction = requiredAction;
    }

    @Deprecated
    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public void setInstructionAction(ImportInstructionAction instructionAction) {
        this.instructionAction = instructionAction;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ImportSystemResult() {
    }

    public static abstract class ImportSystemResultBuilder<C extends ImportSystemResult, B extends ImportSystemResultBuilder<C, B>> {
        private String id;
        private String name;
        private String archiveName;
        private Long modified;
        private ImportSystemStatus status;
        private SystemCompareAction requiredAction;
        private String systemType;
        private ImportInstructionAction instructionAction;
        private String message;

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this.self();
        }

        public B modified(Long modified) {
            this.modified = modified;
            return this.self();
        }

        public B status(ImportSystemStatus status) {
            this.status = status;
            return this.self();
        }

        public B requiredAction(SystemCompareAction requiredAction) {
            this.requiredAction = requiredAction;
            return this.self();
        }

        @Deprecated
        public B systemType(String systemType) {
            this.systemType = systemType;
            return this.self();
        }

        public B instructionAction(ImportInstructionAction instructionAction) {
            this.instructionAction = instructionAction;
            return this.self();
        }

        public B message(String message) {
            this.message = message;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ImportSystemResult.ImportSystemResultBuilder(id=" + this.id + ", name=" + this.name + ", archiveName=" + this.archiveName + ", modified=" + this.modified + ", status=" + String.valueOf((Object)this.status) + ", requiredAction=" + String.valueOf((Object)this.requiredAction) + ", systemType=" + this.systemType + ", instructionAction=" + String.valueOf(this.instructionAction) + ", message=" + this.message + ")";
        }
    }

    private static final class ImportSystemResultBuilderImpl
    extends ImportSystemResultBuilder<ImportSystemResult, ImportSystemResultBuilderImpl> {
        private ImportSystemResultBuilderImpl() {
        }

        @Override
        protected ImportSystemResultBuilderImpl self() {
            return this;
        }

        @Override
        public ImportSystemResult build() {
            return new ImportSystemResult(this);
        }
    }
}

