/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.persistence.configs.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.sql.Timestamp;
import java.util.UUID;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.converter.ImportResultConverter;

@Entity(name="import_sessions")
public class ImportSession {
    @Id
    private String id;
    @Convert(converter=ImportResultConverter.class)
    private ImportResult result;
    @Column(name="completion_percentage")
    private int completion;
    private String error;
    @Column(name="modified_when")
    private Timestamp modifiedWhen;

    public boolean isDone() {
        return this.completion == 100;
    }

    @PrePersist
    @PreUpdate
    public void specifyModifiedWhen() {
        this.modifiedWhen = new Timestamp(System.currentTimeMillis());
    }

    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    protected ImportSession(ImportSessionBuilder<?, ?> b) {
        this.id = b.id$set ? b.id$value : ImportSession.$default$id();
        this.result = b.result;
        this.completion = b.completion;
        this.error = b.error;
        this.modifiedWhen = b.modifiedWhen;
    }

    public static ImportSessionBuilder<?, ?> builder() {
        return new ImportSessionBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public ImportResult getResult() {
        return this.result;
    }

    public int getCompletion() {
        return this.completion;
    }

    public String getError() {
        return this.error;
    }

    public Timestamp getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setResult(ImportResult result) {
        this.result = result;
    }

    public void setCompletion(int completion) {
        this.completion = completion;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setModifiedWhen(Timestamp modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public ImportSession() {
        this.id = ImportSession.$default$id();
    }

    public static abstract class ImportSessionBuilder<C extends ImportSession, B extends ImportSessionBuilder<C, B>> {
        private boolean id$set;
        private String id$value;
        private ImportResult result;
        private int completion;
        private String error;
        private Timestamp modifiedWhen;

        public B id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this.self();
        }

        public B result(ImportResult result) {
            this.result = result;
            return this.self();
        }

        public B completion(int completion) {
            this.completion = completion;
            return this.self();
        }

        public B error(String error) {
            this.error = error;
            return this.self();
        }

        public B modifiedWhen(Timestamp modifiedWhen) {
            this.modifiedWhen = modifiedWhen;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ImportSession.ImportSessionBuilder(id$value=" + this.id$value + ", result=" + String.valueOf(this.result) + ", completion=" + this.completion + ", error=" + this.error + ", modifiedWhen=" + String.valueOf(this.modifiedWhen) + ")";
        }
    }

    private static final class ImportSessionBuilderImpl
    extends ImportSessionBuilder<ImportSession, ImportSessionBuilderImpl> {
        private ImportSessionBuilderImpl() {
        }

        @Override
        protected ImportSessionBuilderImpl self() {
            return this;
        }

        @Override
        public ImportSession build() {
            return new ImportSession(this);
        }
    }
}

