/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.imports.remote;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RemoteImportEntity {
    private String baseUri;
    private String fileUri;
    private File sourceFile;
    private List<File> exportedFiles;
    private String exportFolder;

    public String getFileName() {
        String result = FilenameUtils.getName((String)this.fileUri);
        if (result.isBlank()) {
            throw new RuntimeException("No filename");
        }
        return result;
    }

    public String getRelativeDirUri() {
        return this.formatUriDir(StringUtils.stripEnd((String)this.fileUri, (String)this.getFileName()));
    }

    public String getFullUri() {
        return this.formatUriDir(this.baseUri) + StringUtils.stripStart((String)this.fileUri, (String)"/");
    }

    public String getFileVersion() {
        String baseName = FilenameUtils.getBaseName((String)this.getFileName());
        int versionIndex = baseName.lastIndexOf(45) + 1;
        if (versionIndex > 0) {
            return baseName.substring(versionIndex);
        }
        return "";
    }

    public String getFileUriWoVersion() {
        String baseName = FilenameUtils.getBaseName((String)this.getFileName());
        if (!this.getFileVersion().isBlank()) {
            return this.getRelativeDirUri() + baseName.substring(0, baseName.lastIndexOf(this.getFileVersion()) - 1) + "." + FilenameUtils.getExtension((String)this.getFileName());
        }
        return this.getRelativeDirUri() + this.getFileName();
    }

    private String formatUriDir(String uri) {
        return StringUtils.stripEnd((String)uri, (String)"/") + "/";
    }

    protected RemoteImportEntity(RemoteImportEntityBuilder<?, ?> b) {
        this.baseUri = b.baseUri;
        this.fileUri = b.fileUri;
        this.sourceFile = b.sourceFile;
        this.exportedFiles = b.exportedFiles;
        this.exportFolder = b.exportFolder;
    }

    public static RemoteImportEntityBuilder<?, ?> builder() {
        return new RemoteImportEntityBuilderImpl();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public List<File> getExportedFiles() {
        return this.exportedFiles;
    }

    public String getExportFolder() {
        return this.exportFolder;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setExportedFiles(List<File> exportedFiles) {
        this.exportedFiles = exportedFiles;
    }

    public void setExportFolder(String exportFolder) {
        this.exportFolder = exportFolder;
    }

    public static abstract class RemoteImportEntityBuilder<C extends RemoteImportEntity, B extends RemoteImportEntityBuilder<C, B>> {
        private String baseUri;
        private String fileUri;
        private File sourceFile;
        private List<File> exportedFiles;
        private String exportFolder;

        public B baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this.self();
        }

        public B fileUri(String fileUri) {
            this.fileUri = fileUri;
            return this.self();
        }

        public B sourceFile(File sourceFile) {
            this.sourceFile = sourceFile;
            return this.self();
        }

        public B exportedFiles(List<File> exportedFiles) {
            this.exportedFiles = exportedFiles;
            return this.self();
        }

        public B exportFolder(String exportFolder) {
            this.exportFolder = exportFolder;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "RemoteImportEntity.RemoteImportEntityBuilder(baseUri=" + this.baseUri + ", fileUri=" + this.fileUri + ", sourceFile=" + String.valueOf(this.sourceFile) + ", exportedFiles=" + String.valueOf(this.exportedFiles) + ", exportFolder=" + this.exportFolder + ")";
        }
    }

    private static final class RemoteImportEntityBuilderImpl
    extends RemoteImportEntityBuilder<RemoteImportEntity, RemoteImportEntityBuilderImpl> {
        private RemoteImportEntityBuilderImpl() {
        }

        @Override
        protected RemoteImportEntityBuilderImpl self() {
            return this;
        }

        @Override
        public RemoteImportEntity build() {
            return new RemoteImportEntity(this);
        }
    }
}

