/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.yaml.snakeyaml.LoaderOptions;

@AutoConfiguration
public class MapperAutoConfiguration {
    private static final int CODE_POINT_LIMIT_MB = 256;

    @Bean(value={"yamlMapper"})
    public YAMLMapper yamlMapper() {
        YAMLMapper yamlMapper = new YAMLMapper(this.createCustomYamlFactory());
        SimpleModule serializeModule = new SimpleModule();
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yamlMapper.registerModule((Module)serializeModule);
        yamlMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        return yamlMapper;
    }

    @Bean(value={"yamlExportImportMapper"})
    public YAMLMapper yamlExportImportMapper() {
        String[] excludedFields = new String[]{"createdWhen", "createdBy", "modifiedBy", "classifier", "classifierV3", "status", "sourceHash"};
        YAMLMapper yamlMapper = new YAMLMapper(this.createCustomYamlFactory());
        SimpleModule serializeModule = new SimpleModule();
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        yamlMapper.registerModule((Module)serializeModule);
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().setFailOnUnknownId(false);
        simpleFilterProvider.addFilter("baseEntityFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])excludedFields));
        yamlMapper.setFilterProvider((FilterProvider)simpleFilterProvider);
        yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return yamlMapper;
    }

    private YAMLFactory createCustomYamlFactory() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x10000000);
        return YAMLFactory.builder().loaderOptions(loaderOptions).build();
    }
}

