/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainRolesDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.ChainRolesMapper;
import org.springframework.stereotype.Component;

@Component
public class ChainRolesMapperImpl
implements ChainRolesMapper {
    public List<ChainRolesDTO> asChainRolesResponses(List<ChainElement> chainElement) {
        if (chainElement == null) {
            return null;
        }
        ArrayList<ChainRolesDTO> list = new ArrayList<ChainRolesDTO>(chainElement.size());
        for (ChainElement chainElement1 : chainElement) {
            list.add(this.asChainRolesResponse(chainElement1));
        }
        return list;
    }

    public ChainRolesDTO asChainRolesResponse(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        ChainRolesDTO.ChainRolesDTOBuilder chainRolesDTO = ChainRolesDTO.builder();
        chainRolesDTO.elementId(chainElement.getId());
        chainRolesDTO.elementName(chainElement.getName());
        Map map = chainElement.getProperties();
        if (map != null) {
            chainRolesDTO.properties(new LinkedHashMap(map));
        }
        chainRolesDTO.modifiedWhen(MapperUtils.fromTimestamp((Timestamp)chainElement.getModifiedWhen()));
        chainRolesDTO.chainId(this.chainElementChainId(chainElement));
        chainRolesDTO.chainName(this.chainElementChainName(chainElement));
        chainRolesDTO.unsavedChanges(this.chainElementChainUnsavedChanges(chainElement));
        return chainRolesDTO.build();
    }

    public DeploymentRequest prepareDeploymentRequest(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        DeploymentRequest.DeploymentRequestBuilder deploymentRequest = DeploymentRequest.builder();
        deploymentRequest.domain(deployment.getDomain());
        deploymentRequest.snapshotId(this.deploymentSnapshotId(deployment));
        deploymentRequest.suspended(Boolean.valueOf(deployment.isSuspended()));
        deploymentRequest.name(deployment.getName());
        return deploymentRequest.build();
    }

    public List<DeploymentRequest> prepareDeploymentRequest(List<Deployment> deployment) {
        if (deployment == null) {
            return null;
        }
        ArrayList<DeploymentRequest> list = new ArrayList<DeploymentRequest>(deployment.size());
        for (Deployment deployment1 : deployment) {
            list.add(this.prepareDeploymentRequest(deployment1));
        }
        return list;
    }

    public DeploymentRequest prepareDeploymentRequest(Snapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        DeploymentRequest.DeploymentRequestBuilder deploymentRequest = DeploymentRequest.builder();
        deploymentRequest.snapshotId(snapshot.getId());
        deploymentRequest.name(snapshot.getName());
        deploymentRequest.description(snapshot.getDescription());
        deploymentRequest.domain("default");
        return deploymentRequest.build();
    }

    private String chainElementChainId(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if (chain == null) {
            return null;
        }
        String id = chain.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String chainElementChainName(ChainElement chainElement) {
        if (chainElement == null) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if (chain == null) {
            return null;
        }
        String name = chain.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private boolean chainElementChainUnsavedChanges(ChainElement chainElement) {
        if (chainElement == null) {
            return false;
        }
        Chain chain = chainElement.getChain();
        if (chain == null) {
            return false;
        }
        boolean unsavedChanges = chain.isUnsavedChanges();
        return unsavedChanges;
    }

    private String deploymentSnapshotId(Deployment deployment) {
        if (deployment == null) {
            return null;
        }
        Snapshot snapshot = deployment.getSnapshot();
        if (snapshot == null) {
            return null;
        }
        String id = snapshot.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

