/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.qubership.integration.platform.catalog.mapping.UserMapper;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineInfo;
import org.qubership.integration.platform.catalog.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.catalog.model.dto.deployment.DeploymentResponse;
import org.qubership.integration.platform.catalog.model.dto.deployment.RuntimeDeploymentState;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.model.deployment.RuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.EngineDeploymentResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.RuntimeDeploymentUpdate;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, uses={UserMapper.class, MapperUtils.class})
public abstract class DeploymentMapper {
    private static final Logger log = LoggerFactory.getLogger(DeploymentMapper.class);
    @Autowired
    private RuntimeDeploymentService runtimeDeploymentService;
    @Autowired
    private SnapshotService snapshotService;
    @Autowired
    private ChainService chainService;

    @Mappings(value={@Mapping(source="snapshot.id", target="snapshotId"), @Mapping(source="chain.id", target="chainId")})
    public abstract DeploymentResponse asResponse(Deployment var1);

    @Mappings(value={@Mapping(source="deployment.id", target="id"), @Mapping(source="deployment.chain.id", target="chainId"), @Mapping(source="deployment.snapshot.id", target="snapshotId"), @Mapping(source="deployment.domain", target="domain"), @Mapping(source="deployment.suspended", target="suspended"), @Mapping(source="state", target="runtime"), @Mapping(source="deployment.name", target="name")})
    public abstract DeploymentResponse asResponse(Deployment var1, RuntimeDeployment var2);

    public List<DeploymentResponse> asResponses(List<Deployment> deploymentEntityEngineList) {
        if (deploymentEntityEngineList == null) {
            return null;
        }
        return deploymentEntityEngineList.stream().map(deployment -> this.asResponse(deployment, this.runtimeDeploymentService.getRuntimeDeployment(deployment.getId()))).collect(Collectors.toList());
    }

    @Mappings(value={@Mapping(source="status", target="status"), @Mapping(source="errorMessage", target="error")})
    public abstract RuntimeDeploymentState toDTO(EngineDeployment var1);

    @Mappings(value={@Mapping(source="deployment.deploymentInfo.deploymentId", target="id"), @Mapping(source="deployment.deploymentInfo.chainId", target="chainId"), @Mapping(source="deployment.deploymentInfo.chainName", target="chainName"), @Mapping(source="deployment.deploymentInfo.chainStatusCode", target="chainStatusCode"), @Mapping(source="deployment.deploymentInfo.snapshotId", target="snapshotId"), @Mapping(source="deployment.errorMessage", target="state.error"), @Mapping(source="deployment.status", target="state.status"), @Mapping(source="engineInfo.host", target="engineHost"), @Mapping(source="engineInfo.domain", target="domain"), @Mapping(source="engineInfo.engineDeploymentName", target="serviceName"), @Mapping(source="loggingInfo.createdWhen", target="createdWhen")})
    public abstract RuntimeDeploymentUpdate toRuntimeUpdate(EngineDeployment var1, EngineInfo var2, DeploymentService.LoggingInfo var3);

    public List<EngineDeploymentResponse> asEngineDeployments(Collection<EngineDeployment> deployments) {
        return deployments.stream().map(arg_0 -> this.asEngineDeployment(arg_0)).collect(Collectors.toList());
    }

    public EngineDeploymentResponse asEngineDeployment(EngineDeployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String chainName = this.chainService.tryFindById(deploymentInfo.getChainId()).map(AbstractEntity::getName).orElse(null);
        String snapshotName = this.snapshotService.tryFindById(deploymentInfo.getSnapshotId()).map(AbstractEntity::getName).orElse(null);
        return EngineDeploymentResponse.builder().id(deploymentInfo.getDeploymentId()).chainId(deploymentInfo.getChainId()).chainName(chainName).snapshotName(snapshotName).state(this.toDTO(deployment)).build();
    }

    @Mapping(source="snapshotId", target="snapshot.id")
    public abstract Deployment asEntity(DeploymentRequest var1);

    public List<Deployment> asEntities(List<DeploymentRequest> request) {
        return request.stream().map(arg_0 -> this.asEntity(arg_0)).collect(Collectors.toList());
    }

    public abstract void merge(@MappingTarget Deployment var1, DeploymentRequest var2);

    public abstract ChainRuntimeDeployment toChainRuntimeDeployment(EngineDeployment var1, String var2);
}

