/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceClientException;
import org.qubership.integration.platform.catalog.exception.ChainDifferenceException;
import org.qubership.integration.platform.catalog.exception.ComparisonEntityNotFoundException;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ChainImportInstructionsConfig;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceRequest;
import org.qubership.integration.platform.catalog.service.difference.ChainDifferenceService;
import org.qubership.integration.platform.catalog.service.difference.EntityDifferenceResult;
import org.qubership.integration.platform.catalog.util.ChainUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainElementExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.DeploymentExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportChainResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportChainsAndInstructionsResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ChainsIgnoreOverrideResult;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportChainPreviewDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequestAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ChainImportException;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DependencyService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.qubership.integration.platform.runtime.catalog.service.EngineService;
import org.qubership.integration.platform.runtime.catalog.service.FolderService;
import org.qubership.integration.platform.runtime.catalog.service.MaskedFieldsService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ChainDeployPrepare;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.instructions.ImportInstructionsService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainExternalEntityMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainFileMigrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ChainImportService {
    private static final Logger log = LoggerFactory.getLogger(ChainImportService.class);
    private static final String CHAINS_HASH_MATCHED_LOG_MESSAGE = "Chain {} fully matched by hash with its existing copy on the instance, hence skipped.";
    private final YAMLMapper yamlMapper;
    private final TransactionTemplate transactionTemplate;
    private final ChainService chainService;
    private final FolderService folderService;
    private final SnapshotService snapshotService;
    private final DeploymentService deploymentService;
    private final EngineService engineService;
    private final ChainExternalEntityMapper chainExternalEntityMapper;
    private final ImportSessionService importProgressService;
    private final ActionsLogService actionsLogService;
    private final DependencyService dependencyService;
    private final ElementService elementService;
    private final MaskedFieldsService maskedFieldsService;
    private final ChainDifferenceService chainDifferenceService;
    private final ImportInstructionsService importInstructionsService;
    private final ChainFileMigrationService chainFileMigrationService;
    @Value(value="${qip.build.artifact-descriptor-version}")
    private String artifactDescriptorVersion;

    @Autowired
    public ChainImportService(YAMLMapper yamlMapper, TransactionTemplate transactionTemplate, ChainService chainService, FolderService folderService, SnapshotService snapshotService, DeploymentService deploymentService, EngineService engineService, ChainExternalEntityMapper chainExternalEntityMapper, ImportSessionService importProgressService, ActionsLogService actionsLogService, DependencyService dependencyService, ElementService elementService, MaskedFieldsService maskedFieldsService, ChainDifferenceService chainDifferenceService, ImportInstructionsService importInstructionsService, ChainFileMigrationService chainFileMigrationService) {
        this.yamlMapper = yamlMapper;
        this.transactionTemplate = transactionTemplate;
        this.chainService = chainService;
        this.folderService = folderService;
        this.snapshotService = snapshotService;
        this.deploymentService = deploymentService;
        this.engineService = engineService;
        this.chainExternalEntityMapper = chainExternalEntityMapper;
        this.importProgressService = importProgressService;
        this.actionsLogService = actionsLogService;
        this.dependencyService = dependencyService;
        this.elementService = elementService;
        this.maskedFieldsService = maskedFieldsService;
        this.chainDifferenceService = chainDifferenceService;
        this.importInstructionsService = importInstructionsService;
        this.chainFileMigrationService = chainFileMigrationService;
    }

    public List<ImportChainPreviewDTO> getChainsImportPreview(File importDirectory, ChainImportInstructionsConfig instructionsConfig) {
        Object[] chainDirs = new File(String.valueOf(importDirectory) + File.separator + "chains").listFiles(File::isDirectory);
        if (ArrayUtils.isEmpty((Object[])chainDirs)) {
            return Collections.emptyList();
        }
        ArrayList<ImportChainPreviewDTO> importChainPreviewDTOS = new ArrayList<ImportChainPreviewDTO>();
        for (Object chainDir : chainDirs) {
            importChainPreviewDTOS.add(this.restoreChainsFromDirForPreview((File)chainDir, instructionsConfig));
        }
        return importChainPreviewDTOS;
    }

    public EntityDifferenceResult compareChains(File importDirectory, ChainDifferenceRequest diffRequest) {
        Chain rightChain;
        Object[] chainDirs = new File(String.valueOf(importDirectory) + File.separator + "chains").listFiles(File::isDirectory);
        if (ArrayUtils.isEmpty((Object[])chainDirs)) {
            throw new ChainDifferenceClientException("Imported chain directory not found for compare");
        }
        File chainDir = (File)Optional.ofNullable(chainDirs).map(Stream::of).flatMap(dirsStream -> dirsStream.filter(dir -> StringUtils.equals((CharSequence)dir.getName(), (CharSequence)diffRequest.getRightChainId())).findFirst()).orElseThrow(() -> new ChainDifferenceClientException("Imported chain with id " + diffRequest.getRightChainId() + " not found in the archive"));
        try {
            String chainYAML = Files.readString(this.getChainYAMLFile(chainDir).toPath());
            chainYAML = this.migrateToActualFileVersion(chainYAML);
            ChainExternalEntity chainExternalEntity = (ChainExternalEntity)this.yamlMapper.readValue(chainYAML, ChainExternalEntity.class);
            rightChain = this.chainExternalEntityMapper.toInternalEntity(ChainExternalMapperEntity.builder().chainExternalEntity(chainExternalEntity).chainFilesDirectory(chainDir).build());
        }
        catch (Exception e) {
            throw new ChainDifferenceException("Exception while converting " + diffRequest.getRightChainId() + " chain for compare", (Throwable)e);
        }
        if (diffRequest.getLeftSnapshotId() == null) {
            return this.chainDifferenceService.findChainsDifferences((Chain)this.chainService.tryFindById(diffRequest.getLeftChainId()).orElseThrow(() -> new ComparisonEntityNotFoundException("Can't find chain with id: " + diffRequest.getLeftChainId())), rightChain);
        }
        return this.chainDifferenceService.findChainsDifferences((Snapshot)this.snapshotService.tryFindById(diffRequest.getLeftSnapshotId()).orElseThrow(() -> new ComparisonEntityNotFoundException("Can't find snapshot with id: " + diffRequest.getLeftSnapshotId())), rightChain);
    }

    public ImportChainsAndInstructionsResult importChains(File importDirectory, List<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels, boolean validateByHash) {
        ImportChainsAndInstructionsResult importResult = this.restoreChainsFromDir(importDirectory, new ArrayList<ChainCommitRequest>(commitRequests), importId, technicalLabels, validateByHash);
        this.makeDeployActions(importResult.chainResults(), commitRequests, importId, technicalLabels);
        return importResult;
    }

    private ImportChainPreviewDTO restoreChainsFromDirForPreview(File chainDir, ChainImportInstructionsConfig importInstructionsConfig) {
        ImportChainPreviewDTO importChainPreview;
        try {
            File chainYAMLFile = this.getChainYAMLFile(chainDir);
            String chainYaml = this.migrateToActualFileVersion(Files.readString(chainYAMLFile.toPath()));
            ChainExternalEntity chainExternalEntity = (ChainExternalEntity)this.yamlMapper.readValue(chainYaml, ChainExternalEntity.class);
            HashSet usedSystemIds = new HashSet();
            this.collectUsedSystemIds(chainExternalEntity.getContent().getElements(), usedSystemIds);
            Boolean chainExists = this.chainService.exists(chainExternalEntity.getId());
            ImportInstructionAction instructionAction = null;
            if (importInstructionsConfig.getIgnore().contains(chainExternalEntity.getId())) {
                instructionAction = ImportInstructionAction.IGNORE;
            } else if (importInstructionsConfig.getOverride().stream().anyMatch(override -> chainExternalEntity.getId().equals(override.getId()))) {
                instructionAction = ImportInstructionAction.OVERRIDE;
            }
            importChainPreview = ImportChainPreviewDTO.builder().id(chainExternalEntity.getId()).name(chainExternalEntity.getName()).usedSystems(usedSystemIds).deployments(chainExternalEntity.getContent().getDeployments()).deployAction(chainExternalEntity.getContent().getDeployAction()).instructionAction(instructionAction).exists(chainExists).build();
        }
        catch (ChainImportException e) {
            log.warn("Error while chain import: ", (Throwable)e);
            importChainPreview = new ImportChainPreviewDTO();
            importChainPreview.setId(e.getChainId());
            importChainPreview.setName(e.getChainName());
            importChainPreview.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            importChainPreview = new ImportChainPreviewDTO();
            importChainPreview.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return importChainPreview;
    }

    private void collectUsedSystemIds(List<ChainElementExternalEntity> elementExternalEntities, Set<String> usedSystemIds) {
        for (ChainElementExternalEntity elementExternalEntity : elementExternalEntities) {
            String integrationSystemId;
            if (CollectionUtils.isNotEmpty((Collection)elementExternalEntity.getChildren())) {
                this.collectUsedSystemIds(elementExternalEntity.getChildren(), usedSystemIds);
            }
            if ((integrationSystemId = (String)elementExternalEntity.getProperties().get("integrationSystemId")) == null) continue;
            usedSystemIds.add(integrationSystemId);
        }
    }

    private ImportChainsAndInstructionsResult restoreChainsFromDir(File importDirectory, ArrayList<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels, boolean validateByHash) {
        ArrayList<ImportChainResult> importChainResults = new ArrayList<ImportChainResult>();
        File[] chainFilesDirectories = (importDirectory = new File(importDirectory, "chains")).listFiles(File::isDirectory);
        if (chainFilesDirectories == null) {
            return new ImportChainsAndInstructionsResult();
        }
        ChainsIgnoreOverrideResult chainsIgnoreOverrideResult = this.importInstructionsService.performChainIgnoreOverrideInstructions((Collection)Stream.of(chainFilesDirectories).map(File::getName).collect(Collectors.toSet()));
        Map chainsToImport = chainsIgnoreOverrideResult.chainsToImport();
        Map overridesMapping = chainsIgnoreOverrideResult.overridesMapping();
        int total = chainFilesDirectories.length;
        int counter = 0;
        for (File chainFilesDir : chainFilesDirectories) {
            String chainId = chainFilesDir.getName();
            if (!chainsToImport.containsKey(chainId)) {
                importChainResults.add(ImportChainResult.builder().id(chainId).status(ImportEntityStatus.IGNORED).deployAction(ChainCommitRequestAction.NONE).build());
                log.info("Chain {} ignored as a part of import instructions list", (Object)chainId);
                continue;
            }
            Pair overridesPair = overridesMapping.entrySet().stream().filter(pair -> chainId.equals(pair.getKey()) || chainId.equals(pair.getValue())).findFirst().map(pair -> Pair.of((Object)((String)pair.getKey()), (Object)((String)pair.getValue()))).orElse(null);
            this.importProgressService.calculateImportStatus(importId, total, counter, 30, 60);
            ++counter;
            ImportChainResult chainResult = this.restoreOneChainFromDir(chainFilesDir, commitRequests, technicalLabels, overridesPair, validateByHash);
            if (chainResult == null) continue;
            importChainResults.add(chainResult);
            ChainCommitRequestAction deployAction = (ChainCommitRequestAction)chainsToImport.get(chainId);
            if (deployAction == null) continue;
            commitRequests.stream().filter(commitRequest -> chainId.equals(commitRequest.getId())).findFirst().ifPresentOrElse(commitRequest -> commitRequest.setDeployAction(deployAction), () -> commitRequests.add(ChainCommitRequest.builder().id(chainId).deployAction(deployAction).build()));
        }
        return new ImportChainsAndInstructionsResult(importChainResults, chainsIgnoreOverrideResult.chainImportInstructionResults());
    }

    private ImportChainResult restoreOneChainFromDir(File chainFilesDir, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels, Pair<String, String> overridesPair, boolean validateByHash) {
        ImportChainResult importChainResult = null;
        ChainExternalEntity chainExternalEntity = null;
        try {
            String chainYAML = Files.readString(this.getChainYAMLFile(chainFilesDir).toPath());
            chainYAML = this.migrateToActualFileVersion(chainYAML);
            chainExternalEntity = (ChainExternalEntity)this.yamlMapper.readValue(chainYAML, ChainExternalEntity.class);
            String chainId = chainExternalEntity.getId();
            String externalHash = ChainUtils.getChainFilesHash((File)chainFilesDir, (String)this.artifactDescriptorVersion);
            if (this.isSameHash(chainId, externalHash) && validateByHash) {
                log.warn("Chain {} fully matched by hash with its existing copy on the instance, hence skipped.", (Object)chainId);
                importChainResult = new ImportChainResult();
                importChainResult.setId(chainId);
                importChainResult.setName(chainExternalEntity.getName());
                importChainResult.setStatus(ImportEntityStatus.SKIPPED);
                return importChainResult;
            }
            if (this.shouldCommitChain(commitRequests, chainId)) {
                if (overridesPair != null) {
                    Set<String> set = technicalLabels = technicalLabels != null ? new HashSet<String>(technicalLabels) : new HashSet();
                    if (chainId.equals(overridesPair.getKey())) {
                        chainExternalEntity.getContent().setOverridesChainId((String)overridesPair.getValue());
                        technicalLabels.add("Overrides");
                    }
                    if (chainId.equals(overridesPair.getValue())) {
                        chainExternalEntity.getContent().setOverridden(true);
                        chainExternalEntity.getContent().setOverriddenByChainId((String)overridesPair.getKey());
                        technicalLabels.add("Overridden");
                    }
                }
                chainExternalEntity.getContent().setLastImportHash(externalHash);
                importChainResult = this.saveChainInTransaction(chainExternalEntity, chainFilesDir, technicalLabels);
            }
        }
        catch (ChainImportException e) {
            log.warn("Exception while importing {} ({}) chain: ", new Object[]{e.getChainName(), e.getChainId(), e});
            importChainResult = new ImportChainResult();
            importChainResult.setStatus(ImportEntityStatus.ERROR);
            importChainResult.setId(e.getChainId());
            importChainResult.setName(e.getChainName());
            importChainResult.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            importChainResult = new ImportChainResult();
            if (chainExternalEntity != null) {
                importChainResult.setId(chainExternalEntity.getId());
                importChainResult.setName(chainExternalEntity.getName());
            }
            importChainResult.setStatus(ImportEntityStatus.ERROR);
            importChainResult.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return importChainResult;
    }

    private boolean shouldCommitChain(List<ChainCommitRequest> commitRequests, String chainId) {
        return CollectionUtils.isEmpty(commitRequests) || commitRequests.stream().anyMatch(request -> Objects.equals(request.getId(), chainId));
    }

    private boolean isSameHash(String chainId, String externalHash) {
        String internalHash = this.chainService.getChainHash(chainId);
        return externalHash.equals(internalHash);
    }

    private ImportChainResult saveChainInTransaction(ChainExternalEntity chainExternalEntity, File chainFilesDir, Set<String> technicalLabels) {
        return (ImportChainResult)this.transactionTemplate.execute(status -> this.saveImportedChain(chainExternalEntity, chainFilesDir, technicalLabels));
    }

    public ImportChainResult saveImportedChain(ChainExternalEntity chainExternalEntity, File chainFilesDir, Set<String> technicalLabels) {
        Chain currentChainState = this.chainService.tryFindById(chainExternalEntity.getId()).orElse(null);
        ImportEntityStatus importStatus = currentChainState != null ? ImportEntityStatus.UPDATED : ImportEntityStatus.CREATED;
        Folder existingFolder = null;
        if (chainExternalEntity.getContent().getFolder() != null) {
            existingFolder = this.folderService.findFirstByName(chainExternalEntity.getContent().getFolder().getName(), null);
        }
        Chain newChainState = this.chainExternalEntityMapper.toInternalEntity(ChainExternalMapperEntity.builder().chainExternalEntity(chainExternalEntity).existingChain(currentChainState).existingFolder(existingFolder).chainFilesDirectory(chainFilesDir).build());
        ChainImportService.replaceTechnicalLabels(technicalLabels, (Chain)newChainState);
        newChainState.setUnsavedChanges(true);
        this.setActualChainState(existingFolder, currentChainState, newChainState);
        this.logImportAction(newChainState, LogOperation.CREATE_OR_UPDATE);
        this.chainService.clearContext();
        return ImportChainResult.builder().id(newChainState.getId()).name(newChainState.getName()).deployAction(chainExternalEntity.getContent().getDeployAction()).deployments(chainExternalEntity.getContent().getDeployments()).status(importStatus).build();
    }

    public static void replaceTechnicalLabels(Set<String> technicalLabels, Chain chain) {
        if (!CollectionUtils.isEmpty(technicalLabels)) {
            chain.getLabels().removeIf(label -> label.isTechnical() && !technicalLabels.contains(label.getName()));
            Set currentChainTechnicalLabels = chain.getLabels().stream().filter(AbstractLabel::isTechnical).map(AbstractLabel::getName).collect(Collectors.toSet());
            Set<String> technicalLabelsToAdd = technicalLabels.stream().filter(labelName -> !currentChainTechnicalLabels.contains(labelName)).collect(Collectors.toSet());
            technicalLabelsToAdd.forEach(labelName -> chain.addLabel(new ChainLabel(labelName, chain, true)));
        } else {
            chain.getLabels().removeIf(AbstractLabel::isTechnical);
        }
    }

    protected String migrateToActualFileVersion(String fileContent) throws Exception {
        return this.chainFileMigrationService.migrateToActualVersion(fileContent);
    }

    private File getChainYAMLFile(File chainDir) {
        Object[] chainFiles = chainDir.listFiles((dir, fileName) -> fileName.startsWith("chain-") && fileName.endsWith(".yaml"));
        if (ArrayUtils.isEmpty((Object[])chainFiles)) {
            throw new RuntimeException("Directory " + chainDir.getName() + " does not contain chain YAML file");
        }
        return chainFiles[0];
    }

    private void makeDeployActions(List<ImportChainResult> chainsResult, List<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels) {
        ArrayList<ChainDeployPrepare> preparedDeployments = new ArrayList<ChainDeployPrepare>();
        int total = chainsResult.size();
        int counter = 0;
        for (ImportChainResult chainResult : chainsResult) {
            this.importProgressService.calculateImportStatus(importId, total, counter, 60, 80);
            ++counter;
            if (chainResult.getStatus() == ImportEntityStatus.ERROR || chainResult.getStatus() == ImportEntityStatus.IGNORED) continue;
            ChainCommitRequest request = null;
            if (!CollectionUtils.isEmpty(commitRequests) && ((request = (ChainCommitRequest)commitRequests.stream().filter(cRequest -> StringUtils.equals((CharSequence)cRequest.getId(), (CharSequence)chainResult.getId())).findAny().orElse(null)) == null || request.getDeployAction() == ChainCommitRequestAction.NONE)) continue;
            try {
                Snapshot snapshot = this.snapshotService.build(chainResult.getId(), technicalLabels);
                if (request != null) {
                    if (request.getDeployAction() == ChainCommitRequestAction.SNAPSHOT) continue;
                    if (request.getDeployAction() == ChainCommitRequestAction.DEPLOY && CollectionUtils.isNotEmpty((Collection)request.getDomains())) {
                        List deployments = request.getDomains().stream().map(domain -> DeploymentExternalEntity.builder().domain(domain.getName()).build()).collect(Collectors.toList());
                        chainResult.setDeployments(deployments);
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)chainResult.getDeployments())) continue;
                preparedDeployments.add(new ChainDeployPrepare(chainResult, snapshot));
            }
            catch (Exception e) {
                chainResult.setStatus(ImportEntityStatus.ERROR);
                chainResult.setErrorMessage("Chain is saved but without snapshot: " + e.getMessage());
            }
        }
        this.deployChains(preparedDeployments, importId);
    }

    private void deployChains(List<ChainDeployPrepare> chainsToDeploy, String importId) {
        ArrayList oldDeploysList = new ArrayList();
        int total = chainsToDeploy.size();
        int counter = 0;
        for (ChainDeployPrepare entity : chainsToDeploy) {
            String chainId = entity.getImportChainResult().getId();
            oldDeploysList.addAll(this.deploymentService.findAllByChainId(chainId));
        }
        for (ChainDeployPrepare entity : chainsToDeploy) {
            this.importProgressService.calculateImportStatus(importId, total, counter, 80, 100);
            ++counter;
            ImportChainResult importChainResult = entity.getImportChainResult();
            Snapshot snapshot = entity.getSnapshot();
            List deployments = importChainResult.getDeployments();
            if (CollectionUtils.isEmpty((Collection)deployments)) continue;
            try {
                for (DeploymentExternalEntity deployment : deployments) {
                    if (this.engineService.isDevMode() || this.engineService.getDomainByName(deployment.getDomain()) != null) {
                        this.createDeployment(snapshot, oldDeploysList, deployment);
                        continue;
                    }
                    importChainResult.setStatus(ImportEntityStatus.ERROR);
                    importChainResult.setErrorMessage("Chain is saved but not deployed: domain " + deployment.getDomain() + " doesn't exists");
                }
            }
            catch (Exception e) {
                log.error("Unable to deploy chain {} {}", (Object)importChainResult.getId(), (Object)e.getMessage());
                importChainResult.setStatus(ImportEntityStatus.ERROR);
                importChainResult.setErrorMessage("Chain is saved but not deployed: " + e.getMessage());
            }
        }
    }

    private void createDeployment(Snapshot snapshot, List<Deployment> excludeDeployments, DeploymentExternalEntity deployment) {
        Deployment deploymentConfig = new Deployment();
        deploymentConfig.setDomain(deployment.getDomain());
        this.deploymentService.create(deploymentConfig, snapshot.getChain(), snapshot, excludeDeployments);
    }

    private void setActualChainState(Folder currentFolder, Chain currentChainState, Chain newChainState) {
        this.dependencyService.setActualizedElementDependencyStates(currentChainState != null ? currentChainState.getDependencies() : Collections.emptySet(), newChainState.getDependencies());
        this.elementService.setActualizedChainElements(currentChainState != null ? currentChainState.getElements() : Collections.emptyList(), newChainState.getElements());
        this.maskedFieldsService.setActualizedMaskedFields(currentChainState != null ? currentChainState.getMaskedFields() : Collections.emptySet(), newChainState.getMaskedFields());
        this.chainService.setActualizedChainState(currentChainState, newChainState);
        if (currentFolder == null && newChainState.getParentFolder() != null) {
            newChainState.setParentFolder(this.folderService.setActualizedFolderState(newChainState.getParentFolder()));
        }
    }

    private void logImportAction(@NonNull Chain chain, LogOperation operation) {
        this.actionsLogService.logAction(ActionLog.builder().entityType(EntityType.CHAINS).entityName(chain.getName()).operation(operation).entityId(chain.getId()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).build());
    }

    @Deprecated(since="2023.4")
    public List<ImportChainResult> restoreChainsFromDirBackward(File importDirectory, List<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels) {
        return this.restoreChainsFromDir(importDirectory, new ArrayList<ChainCommitRequest>(commitRequests), importId, technicalLabels, false).chainResults();
    }

    @Deprecated(since="2023.4")
    public void saveImportedChainBackward(Chain importedChain) {
        Chain currentChainState = this.chainService.tryFindById(importedChain.getId()).orElse(null);
        Folder existingFolder = null;
        if (importedChain.getParentFolder() != null) {
            existingFolder = this.folderService.findEntityByIdOrNull(importedChain.getParentFolder().getId());
        }
        if (currentChainState != null) {
            ChainUtils.chainPropertiesInitialization((Chain)currentChainState);
        }
        this.setActualChainState(existingFolder, currentChainState, importedChain);
    }
}

