/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.context.RequestIdContext;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ChainRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.ImportResult;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.DeploymentExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportChainResult;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.ImportSession;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportChainPreviewDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportPreviewDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.engine.ImportDomainDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequestAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCompareDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ChainImportException;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.EngineService;
import org.qubership.integration.platform.runtime.catalog.service.FolderService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ChainImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ChainDeployPrepare;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.entity.ChainDeserializationResult;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainExternalEntityMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainFileMigrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Deprecated(since="2023.4")
public class ImportService {
    private static final Logger log = LoggerFactory.getLogger(ImportService.class);
    private final ChainExternalEntityMapper chainExternalEntityMapper;
    private final YAMLMapper yamlMapper;
    private final ObjectMapper objectMapper;
    protected final ActionsLogService actionLogger;
    private final DeploymentService deploymentService;
    protected final SnapshotService snapshotService;
    private final EngineService engineService;
    private final ChainService chainService;
    private final FolderService folderService;
    private final ImportSessionService importProgressService;
    private final ChainImportService chainImportService;
    protected final ChainRepository chainRepository;
    private final TransactionTemplate transactionTemplate;
    private final ChainFileMigrationService chainFileMigrationService;
    private static final short ASYNC_IMPORT_PERCENTAGE_THRESHOLD = 40;
    private static final short ASYNC_SNAPSHOT_BUILD_PERCENTAGE_THRESHOLD = 90;

    @Autowired
    public ImportService(ChainExternalEntityMapper chainExternalEntityMapper, YAMLMapper yamlMapper, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, ActionsLogService actionLogger, DeploymentService deploymentService, SnapshotService snapshotService, EngineService engineService, ChainService chainService, FolderService folderService, ChainRepository chainRepository, ImportSessionService importProgressService, ChainImportService chainImportService, TransactionTemplate transactionTemplate, ChainFileMigrationService chainFileMigrationService) {
        this.chainExternalEntityMapper = chainExternalEntityMapper;
        this.objectMapper = objectMapper;
        this.yamlMapper = yamlMapper;
        this.actionLogger = actionLogger;
        this.deploymentService = deploymentService;
        this.snapshotService = snapshotService;
        this.engineService = engineService;
        this.chainService = chainService;
        this.folderService = folderService;
        this.chainRepository = chainRepository;
        this.importProgressService = importProgressService;
        this.chainImportService = chainImportService;
        this.transactionTemplate = transactionTemplate;
        this.chainFileMigrationService = chainFileMigrationService;
    }

    public ImportPreviewDTO importFileAsPreview(MultipartFile file) {
        ImportPreviewDTO response;
        block14: {
            String fileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename());
            if (log.isDebugEnabled()) {
                log.debug("File has '{}' extension", (Object)fileExtension);
            }
            response = new ImportPreviewDTO();
            if ("zip".equals(fileExtension)) {
                try (InputStream is = file.getInputStream();){
                    response = this.importZIPAsPreview(is);
                    break block14;
                }
                catch (Exception e) {
                    log.warn("Exception while extract files from zip: ", (Throwable)e);
                    response.setErrorMessage("Exception while extract files from zip: " + e.getMessage());
                    return response;
                }
            }
            if ("yaml".equals(fileExtension)) {
                try {
                    ImportChainPreviewDTO previewChainDTO = this.restoreChainPreviewFromYaml(this.getFileContent(file));
                    response.setChains(Collections.singletonList(previewChainDTO));
                }
                catch (Exception e) {
                    log.warn("Exception while chain import: ", (Throwable)e);
                    response.setErrorMessage("Exception while chain import: " + e.getMessage());
                }
            } else {
                log.warn("Unknown type of file: {}", (Object)file.getOriginalFilename());
                response.setErrorMessage("Unknown type of file: " + file.getOriginalFilename());
            }
        }
        return response;
    }

    public ImportChainPreviewDTO restoreChainPreviewFromDir(File chainFilesDir) {
        ImportChainPreviewDTO resultImportChainPreviewDTO;
        try {
            String chainYAML = Files.readString(this.getChainYAMLFile(chainFilesDir).toPath());
            resultImportChainPreviewDTO = this.restoreChainPreviewFromYaml(chainYAML);
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            resultImportChainPreviewDTO = new ImportChainPreviewDTO();
            resultImportChainPreviewDTO.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return resultImportChainPreviewDTO;
    }

    public ImportChainPreviewDTO restoreChainPreviewFromYaml(String yaml) {
        ImportChainPreviewDTO resultImportChainPreviewDTO;
        Set usedSystems = Collections.emptySet();
        try {
            yaml = this.migrateToActualFileVersion(yaml);
            resultImportChainPreviewDTO = (ImportChainPreviewDTO)this.yamlMapper.readValue(yaml, ImportChainPreviewDTO.class);
            JsonNode elementsNode = this.yamlMapper.readTree(yaml).get("elements");
            if (elementsNode != null) {
                usedSystems = this.getUsedSystemIdsFromNode(elementsNode);
            }
            resultImportChainPreviewDTO.setUsedSystems(usedSystems);
            ChainCommitRequestAction commitAction = CollectionUtils.isEmpty((Collection)resultImportChainPreviewDTO.getDeployments()) ? ChainCommitRequestAction.SNAPSHOT : ChainCommitRequestAction.DEPLOY;
            resultImportChainPreviewDTO.setDeployAction(commitAction);
        }
        catch (ChainImportException e) {
            log.warn("Error while chain import: ", (Throwable)e);
            resultImportChainPreviewDTO = new ImportChainPreviewDTO();
            resultImportChainPreviewDTO.setId(e.getChainId());
            resultImportChainPreviewDTO.setName(e.getChainName());
            resultImportChainPreviewDTO.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            resultImportChainPreviewDTO = new ImportChainPreviewDTO();
            resultImportChainPreviewDTO.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return resultImportChainPreviewDTO;
    }

    protected Set<String> getUsedSystemIdsFromNode(JsonNode elementsNode) {
        HashSet<String> usedSystems = new HashSet<String>();
        for (JsonNode element : elementsNode) {
            JsonNode integrationSystemId;
            JsonNode properties;
            JsonNode children = element.get("children");
            if (children != null) {
                usedSystems.addAll(this.getUsedSystemIdsFromNode(children));
            }
            if ((properties = element.get("properties")) == null || (integrationSystemId = properties.get("integrationSystemId")) == null || StringUtils.isBlank((CharSequence)integrationSystemId.asText())) continue;
            usedSystems.add(integrationSystemId.asText());
        }
        return usedSystems;
    }

    public String importFileAsync(MultipartFile file, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels) {
        String importId = UUID.randomUUID().toString();
        this.importProgressService.deleteObsoleteImportSessionStatuses();
        this.importProgressService.setImportProgressPercentage(importId, 0);
        File unpackDirectory = null;
        try (InputStream is = file.getInputStream();){
            unpackDirectory = this.unpackZIP(is);
        }
        catch (Exception e) {
            ExportImportUtils.deleteFile(unpackDirectory);
            log.warn("Exception while extract files from zip", (Throwable)e);
            throw new RuntimeException("Exception while extract files from zip", e);
        }
        this.logImportAction(null, file.getOriginalFilename(), LogOperation.IMPORT);
        String requestId = RequestIdContext.get();
        File finalUnpackDirectory = unpackDirectory;
        CompletableFuture.supplyAsync(() -> {
            RequestIdContext.set((String)requestId);
            ImportDTO response = this.restoreChainsFromDir(finalUnpackDirectory, commitRequests, importId, technicalLabels);
            this.makeDeployActions(response.getChains(), commitRequests, importId, technicalLabels);
            return response;
        }).whenCompleteAsync((result, throwable) -> {
            RequestIdContext.set((String)requestId);
            this.importAsyncComplete(importId, result, finalUnpackDirectory, throwable);
        });
        return importId;
    }

    private void importAsyncComplete(String importId, ImportDTO importResult, File unpackDirectory, Throwable throwable) {
        ExportImportUtils.deleteFile((File)unpackDirectory);
        ImportSession importSession = new ImportSession();
        importSession.setId(importId);
        importSession.setCompletion(100);
        if (importResult != null) {
            List importChainResults = importResult.getChains().stream().map(chainDTO -> ImportChainResult.builder().id(chainDTO.getId()).name(chainDTO.getName()).deployAction(chainDTO.getDeployAction()).status(chainDTO.getStatus()).deployments(chainDTO.getDeployments()).errorMessage(chainDTO.getErrorMessage()).build()).collect(Collectors.toList());
            importSession.setResult(ImportResult.builder().chains(importChainResults).build());
            String errorMessage = importResult.getErrorMessage();
            if (!StringUtils.isBlank((CharSequence)errorMessage)) {
                importSession.setError(errorMessage);
                log.warn("Error async importing file {}", (Object)errorMessage);
            }
        }
        if (throwable != null) {
            importSession.setError(throwable.getMessage());
            log.warn("Error async importing file", throwable);
        }
        this.importProgressService.saveImportSession(importSession);
    }

    @Nullable
    public List<ImportChainResult> getImportAsyncResult(String importId) {
        ImportSession importSession = this.importProgressService.getImportSession(importId);
        if (importSession != null && !StringUtils.isBlank((CharSequence)importSession.getError())) {
            throw new RuntimeException(importSession.getError());
        }
        return importSession == null || importSession.getResult() == null ? null : importSession.getResult().getChains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportDTO importFile(MultipartFile file, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels) {
        ImportDTO response;
        block16: {
            String fileExtension;
            block17: {
                fileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename());
                if (log.isDebugEnabled()) {
                    log.debug("File has '{}' extension", (Object)fileExtension);
                }
                response = new ImportDTO();
                if (!"zip".equals(fileExtension)) break block17;
                File unpackDirectory = null;
                try (InputStream is = file.getInputStream();){
                    unpackDirectory = this.unpackZIP(is);
                    this.logImportAction(null, file.getOriginalFilename(), LogOperation.IMPORT);
                    response.setChains(this.chainImportService.restoreChainsFromDirBackward(unpackDirectory, commitRequests, null, technicalLabels));
                    this.makeDeployActions(response.getChains(), commitRequests, null, technicalLabels);
                }
                catch (Exception e) {
                    try {
                        log.warn("Exception while extract files from zip: ", (Throwable)e);
                        response.setErrorMessage("Exception while extract files from zip: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        ExportImportUtils.deleteFile(unpackDirectory);
                        throw throwable;
                    }
                    ExportImportUtils.deleteFile((File)unpackDirectory);
                    break block16;
                }
                ExportImportUtils.deleteFile((File)unpackDirectory);
                break block16;
            }
            if ("yaml".equals(fileExtension)) {
                try {
                    this.logImportAction(null, file.getOriginalFilename(), LogOperation.IMPORT);
                    ImportChainResult importChainDTO = this.restoreChainFromYaml(this.getFileContent(file), null, null, technicalLabels);
                    response.setChains(this.makeDeployActions(importChainDTO, commitRequests, technicalLabels));
                }
                catch (Exception e) {
                    log.warn("Exception while chain import: ", (Throwable)e);
                    response.setErrorMessage("Exception while chain import: " + e.getMessage());
                }
            } else {
                log.warn("Unknown type of file: {}", (Object)file.getOriginalFilename());
                response.setErrorMessage("Unknown type of file: " + file.getOriginalFilename());
            }
        }
        return response;
    }

    private List<ImportChainResult> makeDeployActions(ImportChainResult chainDTO, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels) {
        return this.makeDeployActions(Collections.singletonList(chainDTO), commitRequests, null, technicalLabels);
    }

    private List<ImportChainResult> makeDeployActions(List<ImportChainResult> chainDTOs, List<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels) {
        ArrayList<ChainDeployPrepare> preparedDeployments = new ArrayList<ChainDeployPrepare>();
        int total = chainDTOs.size();
        int counter = 0;
        for (ImportChainResult chainDTO : chainDTOs) {
            this.calculateSnapshotAsyncStatus(importId, total, counter);
            ++counter;
            if (chainDTO.getStatus() == ImportEntityStatus.ERROR) continue;
            ChainCommitRequest request = null;
            if (!CollectionUtils.isEmpty(commitRequests) && ((request = (ChainCommitRequest)commitRequests.stream().filter(creq -> creq.getId().equals(chainDTO.getId())).findAny().orElse(null)) == null || request.getDeployAction() == ChainCommitRequestAction.NONE)) continue;
            try {
                Snapshot snapshot = this.snapshotService.build(chainDTO.getId(), technicalLabels);
                this.mergeDeploymentInfo(chainDTO, request);
                if (chainDTO.getDeployAction() != ChainCommitRequestAction.DEPLOY || CollectionUtils.isEmpty((Collection)chainDTO.getDeployments())) continue;
                preparedDeployments.add(new ChainDeployPrepare(chainDTO, snapshot));
            }
            catch (Exception e) {
                chainDTO.setStatus(ImportEntityStatus.ERROR);
                chainDTO.setErrorMessage("Chain is saved but without snapshot: " + e.getMessage());
            }
        }
        this.deployChains(preparedDeployments, importId);
        return chainDTOs;
    }

    private void mergeDeploymentInfo(ImportChainResult chainDTO, ChainCommitRequest apiRequest) {
        chainDTO.setDeployAction(this.getResultingDeployAction(chainDTO, apiRequest));
        if (!ChainCommitRequestAction.DEPLOY.equals((Object)chainDTO.getDeployAction())) {
            chainDTO.setDeployments(Collections.emptyList());
            return;
        }
        this.mergeLoggingInfo(chainDTO, apiRequest);
    }

    private void mergeLoggingInfo(ImportChainResult chainDTO, ChainCommitRequest apiRequest) {
        if (apiRequest == null || CollectionUtils.isEmpty((Collection)apiRequest.getDomains())) {
            return;
        }
        if (chainDTO.getDeployments() == null) {
            chainDTO.setDeployments(new ArrayList());
        }
        for (ImportDomainDTO requestDomain : apiRequest.getDomains()) {
            if (chainDTO.getDeployments().stream().anyMatch(d -> d.getDomain().equals(requestDomain.getName()))) continue;
            chainDTO.getDeployments().add(DeploymentExternalEntity.builder().domain(requestDomain.getName()).build());
        }
    }

    private ChainCommitRequestAction getResultingDeployAction(ImportChainResult chainDTO, ChainCommitRequest apiRequest) {
        if (apiRequest != null && apiRequest.getDeployAction() != null) {
            return apiRequest.getDeployAction();
        }
        if (chainDTO.getDeployAction() != null) {
            return chainDTO.getDeployAction();
        }
        return ChainCommitRequestAction.SNAPSHOT;
    }

    public ImportChainResult restoreChainFromYaml(String yaml, File chainFilesDir, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels) {
        ImportChainResult resultImportChainDTO = null;
        ChainCompareDTO basicChainInfo = null;
        try {
            String migratedYaml = this.migrateToActualFileVersion(yaml);
            ChainCompareDTO finalBasicChainInfo = basicChainInfo = this.getYamlBasicChainInfo(migratedYaml);
            if (CollectionUtils.isEmpty(commitRequests) || commitRequests.stream().anyMatch(request -> request.getId().equals(finalBasicChainInfo.getId()))) {
                ChainExternalEntity chainExternalEntity = (ChainExternalEntity)this.yamlMapper.readValue(migratedYaml, ChainExternalEntity.class);
                Chain currentChainState = this.chainService.tryFindById(chainExternalEntity.getId()).orElse(null);
                ImportEntityStatus importStatus = currentChainState != null ? ImportEntityStatus.UPDATED : ImportEntityStatus.CREATED;
                Folder existingFolder = null;
                if (chainExternalEntity.getContent().getFolder() != null) {
                    existingFolder = this.folderService.findFirstByName(chainExternalEntity.getContent().getFolder().getName(), null);
                }
                Chain chain = this.chainExternalEntityMapper.toInternalEntity(ChainExternalMapperEntity.builder().chainExternalEntity(chainExternalEntity).existingChain(currentChainState).existingFolder(existingFolder).chainFilesDirectory(chainFilesDir).build());
                ChainImportService.replaceTechnicalLabels(technicalLabels, (Chain)chain);
                chain.setUnsavedChanges(true);
                resultImportChainDTO = ImportChainResult.builder().id(chain.getId()).name(chain.getName()).status(importStatus).deployAction(chainExternalEntity.getContent().getDeployAction()).deployments(chainExternalEntity.getContent().getDeployments()).build();
                Timestamp modificationTimestamp = chain.getModifiedWhen();
                chain.setModifiedWhen(modificationTimestamp);
                this.chainImportService.saveImportedChainBackward(chain);
                this.logImportAction(chain, null, LogOperation.CREATE_OR_UPDATE);
            }
        }
        catch (ChainImportException e) {
            log.warn("Exception while importing {} ({}) chain: ", new Object[]{e.getChainName(), e.getChainId(), e});
            resultImportChainDTO = new ImportChainResult();
            resultImportChainDTO.setStatus(ImportEntityStatus.ERROR);
            resultImportChainDTO.setId(e.getChainId());
            resultImportChainDTO.setName(e.getChainName());
            resultImportChainDTO.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            resultImportChainDTO = new ImportChainResult();
            if (basicChainInfo != null) {
                resultImportChainDTO.setId(basicChainInfo.getId());
                resultImportChainDTO.setName(basicChainInfo.getName());
            }
            resultImportChainDTO.setStatus(ImportEntityStatus.ERROR);
            resultImportChainDTO.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return resultImportChainDTO;
    }

    private void logImportAction(Chain chain, String archiveName, LogOperation operation) {
        ActionLog.ActionLogBuilder builder = ActionLog.builder().entityType(chain != null ? EntityType.CHAIN : EntityType.CHAINS).entityName(chain != null ? chain.getName() : archiveName).operation(operation);
        if (chain != null) {
            builder.entityId(chain.getId()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName());
        }
        this.actionLogger.logAction(builder.build());
    }

    private synchronized ChainDeserializationResult deserializeChain(String yaml, File chainFilesDir) throws IOException {
        ChainDeserializationResult chainDeserializationResult = (ChainDeserializationResult)this.yamlMapper.readValue(yaml, ChainDeserializationResult.class);
        Chain chain = chainDeserializationResult.getChain();
        chain.setUnsavedChanges(true);
        this.checkAndPutScriptFileNameInServiceCall(chain, chainDeserializationResult);
        if (!CollectionUtils.isEmpty((Map)chainDeserializationResult.getPropertiesFileNames())) {
            this.restorePropertiesFromFiles(chain, chainFilesDir, chainDeserializationResult.getPropertiesFileNames());
        }
        return chainDeserializationResult;
    }

    private void checkAndPutScriptFileNameInServiceCall(Chain chain, ChainDeserializationResult chainDeserializationResult) {
        List chainElements = chain.getElements().stream().filter(element -> element.getType().equals("service-call")).collect(Collectors.toList());
        for (ChainElement chainElement : chainElements) {
            String beforeScriptFileName;
            Map beforePropMap;
            List afterPropertyList = (List)chainElement.getProperties().get("after");
            if (!CollectionUtils.isEmpty((Collection)afterPropertyList)) {
                for (Map afterPropMap : afterPropertyList) {
                    Object afterScriptFileName = !CollectionUtils.isEmpty((Map)afterPropMap) ? (String)afterPropMap.get("propertiesFilename") : null;
                    if (null == afterScriptFileName) continue;
                    Map fileNameMap = chainDeserializationResult.getPropertiesFileNames();
                    if (fileNameMap.get(chainElement.getId()) != null) {
                        afterScriptFileName = String.valueOf(fileNameMap.get(chainElement.getId())) + "::" + (String)afterScriptFileName;
                    }
                    fileNameMap.put(chainElement.getId(), afterScriptFileName);
                }
            }
            if (CollectionUtils.isEmpty((Map)(beforePropMap = (Map)chainElement.getProperties().get("before"))) || null == (beforeScriptFileName = (String)beforePropMap.get("propertiesFilename"))) continue;
            Map fileNameMap = chainDeserializationResult.getPropertiesFileNames();
            String afterScriptFileName = (String)fileNameMap.get(chainElement.getId());
            fileNameMap.put(chainElement.getId(), afterScriptFileName != null ? afterScriptFileName + "::" + beforeScriptFileName : beforeScriptFileName);
        }
    }

    public ImportChainResult restoreChainFromDir(File chainFilesDir, List<ChainCommitRequest> commitRequests, Set<String> technicalLabels) {
        ImportChainResult resultImportChainDTO;
        try {
            String chainYAML = Files.readString(this.getChainYAMLFile(chainFilesDir).toPath());
            resultImportChainDTO = (ImportChainResult)this.transactionTemplate.execute(status -> this.restoreChainFromYaml(chainYAML, chainFilesDir, commitRequests, technicalLabels));
        }
        catch (Exception e) {
            log.warn("Exception while chain import: ", (Throwable)e);
            resultImportChainDTO = new ImportChainResult();
            resultImportChainDTO.setStatus(ImportEntityStatus.ERROR);
            resultImportChainDTO.setErrorMessage("Exception while chain import: " + e.getMessage());
        }
        return resultImportChainDTO;
    }

    private void restorePropertiesFromFiles(Chain deserializedChain, File chainFilesDir, Map<String, String> propertiesFileNames) throws IOException {
        for (ChainElement element : deserializedChain.getElements()) {
            String propertiesFileName = propertiesFileNames.get(element.getId());
            if (propertiesFileName == null) continue;
            if (propertiesFileName.contains("::")) {
                StringTokenizer st = new StringTokenizer(propertiesFileName, "::");
                while (st.hasMoreTokens()) {
                    this.restoreProperties(element, chainFilesDir, st.nextToken());
                }
                continue;
            }
            this.restoreProperties(element, chainFilesDir, propertiesFileName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreProperties(ChainElement element, File chainFilesDir, String propertiesFilename) throws IOException {
        if (ExportImportUtils.isPropertiesFileJson((Map)element.getProperties()) || propertiesFilename.endsWith(".json")) {
            String restoredPropertiesString = ExportImportUtils.getFileContentByName((File)chainFilesDir, (String)propertiesFilename);
            if (!StringUtils.isNotEmpty((CharSequence)restoredPropertiesString)) throw new IOException("Could not find file with properties: " + propertiesFilename);
            HashMap restoredProperties = (HashMap)this.objectMapper.readValue(restoredPropertiesString, HashMap.class);
            if (restoredProperties == null || this.checkAndPutScriptContentInServiceCall(element, (Object)restoredProperties, propertiesFilename)) return;
            element.getProperties().putAll(restoredProperties);
            return;
        } else {
            if (!ExportImportUtils.isPropertiesFileGroove((Map)element.getProperties()) && !ExportImportUtils.isPropertiesFileSql((Map)element.getProperties()) && !propertiesFilename.endsWith(".groovy")) throw new IllegalArgumentException("Invalid property 'exportFileExtension' of element " + element.getId());
            String stringValue = ExportImportUtils.getFileContentByName((File)chainFilesDir, (String)propertiesFilename);
            if (stringValue == null) throw new IOException("Could not find file with properties: " + propertiesFilename);
            if (this.checkAndPutScriptContentInServiceCall(element, (Object)stringValue, propertiesFilename)) return;
            element.getProperties().put((String)element.getProperties().get("propertiesToExportInSeparateFile"), stringValue);
        }
    }

    private boolean checkAndPutScriptContentInServiceCall(ChainElement element, Object stringValue, String propertiesFilename) {
        if (element.getType().equals("service-call")) {
            Map beforePropMap;
            List afterPropertyList = (List)element.getProperties().get("after");
            if (!CollectionUtils.isEmpty((Collection)afterPropertyList)) {
                for (Map afterProp : afterPropertyList) {
                    if ("script".equals(afterProp.get("type")) && propertiesFilename.equals(afterProp.get("propertiesFilename"))) {
                        afterProp.put("script", stringValue);
                        break;
                    }
                    if (null == afterProp.get("type") || !propertiesFilename.equals(afterProp.get("propertiesFilename"))) continue;
                    this.updateMapperProperty(afterProp, stringValue);
                    break;
                }
            }
            if (!CollectionUtils.isEmpty((Map)(beforePropMap = (Map)element.getProperties().get("before")))) {
                if ("script".equals(beforePropMap.get("type")) && propertiesFilename.equals(beforePropMap.get("propertiesFilename"))) {
                    beforePropMap.put("script", stringValue);
                } else if (null != beforePropMap.get("type") && propertiesFilename.equals(beforePropMap.get("propertiesFilename"))) {
                    this.updateMapperProperty(beforePropMap, stringValue);
                }
            }
            return true;
        }
        return false;
    }

    private void updateMapperProperty(Map<String, Object> property, Object stringValue) {
        HashMap map = (HashMap)stringValue;
        if ("mapper".equals(property.get("type"))) {
            property.put("mapping", map.get("mapping"));
            property.put("source", map.get("source"));
            property.put("target", map.get("target"));
        } else {
            property.put("mappingDescription", map.get("mappingDescription"));
        }
    }

    protected File getChainYAMLFile(File chainDir) throws IOException {
        if (chainDir.listFiles() != null) {
            List<File> dirFiles = Arrays.asList(Objects.requireNonNull(chainDir.listFiles()));
            return dirFiles.stream().filter(f -> f.getName().startsWith("chain-") && f.getName().endsWith(".yaml")).findFirst().orElseThrow(() -> new RuntimeException("Directory " + chainDir.getName() + " does not contain chain YAML file"));
        }
        throw new RuntimeException("Directory " + chainDir.getName() + " is empty");
    }

    private String getFileContent(MultipartFile file) throws IOException {
        return new String(file.getBytes());
    }

    private String generateImportFolderName() {
        return UUID.randomUUID().toString();
    }

    protected void deployChains(List<ChainDeployPrepare> chainsToDeploy) {
        this.deployChains(chainsToDeploy, null);
    }

    protected void deployChains(List<ChainDeployPrepare> chainsToDeploy, String importId) {
        ArrayList oldDeploysList = new ArrayList();
        int total = chainsToDeploy.size();
        int counter = 0;
        for (ChainDeployPrepare entity : chainsToDeploy) {
            String chainId = entity.getImportChainResult().getId();
            oldDeploysList.addAll(this.deploymentService.findAllByChainId(chainId));
        }
        for (ChainDeployPrepare entity : chainsToDeploy) {
            this.calculateDeployAsyncStatus(importId, total, counter);
            ++counter;
            ImportChainResult importChainDTO = entity.getImportChainResult();
            Snapshot snapshot = entity.getSnapshot();
            List deployments = importChainDTO.getDeployments();
            if (CollectionUtils.isEmpty((Collection)deployments)) continue;
            try {
                for (DeploymentExternalEntity deployment : deployments) {
                    if (this.engineService.isDevMode() || this.engineService.getDomainByName(deployment.getDomain()) != null) {
                        this.createDeployment(snapshot, oldDeploysList, deployment);
                        continue;
                    }
                    importChainDTO.setStatus(ImportEntityStatus.ERROR);
                    importChainDTO.setErrorMessage("Chain is saved but not deployed: domain " + deployment.getDomain() + " doesn't exists");
                }
            }
            catch (Exception e) {
                log.error("Unable to deploy chain {} {}", (Object)importChainDTO.getId(), (Object)e.getMessage());
                importChainDTO.setStatus(ImportEntityStatus.ERROR);
                importChainDTO.setErrorMessage("Chain is saved but not deployed: " + e.getMessage());
            }
        }
    }

    protected Deployment createDeployment(Snapshot snapshot, List<Deployment> excludeDeployments, DeploymentExternalEntity deployment) {
        Deployment deploymentConfig = new Deployment();
        deploymentConfig.setDomain(deployment.getDomain());
        return this.deploymentService.create(deploymentConfig, snapshot.getChain(), snapshot, excludeDeployments);
    }

    protected ChainCommitDTO importToCommitDTOTransform(ImportChainResult importChainDTO, String archiveName) {
        ChainCommitAction action;
        ChainCommitDTO chainCommitDTO = ChainCommitDTO.builder().id(importChainDTO.getId()).name(importChainDTO.getName()).archiveName(archiveName).message(importChainDTO.getErrorMessage()).build();
        switch (1.$SwitchMap$org$qubership$integration$platform$runtime$catalog$rest$v1$dto$exportimport$chain$ImportEntityStatus[importChainDTO.getStatus().ordinal()]) {
            case 1: {
                action = ChainCommitAction.CREATED;
                break;
            }
            case 2: {
                action = ChainCommitAction.UPDATED;
                break;
            }
            case 3: {
                action = ChainCommitAction.ERROR;
                break;
            }
            default: {
                action = ChainCommitAction.ERROR;
                chainCommitDTO.setMessage("Unknown import status: " + String.valueOf(importChainDTO.getStatus()));
            }
        }
        chainCommitDTO.setStatus(action);
        return chainCommitDTO;
    }

    public File unpackZIP(InputStream is) throws IOException {
        return ExportImportUtils.extractDirectoriesFromZip((InputStream)is, (String)this.generateImportFolderName());
    }

    private ImportDTO restoreChainsFromDir(File importDirectory, List<ChainCommitRequest> commitRequests, String importId, Set<String> technicalLabels) {
        List chainFilesDirectories = null;
        ImportDTO response = new ImportDTO();
        File[] listFiles = (importDirectory = new File(String.valueOf(importDirectory) + File.separator + "chains")).listFiles();
        if (listFiles != null) {
            chainFilesDirectories = Arrays.stream(Objects.requireNonNull(listFiles)).filter(File::isDirectory).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(chainFilesDirectories)) {
            int total = chainFilesDirectories.size();
            int counter = 0;
            for (File chainFilesDir : chainFilesDirectories) {
                this.calculateImportAsyncStatus(importId, total, counter);
                ++counter;
                ImportChainResult chainDTO = this.restoreChainFromDir(chainFilesDir, commitRequests, technicalLabels);
                if (chainDTO == null) continue;
                response.getChains().add(chainDTO);
            }
        }
        return response;
    }

    private void calculateImportAsyncStatus(String importId, int total, int counter) {
        this.importProgressService.calculateImportStatus(importId, total, counter, 0, 40);
    }

    private void calculateSnapshotAsyncStatus(String importId, int total, int counter) {
        this.importProgressService.calculateImportStatus(importId, total, counter, 40, 90);
    }

    private void calculateDeployAsyncStatus(String importId, int total, int counter) {
        this.importProgressService.calculateImportStatus(importId, total, counter, 90, 100);
    }

    public ImportPreviewDTO importZIPAsPreview(InputStream is) {
        File importDirectory = null;
        ImportPreviewDTO response = new ImportPreviewDTO();
        List chainFilesDirectories = null;
        try {
            importDirectory = new File(String.valueOf(ExportImportUtils.extractDirectoriesFromZip((InputStream)is, (String)this.generateImportFolderName())) + File.separator + "chains");
            File[] listFiles = importDirectory.listFiles();
            importDirectory = importDirectory.getParentFile();
            if (listFiles != null) {
                chainFilesDirectories = Arrays.stream(Objects.requireNonNull(listFiles)).filter(File::isDirectory).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.warn("Exception while importing preview from zip: ", (Throwable)e);
            response.setErrorMessage("Exception while importing preview from zip: " + e.getMessage());
            ExportImportUtils.deleteFile((File)importDirectory);
            return response;
        }
        if (!CollectionUtils.isEmpty(chainFilesDirectories)) {
            for (File chainFilesDir : chainFilesDirectories) {
                response.getChains().add(this.restoreChainPreviewFromDir(chainFilesDir));
            }
        }
        ExportImportUtils.deleteFile((File)importDirectory);
        return response;
    }

    protected String migrateToActualFileVersion(String fileContent) throws Exception {
        return this.chainFileMigrationService.migrateToActualVersion(fileContent);
    }

    protected ChainCompareDTO getYamlBasicChainInfo(String yamlContent) throws IOException {
        String chainId;
        JsonNode node = this.yamlMapper.readTree(yamlContent);
        String string = chainId = node.get("id") != null ? node.get("id").asText(null) : null;
        if (chainId == null) {
            throw new RuntimeException("Missing id field in chain file");
        }
        String chainName = node.get("name") != null ? node.get("name").asText("") : "";
        JsonNode deployActionNode = node.get("deployAction");
        ChainCommitRequestAction deployAction = deployActionNode == null || deployActionNode.isNull() ? ChainCommitRequestAction.SNAPSHOT : ChainCommitRequestAction.valueOf((String)deployActionNode.asText());
        long modified = node.has("modifiedWhen") ? node.get("modifiedWhen").asLong() : 0L;
        return ChainCompareDTO.builder().id(chainId).name(chainName).deployAction(deployAction).modified(modified).build();
    }
}

