/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainImportFileMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class V101ChainImportFileMigration
implements ChainImportFileMigration {
    private static final Logger log = LoggerFactory.getLogger(V101ChainImportFileMigration.class);

    public int getVersion() {
        return 101;
    }

    public ObjectNode makeMigration(ObjectNode fileNode) throws JsonProcessingException {
        log.debug("Applying chain migration: {}", (Object)this.getVersion());
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        result.set("id", fileNode.get("id"));
        result.set("name", fileNode.get("name"));
        ObjectNode contentNode = JsonNodeFactory.instance.objectNode();
        fileNode.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            if (!"id".equals(key) && !"name".equals(key)) {
                contentNode.set(key, (JsonNode)entry.getValue());
            }
        });
        this.renameField((JsonNode)contentNode, "properties-filename", "propertiesFilename");
        this.setNewValueToEmptyField((JsonNode)contentNode, "keySerializer", "org.apache.kafka.common.serialization.StringSerializer");
        result.set("content", (JsonNode)contentNode);
        return result;
    }

    private void renameField(JsonNode node, String from, String to) {
        if (node.isObject() && node.has(from)) {
            if (node.has(to)) {
                log.error("Object already has field {}", (Object)to);
            } else {
                ((ObjectNode)node).set(to, node.get(from));
                ((ObjectNode)node).remove(from);
            }
        }
        node.forEach(child -> this.renameField(child, from, to));
    }

    private void setNewValueToEmptyField(JsonNode node, String fieldName, String newValue) {
        if (node.isObject()) {
            JsonNode field = node.get(fieldName);
            if (field != null && (field.isNull() || field.asText().isBlank())) {
                ((ObjectNode)node).put(fieldName, newValue);
            }
            node.fields().forEachRemaining(entry -> this.setNewValueToEmptyField((JsonNode)entry.getValue(), fieldName, newValue));
        } else if (node.isArray()) {
            for (JsonNode item : node) {
                this.setNewValueToEmptyField(item, fieldName, newValue);
            }
        }
    }
}

