/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.runtime.catalog.mapper;

import org.qubership.integration.platform.runtime.catalog.mapper.expressions.EscapeUtil;

import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DictionaryEntryParser {
    private static final Pattern ENTRY_REGEX = Pattern.compile(
            "((?:[^=;\\\\]|\\\\[=;\\\\])*)=((?:[^=;\\\\]|\\\\[=;\\\\])*)"
    );

    public static Map.Entry<String, String> parse(String value) {
        Matcher matcher = ENTRY_REGEX.matcher(value);
        if (!matcher.matches()) {
            String message = String.format("Malformed dictionary entry: %s.", value);
            throw new MapperException(message);
        }
        return new AbstractMap.SimpleEntry<>(
                EscapeUtil.unescape(matcher.group(1)),
                EscapeUtil.unescape(matcher.group(2))
        );
    }
}
