/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.consul;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.consul.ConsulService;
import org.qubership.integration.platform.catalog.model.compiledlibrary.CompiledLibraryUpdate;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemModelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompiledLibraryEventsProducerService {
    private static final Logger log = LoggerFactory.getLogger(CompiledLibraryEventsProducerService.class);
    private final SystemModelRepository systemModelRepository;
    private final ConsulService consulService;
    private boolean initUpdateCompleted = false;

    @Autowired
    public CompiledLibraryEventsProducerService(SystemModelRepository systemModelRepository, ConsulService consulService) {
        this.systemModelRepository = systemModelRepository;
        this.consulService = consulService;
    }

    public synchronized void sendAllCompiledLibrariesUpdate() {
        ArrayList<CompiledLibraryUpdate> allLibs = new ArrayList<CompiledLibraryUpdate>(this.getAllLibrariesUpdates());
        log.debug("Send all compiled libraries update to Consul...");
        this.consulService.updateLibraries(allLibs);
        this.initUpdateCompleted = true;
    }

    private List<CompiledLibraryUpdate> getAllLibrariesUpdates() {
        return this.systemModelRepository.findAllWithCompiledLibraries().stream().map(fields -> CompiledLibraryUpdate.builder().modelId((String)fields[0]).timestamp((Timestamp)fields[1]).build()).collect(Collectors.toList());
    }

    public boolean isInitUpdateCompleted() {
        return this.initUpdateCompleted;
    }
}

