/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.kubernetes;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1PodList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.integration.platform.runtime.catalog.kubernetes.KubeApiException;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubeDeployment;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubePod;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.PodRunningStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeOperator {
    private static final Logger log = LoggerFactory.getLogger(KubeOperator.class);
    private static final String BUILD_VERSION_LABEL = "app.kubernetes.io/version";
    private static final String DEFAULT_ERR_MESSAGE = "Invalid k8s cluster parameters or API error. ";
    private final CoreV1Api coreApi = new CoreV1Api();
    private final AppsV1Api appsApi;
    private final CustomObjectsApi customObjectsApi;
    private final String namespace;

    public KubeOperator() {
        this.appsApi = new AppsV1Api();
        this.customObjectsApi = new CustomObjectsApi();
        this.namespace = null;
    }

    public KubeOperator(ApiClient client, String namespace) {
        this.coreApi.setApiClient(client);
        this.appsApi = new AppsV1Api();
        this.appsApi.setApiClient(client);
        this.customObjectsApi = new CustomObjectsApi();
        this.customObjectsApi.setApiClient(client);
        this.namespace = namespace;
    }

    public List<KubeDeployment> getDeploymentsByLabel(String labelKey) throws KubeApiException {
        try {
            V1DeploymentList list = this.appsApi.listNamespacedDeployment(this.namespace, null, null, null, null, labelKey + " = true", null, null, null, null, null, null);
            return list.getItems().stream().map(item -> KubeDeployment.builder().id(Objects.requireNonNull(item.getMetadata().getUid())).name(Objects.requireNonNull(item.getMetadata()).getName()).namespace(this.namespace).replicas(Objects.requireNonNull(item.getSpec().getReplicas())).version((String)Objects.requireNonNull(item.getMetadata().getLabels()).get(BUILD_VERSION_LABEL)).build()).collect(Collectors.toList());
        }
        catch (ApiException e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
    }

    public List<KubePod> getPodsByLabel(String labelKey, String labelValue) throws KubeApiException {
        try {
            V1PodList list = this.coreApi.listNamespacedPod(this.namespace, null, null, null, null, labelKey + " = " + labelValue, null, null, null, null, null, null);
            return list.getItems().stream().map(item -> {
                boolean ready = false;
                if (item.getStatus() != null && item.getStatus().getContainerStatuses() != null && !item.getStatus().getContainerStatuses().isEmpty()) {
                    ready = ((V1ContainerStatus)item.getStatus().getContainerStatuses().get(0)).getReady();
                }
                return KubePod.builder().name(Objects.requireNonNull(item.getMetadata().getName())).runningStatus(PodRunningStatus.get(Objects.requireNonNull(item.getStatus()).getPhase())).ready(ready).ip(item.getStatus().getPodIP()).namespace(this.namespace).build();
            }).collect(Collectors.toList());
        }
        catch (ApiException e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getResponseBody());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getResponseBody(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error(DEFAULT_ERR_MESSAGE + e.getMessage());
            throw new KubeApiException(DEFAULT_ERR_MESSAGE + e.getMessage(), e);
        }
    }
}

