/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.model.system.exportimport;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSpecificationSource;
import org.qubership.integration.platform.runtime.catalog.model.system.exportimport.ExportedSystemObject;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.serializer.ExportableObjectWriterVisitor;

public class ExportedSpecification
extends ExportedSystemObject {
    private List<ExportedSpecificationSource> specificationSources;

    public ExportedSpecification(String id, ObjectNode objectNode, List<ExportedSpecificationSource> specificationSources) {
        super(id, objectNode);
        this.specificationSources = specificationSources;
    }

    @Override
    public void accept(ExportableObjectWriterVisitor visitor, ZipOutputStream zipOut, String entryPath) throws IOException {
        visitor.visit(this, zipOut, entryPath);
        for (ExportedSpecificationSource exportedSpecificationSource : this.specificationSources) {
            exportedSpecificationSource.accept(visitor, zipOut, entryPath);
        }
    }

    public List<ExportedSpecificationSource> getSpecificationSources() {
        return this.specificationSources;
    }

    public void setSpecificationSources(List<ExportedSpecificationSource> specificationSources) {
        this.specificationSources = specificationSources;
    }
}

