/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.persistence.configs.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.runtime.catalog.util.SQLUtils;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface DeploymentRepository
extends JpaRepository<Deployment, String> {
    public List<Deployment> findAllByChainId(String var1);

    public List<Deployment> findAllByDomain(String var1);

    public void deleteAllByChainId(String var1);

    public void deleteAllBySnapshotId(String var1);

    public long countByDomain(String var1);

    @Query(value="SELECT d.*\nFROM catalog.deployments d\n         LEFT JOIN (SELECT ex_sub.ex_id,\n                           ex_sub.ex_chain_id,\n                           ex_sub.ex_domain,\n                           ex_sub.ex_created_when,\n                           ex_sub.created_rank\n                    FROM (SELECT ex.id           as                                                   ex_id,\n                                 ex.chain_id     as                                                   ex_chain_id,\n                                 ex.domain       as                                                   ex_domain,\n                                 ex.created_when as                                                   ex_created_when,\n                                 RANK() OVER (PARTITION BY ex.chain_id ORDER BY ex.created_when DESC) created_rank\n                          FROM catalog.deployments ex\n                          WHERE ex.id IN :excludeIds) as ex_sub\n                    WHERE ex_sub.created_rank = 1) AS ex_t\n                   ON ex_t.ex_chain_id = d.chain_id AND ex_t.ex_domain = d.domain\nWHERE domain = :domainName\n  AND id NOT IN :excludeIds\n  AND (created_when > ex_created_when OR ex_id IS NULL)", nativeQuery=true)
    public List<Deployment> findDeploymentsToUpdate(String var1, List<String> var2);

    default public Set<String> findDeploymentsToRemove(String domainName, List<String> excludeIds) {
        return this.findDeploymentsToRemove(domainName, SQLUtils.convertListToValuesQuery(excludeIds));
    }

    @Query(value="SELECT ex.id\nFROM (SELECT unnest(cast(:excludeIds AS TEXT ARRAY))) AS ex (id)\nWHERE ex.id NOT IN (SELECT d.id FROM catalog.deployments d WHERE d.domain = :domainName)", nativeQuery=true)
    public Set<String> findDeploymentsToRemove(String var1, String var2);

    @Modifying
    @Query(value="DELETE FROM catalog.deployments d1\nWHERE d1.id IN (\n    SELECT DISTINCT d.id\n    FROM catalog.deployments d JOIN (SELECT *\n                                     FROM catalog.deployments d\n                                     WHERE d.id IN :deployed OR d.id IN :notDeployed) a ON d.chain_id = a.chain_id\n    WHERE d.id NOT IN :deployed AND d.created_when < a.created_when)\n", nativeQuery=true)
    public void deleteObsoleteDeployments(Collection<String> var1, Collection<String> var2);
}

