/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportPreviewDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v3.controller.ImportControllerV3;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/catalog/import"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Deprecated(since="2023.4")
@Tag(name="import-controller", description="Import Controller")
public class ImportController {
    private static final Logger log = LoggerFactory.getLogger(ImportController.class);
    private final ImportService importService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ImportController(ImportService importService, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this.importService = importService;
        this.objectMapper = objectMapper;
    }

    @PostMapping
    @Operation(description="Import chains from file")
    public ResponseEntity<ImportDTO> importFile(@RequestParam(value="file") @Parameter(description="File") MultipartFile file, @RequestParam(required=false) @Parameter(description="Import requests") String chainCommitRequests, @RequestHeader(required=false, value="chain-labels") @Parameter(description="List of labels to add on chains") List<String> technicalLabels, @RequestHeader(required=false, value="X-SR-Package-Name") @Parameter(description="Package name samples repository header") String packageName, @RequestHeader(required=false, value="X-SR-Package-Version") @Parameter(description="Package version samples repository header") String packageVersion, @RequestHeader(required=false, value="X-SR-Part-Of") @Parameter(description="Package part of samples repository header") String packagePartOf) {
        log.info("Request to import file: {}", (Object)file.getOriginalFilename());
        technicalLabels = ImportControllerV3.addSamplesRepoTechnicalLabels(technicalLabels, packagePartOf, packageName, packageVersion);
        List<ChainCommitRequest> chainCommitRequestsList = Collections.emptyList();
        try {
            if (chainCommitRequests != null) {
                chainCommitRequestsList = Arrays.asList((ChainCommitRequest[])this.objectMapper.readValue(chainCommitRequests, ChainCommitRequest[].class));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse chainCommitRequests parameter", e);
        }
        ImportDTO importDTO = this.importService.importFile(file, chainCommitRequestsList, new HashSet<String>(technicalLabels));
        HttpStatus responseCode = importDTO != null && importDTO.getChains() != null && importDTO.getChains().stream().anyMatch(dto -> dto.getStatus().equals((Object)ImportEntityStatus.ERROR)) ? HttpStatus.MULTI_STATUS : HttpStatus.OK;
        log.info("File {} imported successfully", (Object)file.getOriginalFilename());
        return ResponseEntity.status((HttpStatusCode)responseCode).body((Object)importDTO);
    }

    @PostMapping(value={"/preview"})
    @Operation(description="Get preview on what will be imported from file")
    public ResponseEntity<ImportPreviewDTO> importFileAsPreview(@RequestParam(value="file") @Parameter(description="File") MultipartFile file) {
        log.info("Request to preview file: {}", (Object)file.getOriginalFilename());
        ImportPreviewDTO importDTO = this.importService.importFileAsPreview(file);
        return ResponseEntity.ok((Object)importDTO);
    }
}

