/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/catalog/runtime-deployments"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Tag(name="runtime-deployment-controller", description="Runtime Deployment Controller")
public class RuntimeDeploymentController {
    private static final Logger log = LoggerFactory.getLogger(RuntimeDeploymentController.class);
    private static final String DEPLOYMENT_INFO = "deploymentInfo";
    private static final String DEPLOYMENT_INFO_PREFIX = "deploymentInfo.";
    private final RuntimeDeploymentService runtimeDeploymentService;

    @Autowired
    public RuntimeDeploymentController(RuntimeDeploymentService runtimeDeploymentService) {
        this.runtimeDeploymentService = runtimeDeploymentService;
    }

    @GetMapping(produces={"application/json"})
    @Operation(description="Get deployment statuses for all chains on all available engine pods")
    public ResponseEntity<MappingJacksonValue> findChainRuntimeDeployments(@RequestParam(value="fields", required=false) @Parameter(description="Fields to include in the response") String[] fields) {
        Map<String, Collection<ChainRuntimeDeployment>> deployments = this.runtimeDeploymentService.getChainRuntimeDeployments();
        if (deployments == null || deployments.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        MappingJacksonValue result = new MappingJacksonValue(deployments);
        if (ArrayUtils.isNotEmpty((Object[])fields)) {
            result.setFilters(this.createFilters(fields));
        }
        return ResponseEntity.ok((Object)result);
    }

    private FilterProvider createFilters(String[] fields) {
        HashSet<String> chainRuntimeDeploymentFields = new HashSet<String>();
        HashSet<String> deploymentInfoFields = new HashSet<String>();
        for (String field : fields) {
            if (field.startsWith(DEPLOYMENT_INFO_PREFIX)) {
                deploymentInfoFields.add(field.substring(DEPLOYMENT_INFO_PREFIX.length()));
                continue;
            }
            chainRuntimeDeploymentFields.add(field);
        }
        if (!deploymentInfoFields.isEmpty()) {
            chainRuntimeDeploymentFields.add(DEPLOYMENT_INFO);
        }
        return new SimpleFilterProvider().addFilter("ChainRuntimeDeploymentFilter", SimpleBeanPropertyFilter.filterOutAllExcept(chainRuntimeDeploymentFields)).addFilter("DeploymentInfoFilter", SimpleBeanPropertyFilter.filterOutAllExcept(deploymentInfoFields));
    }
}

