/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.BaseRequest;

@Schema(description="Deployment request object")
public class DeploymentRequest
extends BaseRequest {
    @Schema(description="Domain which was used to deploy to, usually \"default\"")
    @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid domain format")
    private @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid domain format") String domain;
    @Schema(description="Snapshot id")
    @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid snapshotId format")
    private @Pattern(regexp="^[-._a-zA-Z0-9]+$", message="Invalid snapshotId format") String snapshotId;
    @Deprecated
    @Schema(description="Not used")
    private Boolean suspended;

    protected DeploymentRequest(DeploymentRequestBuilder<?, ?> b) {
        super(b);
        this.domain = b.domain;
        this.snapshotId = b.snapshotId;
        this.suspended = b.suspended;
    }

    public static DeploymentRequestBuilder<?, ?> builder() {
        return new DeploymentRequestBuilderImpl();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Deprecated
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    @Deprecated
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public DeploymentRequest() {
    }

    public static abstract class DeploymentRequestBuilder<C extends DeploymentRequest, B extends DeploymentRequestBuilder<C, B>>
    extends BaseRequest.BaseRequestBuilder<C, B> {
        private String domain;
        private String snapshotId;
        private Boolean suspended;

        public B domain(String domain) {
            this.domain = domain;
            return (B)this.self();
        }

        public B snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return (B)this.self();
        }

        @Deprecated
        public B suspended(Boolean suspended) {
            this.suspended = suspended;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DeploymentRequest.DeploymentRequestBuilder(super=" + super.toString() + ", domain=" + this.domain + ", snapshotId=" + this.snapshotId + ", suspended=" + this.suspended + ")";
        }
    }

    private static final class DeploymentRequestBuilderImpl
    extends DeploymentRequestBuilder<DeploymentRequest, DeploymentRequestBuilderImpl> {
        private DeploymentRequestBuilderImpl() {
        }

        @Override
        protected DeploymentRequestBuilderImpl self() {
            return this;
        }

        @Override
        public DeploymentRequest build() {
            return new DeploymentRequest(this);
        }
    }
}

