/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v2.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ImportChainResult;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.ImportSession;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.chain.ImportEntityStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.exportimport.remoteimport.ChainCommitRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.exportimport.chain.ImportAsyncAcknowledge;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.exportimport.chain.ImportAsyncStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v2.mapper.ImportChainAsyncMapper;
import org.qubership.integration.platform.runtime.catalog.rest.v3.controller.ImportControllerV3;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportSessionService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.ImportV2RedirectPathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v2/import"}, produces={"application/json"})
@CrossOrigin(origins={"*"})
@Deprecated(since="2023.4")
@Tag(name="import-controller-v-2", description="Import Controller V2")
public class ImportControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(ImportControllerV2.class);
    protected static final String REQUEST_PATH = "/v2/import";
    private final ImportService importService;
    private final ImportSessionService importProgressService;
    private final ObjectMapper objectMapper;
    private final ImportChainAsyncMapper importChainAsyncMapper;
    private final ImportV2RedirectPathResolver importV2RedirectPathResolver;
    private static final String STATUS_PATH = "/status";

    @Autowired
    public ImportControllerV2(ImportService importService, ImportSessionService importProgressService, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, ImportChainAsyncMapper importChainAsyncMapper, ImportV2RedirectPathResolver importV2RedirectPathResolver) {
        this.importService = importService;
        this.importProgressService = importProgressService;
        this.objectMapper = objectMapper;
        this.importChainAsyncMapper = importChainAsyncMapper;
        this.importV2RedirectPathResolver = importV2RedirectPathResolver;
    }

    @PostMapping
    @Operation(description="Import chains from file asynchronously")
    public ResponseEntity<ImportAsyncAcknowledge> importFileAsync(@RequestParam(value="file") @Parameter(description="File") MultipartFile file, @RequestParam(required=false) @Parameter(description="Import requests") String chainCommitRequests, @RequestHeader Map<String, String> headers, @RequestHeader(required=false, value="chain-labels") @Parameter(description="List of labels to add on chains") List<String> technicalLabels, @RequestHeader(required=false, value="X-SR-Package-Name") @Parameter(description="Package name samples repository header") String packageName, @RequestHeader(required=false, value="X-SR-Package-Version") @Parameter(description="Package version samples repository header") String packageVersion, @RequestHeader(required=false, value="X-SR-Part-Of") @Parameter(description="Package part of samples repository header") String packagePartOf) {
        log.info("Request v2 to import file: {}", (Object)file.getOriginalFilename());
        technicalLabels = ImportControllerV3.addSamplesRepoTechnicalLabels(technicalLabels, packagePartOf, packageName, packageVersion);
        List<ChainCommitRequest> chainCommitRequestsList = Collections.emptyList();
        try {
            if (chainCommitRequests != null) {
                chainCommitRequestsList = Arrays.asList((ChainCommitRequest[])this.objectMapper.readValue(chainCommitRequests, ChainCommitRequest[].class));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse chainCommitRequests parameter", e);
        }
        String importId = this.importService.importFileAsync(file, chainCommitRequestsList, new HashSet<String>(technicalLabels));
        URI href = this.getHrefStatusLocation(importId, headers);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(href)).header("Retry-After", new String[]{"60"})).body((Object)new ImportAsyncAcknowledge(importId, href.toString()));
    }

    @GetMapping(value={"/{importId}"}, produces={"application/json"})
    @Operation(description="Get import result")
    public ResponseEntity<List<ImportChainResult>> getImportAsyncResult(@PathVariable @Parameter(description="Import id") String importId) {
        List<ImportChainResult> result = this.importService.getImportAsyncResult(importId);
        if (result == null) {
            return ResponseEntity.notFound().build();
        }
        HttpStatus responseCode = result.stream().anyMatch(el -> el.getStatus().equals((Object)ImportEntityStatus.ERROR)) ? HttpStatus.MULTI_STATUS : HttpStatus.OK;
        return ResponseEntity.status((HttpStatusCode)responseCode).body(result);
    }

    @GetMapping(value={"/status/{importId}", "/preview/{importId}/status"}, produces={"application/json"})
    @Operation(description="Get import status (progress)")
    public ResponseEntity<ImportAsyncStatus> getImportAsyncStatus(@PathVariable @Parameter(description="Import id") String importId, @RequestHeader Map<String, String> headers) {
        ImportSession importSession = this.importProgressService.getImportSession(importId);
        if (importSession == null) {
            return ResponseEntity.notFound().build();
        }
        ImportAsyncStatus importStatus = this.importChainAsyncMapper.asImportStatus(importSession);
        if (importSession.isDone()) {
            URI href = this.getHrefResultLocation(importId, headers);
            importStatus.setHref(href.toString());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.SEE_OTHER).location(href)).body((Object)importStatus);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).header("Retry-After", new String[]{"60"})).body((Object)importStatus);
    }

    private URI getHrefResultLocation(String importId, Map<String, String> headers) {
        return this.concatenateUri(this.importV2RedirectPathResolver.resolve(headers, REQUEST_PATH), importId);
    }

    private URI getHrefStatusLocation(String importId, Map<String, String> headers) {
        return this.concatenateUri(this.importV2RedirectPathResolver.resolve(headers, REQUEST_PATH), STATUS_PATH, importId);
    }

    private URI concatenateUri(URI uri, String ... paths) {
        StringBuilder builder = new StringBuilder(uri.toString());
        for (String path : paths) {
            builder.append("/").append(path);
        }
        return URI.create(builder.toString()).normalize();
    }
}

