/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.catalog.model.deployment.engine.DeploymentStatus;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.catalog.model.filter.ChainElementFilterColumn;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElementFilterRequestDTO;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElementSearchCriteria;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainRolesDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainRolesResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.UpdateRolesRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.DeploymentProcessingException;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.ChainRolesMapper;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.DeploymentMapper;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChainRolesService {
    private static final Logger log = LoggerFactory.getLogger(ChainRolesService.class);
    private static final String ROLES = "roles";
    private final ElementService elementService;
    private final DeploymentService deploymentService;
    private final RuntimeDeploymentService runtimeDeploymentService;
    private final ChainRolesMapper chainRolesMapper;
    private final ChainService chainService;
    private final ElementRepository elementRepository;
    private final DeploymentMapper deploymentMapper;
    private final SnapshotService snapshotService;
    private final ActionsLogService actionLogger;
    private ChainRolesResponse chainRolesAndFilters;

    public ChainRolesService(ElementService elementService, DeploymentService deploymentService, RuntimeDeploymentService runtimeDeploymentService, ChainRolesMapper chainRolesMapper, ChainService chainService, ElementRepository elementRepository, DeploymentMapper deploymentMapper, SnapshotService snapshotService, ActionsLogService actionLogger) {
        this.elementService = elementService;
        this.deploymentService = deploymentService;
        this.runtimeDeploymentService = runtimeDeploymentService;
        this.chainRolesMapper = chainRolesMapper;
        this.chainService = chainService;
        this.elementRepository = elementRepository;
        this.deploymentMapper = deploymentMapper;
        this.snapshotService = snapshotService;
        this.actionLogger = actionLogger;
    }

    public ChainRolesResponse findAllChainByHttpTrigger(ChainElementSearchCriteria request, boolean isImplementedOnly) {
        int offset = request.getOffset();
        int limit = request.getLimit();
        List filters = request.getFilters();
        if (offset < 0 || limit < 1) {
            return new ChainRolesResponse(0, Collections.emptyList());
        }
        List elementList = this.elementRepository.findElementsByFilter(offset, limit, List.of("http-trigger"), filters, isImplementedOnly);
        List<ChainRolesDTO> chainRolesResponse = this.chainRolesMapper.asChainRolesResponses(elementList);
        if (!chainRolesResponse.isEmpty()) {
            Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments = this.runtimeDeploymentService.getChainRuntimeDeployments();
            this.setDeploymentStatuses(chainRolesResponse, runtimeDeployments);
            chainRolesResponse = this.getChainsFilteredByStatus(chainRolesResponse, filters);
        }
        return this.chainFilters(new ChainRolesResponse(offset + chainRolesResponse.size(), chainRolesResponse));
    }

    public ChainRolesResponse chainFilters(ChainRolesResponse chainRolesResponse) {
        this.chainRolesAndFilters = chainRolesResponse;
        return this.chainRolesAndFilters;
    }

    public ChainRolesResponse updateRoles(List<UpdateRolesRequest> request) {
        ArrayList<UpdateRolesRequest> updateRolesRequestLst = new ArrayList<UpdateRolesRequest>();
        for (UpdateRolesRequest updateReq : request) {
            try {
                ChainElement element = this.elementService.findById(updateReq.getElementId());
                element.getProperties().put(ROLES, Lists.newArrayList(updateReq.getRoles()));
                element.getChain().setUnsavedChanges(true);
                UpdateRolesRequest updateRolesRequest = new UpdateRolesRequest(element.getChain().isUnsavedChanges(), element.getChain().getId());
                this.elementService.save(element);
                if (updateReq.getIsRedeploy().booleanValue()) {
                    updateRolesRequestLst.add(updateRolesRequest);
                }
                this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.ELEMENT).entityId(element.getId()).entityName(element.getName()).parentType(EntityType.CHAIN).parentId(element.getChain().getId()).parentName(element.getChain().getName()).operation(LogOperation.UPDATE).build());
            }
            catch (Exception exception) {
                log.error("Error when updating roles: {}", (Object)exception.getLocalizedMessage());
            }
        }
        return this.redeploy(updateRolesRequestLst);
    }

    public ChainRolesResponse redeploy(List<UpdateRolesRequest> request) {
        request.stream().filter(UpdateRolesRequest::getUnsavedChanges).map(UpdateRolesRequest::getChainId).collect(Collectors.toSet()).forEach(chainId -> {
            Chain chain = this.chainService.findById((String)chainId);
            try {
                List deployments = chain.getDeployments();
                ArrayList<DeploymentRequest> deploymentRequestLst = new ArrayList<DeploymentRequest>();
                Snapshot snapshot = this.snapshotService.build(chain.getId());
                if (deployments.isEmpty()) {
                    DeploymentRequest deploymentRequest = this.chainRolesMapper.prepareDeploymentRequest(snapshot);
                    deploymentRequestLst.add(deploymentRequest);
                } else {
                    ((Deployment)chain.getDeployments().get(0)).setSnapshot(snapshot);
                    deploymentRequestLst = this.chainRolesMapper.prepareDeploymentRequest(chain.getDeployments());
                }
                this.deploymentService.createAll(this.deploymentMapper.asEntities(deploymentRequestLst), chain.getId(), snapshot);
                chain.setUnsavedChanges(false);
                chain.setCurrentSnapshot(snapshot);
                this.chainService.update(chain);
            }
            catch (SnapshotCreationException exception) {
                ChainElement exceptionChainElement = chain.getElements().stream().filter(chainElement -> chainElement.getId().equals(exception.getElementId())).findFirst().orElse(null);
                throw new SnapshotCreationException("Unable to create snapshot for chain " + chainId + " :" + exception.getMessage(), chainId, exceptionChainElement, (Exception)((Object)exception));
            }
            catch (Exception exception) {
                throw new DeploymentProcessingException("Unable to redeploy chain " + chainId + ":" + exception.getMessage(), exception);
            }
        });
        return this.chainRolesAndFilters;
    }

    private List<ChainRolesDTO> getChainsFilteredByStatus(List<ChainRolesDTO> chainRolesResponse, List<ChainElementFilterRequestDTO> filters) {
        Predicate predicate = filters.stream().filter(chainFilter -> chainFilter.getColumn().equals((Object)ChainElementFilterColumn.CHAIN_STATUS)).map(this::buildDeploymentStatusFilterPredicate).reduce(chainRolesDTO -> true, Predicate::and);
        return chainRolesResponse.stream().filter(predicate).toList();
    }

    private Predicate<ChainRolesDTO> buildDeploymentStatusFilterPredicate(ChainElementFilterRequestDTO filter) {
        assert (filter.getColumn().equals((Object)ChainElementFilterColumn.CHAIN_STATUS));
        Collection values = Arrays.stream(filter.getValue().split(",")).map(String::toLowerCase).collect(Collectors.toSet());
        Predicate<String> predicate = switch (filter.getCondition()) {
            case FilterCondition.IS, FilterCondition.IN -> values::contains;
            case FilterCondition.IS_NOT, FilterCondition.NOT_IN -> status -> !values.contains(status);
            default -> status -> true;
        };
        return chainRolesDTO -> chainRolesDTO.getDeploymentStatus().stream().map(status -> status.name().toLowerCase()).anyMatch(predicate);
    }

    private void setDeploymentStatuses(List<ChainRolesDTO> chainRolesResponse, Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments) {
        chainRolesResponse.forEach(chainRolesDTO -> chainRolesDTO.setDeploymentStatus(this.getDeploymentStatuses(chainRolesDTO.getChainId(), runtimeDeployments)));
    }

    private List<DeploymentStatus> getDeploymentStatuses(String chainId, Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments) {
        Collection<ChainRuntimeDeployment> chainDeployments = runtimeDeployments.get(chainId);
        if (chainDeployments != null) {
            return chainDeployments.stream().map(EngineDeployment::getStatus).toList();
        }
        return Collections.singletonList(DeploymentStatus.DRAFT);
    }
}

