/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.model.ElementRoute;
import org.qubership.integration.platform.catalog.model.deployment.RouteType;
import org.qubership.integration.platform.catalog.model.deployment.engine.EngineDeploymentsDTO;
import org.qubership.integration.platform.catalog.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.catalog.model.system.IntegrationSystemType;
import org.qubership.integration.platform.catalog.persistence.TransactionHandler;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.DeploymentRoute;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.catalog.util.HashUtils;
import org.qubership.integration.platform.catalog.util.SimpleHttpUriUtils;
import org.qubership.integration.platform.catalog.util.TriggerUtils;
import org.qubership.integration.platform.runtime.catalog.configuration.aspect.DeploymentModification;
import org.qubership.integration.platform.runtime.catalog.model.MultiConsumer;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentUpdate;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentsUpdate;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.repository.DeploymentRepository;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentSnapshotAction;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.bulk.BulkDeploymentStatus;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.event.GenericMessageType;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.DeploymentProcessingException;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.SnapshotService;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.qubership.integration.platform.runtime.catalog.service.deployment.DeploymentBuilderService;
import org.qubership.integration.platform.runtime.catalog.util.SQLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeploymentService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentService.class);
    private static final String DEPLOYMENT_WITH_ID_NOT_FOUND_MESSAGE = "Can't find deployment with id: ";
    private final DeploymentRepository deploymentRepository;
    private final ElementRepository elementRepository;
    private final ChainService chainService;
    private final SystemService systemService;
    private final SnapshotService snapshotService;
    private final LibraryElementsService libraryElementsService;
    private final ActionsLogService actionLogger;
    private final DeploymentBuilderService deploymentBuilderService;
    private final TransactionHandler transactionHandler;
    @Value(value="${qip.chains.triggers.check.enabled}")
    private boolean triggersCheckEnabled;
    @Value(value="${qip.control-plane.chain-routes-registration.egress-gateway:true}")
    private boolean registerOnEgress;
    @Value(value="${qip.control-plane.chain-routes-registration.ingress-gateways:true}")
    private boolean registerOnIncomingGateways;
    private MultiConsumer.Consumer5<String, String, String, GenericMessageType, Map<String, String>> messagesCallback = (a, b, c, d, e) -> {};
    private static final Map<String, DeploymentsUpdate> fullDeploymentsUpdateCache = new ConcurrentHashMap<String, DeploymentsUpdate>();
    private static Long deploymentsUpdateVersion = 0L;

    @Autowired
    public DeploymentService(DeploymentRepository deploymentRepository, ElementRepository elementRepository, ChainService chainService, SystemService systemService, SnapshotService snapshotService, LibraryElementsService libraryElementsService, ActionsLogService actionLogger, DeploymentBuilderService deploymentBuilderService, TransactionHandler transactionHandler) {
        this.deploymentRepository = deploymentRepository;
        this.elementRepository = elementRepository;
        this.chainService = chainService;
        this.systemService = systemService;
        this.snapshotService = snapshotService;
        this.libraryElementsService = libraryElementsService;
        this.actionLogger = actionLogger;
        this.deploymentBuilderService = deploymentBuilderService;
        this.transactionHandler = transactionHandler;
    }

    @Transactional
    public Deployment findById(String deploymentId) {
        return (Deployment)this.deploymentRepository.findById(deploymentId).orElseThrow(() -> new EntityNotFoundException(DEPLOYMENT_WITH_ID_NOT_FOUND_MESSAGE + deploymentId));
    }

    @Transactional
    public List<Deployment> findAllByChainId(String chainId) {
        return this.deploymentRepository.findAllByChainId(chainId);
    }

    @Transactional
    public long getDeploymentsCountByDomain(String domainName) {
        return this.deploymentRepository.countByDomain(domainName);
    }

    @DeploymentModification
    public List<Deployment> createAll(List<Deployment> deployments, String chainId) {
        if (!deployments.isEmpty()) {
            return this.createAll(deployments, chainId, deployments.get(0).getSnapshot());
        }
        return Collections.emptyList();
    }

    @DeploymentModification
    public List<Deployment> createAll(List<Deployment> deployments, String chainId, Snapshot snapshot) {
        if (!this.checkTriggersInBulkDeploy(deployments)) {
            throw new DeploymentProcessingException("Found external or private triggers while deploying to multiple domains");
        }
        ArrayList<Deployment> createdDeployments = new ArrayList<Deployment>(deployments.size());
        for (Deployment deployment : deployments) {
            Deployment createdDeployment = this.create(deployment, chainId, snapshot);
            if (createdDeployment == null) continue;
            createdDeployments.add(createdDeployment);
        }
        return createdDeployments;
    }

    @DeploymentModification
    public Deployment create(Deployment deployment, String chainId, Snapshot snapshot) {
        return this.create(deployment, this.chainService.findById(chainId), snapshot, null);
    }

    @DeploymentModification
    public Deployment create(Deployment deployment, String chainId, String snapshotId) {
        return this.create(deployment, this.chainService.findById(chainId), this.snapshotService.findById(snapshotId), null);
    }

    @DeploymentModification
    public Deployment create(Deployment deployment, Chain chain, Snapshot snapshot, List<Deployment> excludeDeployments) {
        if (log.isDebugEnabled()) {
            log.debug("Request to create deployment for chain {}, snapshot {}", (Object)chain.getId(), (Object)snapshot.getId());
        }
        AtomicReference savedDeployment = new AtomicReference();
        this.transactionHandler.runInNewTransaction(() -> {
            this.checkTriggers(deployment.getDomain(), snapshot.getId(), chain.getId(), excludeDeployments);
            this.prepareDeployment(deployment, snapshot, chain);
            savedDeployment.set((Deployment)this.deploymentRepository.save(deployment));
            this.logDeploymentAction((Deployment)savedDeployment.get(), chain.getId(), chain.getName(), LogOperation.CREATE);
        });
        return (Deployment)savedDeployment.get();
    }

    @Transactional
    @DeploymentModification
    public Pair<Boolean, List<BulkDeploymentResponse>> bulkCreate(BulkDeploymentRequest request) {
        AtomicReference<Boolean> failed = new AtomicReference<Boolean>(false);
        ArrayList<BulkDeploymentResponse> statuses = new ArrayList<BulkDeploymentResponse>();
        Map chains = (CollectionUtils.isEmpty(request.getChainIds()) ? this.chainService.findAll() : this.chainService.findAllById(request.getChainIds())).stream().filter(chain -> {
            if (chain.getOverriddenByChainId() != null) {
                statuses.add(BulkDeploymentResponse.builder().chainId(chain.getId()).chainName(chain.getName()).status(BulkDeploymentStatus.IGNORED).build());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        log.info("Bulk deploy for {} chains", (Object)chains.size());
        BiConsumer<String, String> errorHandler = (chainId, msg) -> {
            statuses.add(BulkDeploymentResponse.builder().chainId((String)chainId).chainName(((Chain)chains.get(chainId)).getName()).status(BulkDeploymentStatus.FAILED_SNAPSHOT).errorMessage((String)msg).build());
            failed.set(true);
        };
        Map<String, Snapshot> snapshots = switch (request.getSnapshotAction()) {
            default -> throw new IncompatibleClassChangeError();
            case BulkDeploymentSnapshotAction.CREATE_NEW -> this.snapshotService.buildAll(chains.keySet(), errorHandler);
            case BulkDeploymentSnapshotAction.LAST_CREATED -> this.snapshotService.findLastCreatedOrBuild(chains.keySet(), errorHandler);
        };
        for (Map.Entry<String, Snapshot> entry : snapshots.entrySet()) {
            List<Deployment> deps = request.getDomains().stream().map(domain -> {
                Deployment dep = new Deployment();
                dep.setDomain(domain);
                return dep;
            }).toList();
            try {
                this.createAll(deps, entry.getKey(), entry.getValue());
                statuses.add(BulkDeploymentResponse.builder().chainId(entry.getKey()).chainName(((Chain)chains.get(entry.getKey())).getName()).status(BulkDeploymentStatus.CREATED).build());
            }
            catch (Exception e) {
                log.error("Error creating deployment for chain: {}, {}", (Object)entry.getKey(), (Object)e.getMessage());
                statuses.add(BulkDeploymentResponse.builder().chainId(entry.getKey()).chainName(((Chain)chains.get(entry.getKey())).getName()).status(BulkDeploymentStatus.FAILED_DEPLOY).errorMessage(e.getMessage()).build());
                failed.set(true);
            }
        }
        return Pair.of((Object)failed.get(), statuses);
    }

    private void prepareDeployment(Deployment deployment, Snapshot snapshot, Chain chain) {
        deployment.setSnapshot(snapshot);
        deployment.setChain(chain);
        deployment.setName(snapshot.getName());
        deployment.setDeploymentRoutes(this.buildDeploymentRoutes(deployment));
    }

    private List<DeploymentRoute> buildDeploymentRoutes(Deployment deployment) {
        String snapshotId = deployment.getSnapshot().getId();
        try {
            ArrayList<DeploymentRoute> allRoutes = new ArrayList<DeploymentRoute>();
            if (this.registerOnIncomingGateways) {
                List<DeploymentRoute> triggers = this.buildTriggersRoutes(snapshotId);
                allRoutes.addAll(triggers);
            }
            if (this.registerOnEgress) {
                List<DeploymentRoute> senders = this.buildHttpSendersRoutes(snapshotId);
                allRoutes.addAll(senders);
                List<DeploymentRoute> serviceRoutes = this.buildServicesRoutes(snapshotId);
                allRoutes.addAll(serviceRoutes);
            }
            log.debug("Routes for registration in control plane: {}", allRoutes);
            return allRoutes;
        }
        catch (Exception e) {
            log.error("Failed to build egress routes for deployment", (Throwable)e);
            throw new RuntimeException("Failed to build egress routes for deployment", e);
        }
    }

    public boolean checkRouteExists(ElementRoute route, String excludeChainId) {
        return this.findElementsThatUseRoute(route, excludeChainId).findAny().isPresent();
    }

    public List<Pair<String, Deployment>> findRouteDeployments(ElementRoute route, String excludeChainId) {
        return this.findElementsThatUseRoute(route, excludeChainId).flatMap(element -> {
            String path = TriggerUtils.getHttpTriggerPath((ChainElement)element);
            return element.getSnapshot().getDeployments().stream().map(deployment -> Pair.of((Object)path, (Object)deployment));
        }).collect(Collectors.toList());
    }

    private Stream<ChainElement> findElementsThatUseRoute(ElementRoute route, String excludeChainId) {
        return this.elementRepository.findElementsForRouteExistenceCheck(List.of("http-trigger"), excludeChainId).stream().filter(element -> TriggerUtils.getHttpTriggerRoute((ChainElement)element).intersectsWith(route));
    }

    private void checkTriggers(String domain, String snapshotId, String chainId, List<Deployment> excludeDeployments) {
        if (!this.triggersCheckEnabled) {
            return;
        }
        List<String> excludeDeploymentIds = excludeDeployments == null ? null : excludeDeployments.stream().map(Deployment::getId).collect(Collectors.toList());
        this.checkHttpTriggers(snapshotId, chainId, excludeDeploymentIds, domain);
        this.checkSdsTriggers(snapshotId, chainId, excludeDeploymentIds, domain);
    }

    private void checkSdsTriggers(String snapshotId, String chainId, List<String> excludeDeploymentIds, String domain) {
        List<String> triggersToCheck = List.of("sds-trigger");
        List<String> pendingJobIds = this.mapSdsTriggerJobIds(this.elementRepository.findAllBySnapshotIdAndTypeIn(snapshotId, triggersToCheck));
        if (pendingJobIds.isEmpty()) {
            return;
        }
        List<String> domainJobIds = this.mapSdsTriggerJobIds(this.elementRepository.findElementsForDomainTriggerCheck(triggersToCheck, domain, chainId, SQLUtils.prepareCollectionForHqlNotInClause(excludeDeploymentIds)));
        Set<String> domainEqualJobIds = this.findSameSdsTriggerJobIds(pendingJobIds, domainJobIds);
        if (!domainEqualJobIds.isEmpty()) {
            throw new EntityExistsException("Found similar Job Ids registered on scheduling-service (SDS) on the same domain: " + String.valueOf(domainEqualJobIds));
        }
    }

    private void checkHttpTriggers(String snapshotId, String chainId, List<String> excludeDeploymentIds, String domain) {
        List<String> triggersToCheck = List.of("http-trigger");
        List<ElementRoute> pendingRoutes = this.mapHttpTriggerRoutes(this.elementRepository.findAllBySnapshotIdAndTypeIn(snapshotId, triggersToCheck));
        if (pendingRoutes.isEmpty()) {
            return;
        }
        List<ElementRoute> allRoutes = this.mapHttpTriggerRoutes(this.elementRepository.findElementsForTriggerCheck(triggersToCheck, chainId, SQLUtils.prepareCollectionForHqlNotInClause(excludeDeploymentIds)));
        List<ElementRoute> otherDomainsRoutes = this.mapHttpTriggerRoutes(this.elementRepository.findElementsForDomainTriggerCheck(triggersToCheck, domain, chainId, SQLUtils.prepareCollectionForHqlNotInClause(excludeDeploymentIds)));
        Set<String> gatewayEqualPaths = this.findSameHttpTriggerPaths(pendingRoutes, allRoutes, true);
        Set<String> otherDomainsEqualPaths = this.findSameHttpTriggerPaths(pendingRoutes, otherDomainsRoutes, false);
        if (!gatewayEqualPaths.isEmpty()) {
            throw new EntityExistsException("Found similar triggers paths registered on public/private gateway: " + String.valueOf(gatewayEqualPaths));
        }
        if (!otherDomainsEqualPaths.isEmpty()) {
            throw new EntityExistsException("Found similar triggers path registered on other domains: " + String.valueOf(otherDomainsEqualPaths));
        }
    }

    private boolean checkTriggersInBulkDeploy(List<Deployment> deployments) {
        if (deployments.size() > 1) {
            String snapshotId = deployments.get(0).getSnapshot().getId();
            List triggers = this.elementRepository.findAllBySnapshotIdAndType(snapshotId, TriggerUtils.getHttpTriggerTypeName());
            return triggers.stream().noneMatch(trigger -> TriggerUtils.isExternalHttpTrigger((ChainElement)trigger) || TriggerUtils.isPrivateHttpTrigger((ChainElement)trigger));
        }
        return true;
    }

    private List<ElementRoute> mapHttpTriggerRoutes(Collection<ChainElement> listOfObjects) {
        return listOfObjects.stream().map(TriggerUtils::getHttpTriggerRoute).toList();
    }

    private List<String> mapSdsTriggerJobIds(Collection<ChainElement> listOfObjects) {
        return listOfObjects.stream().map(TriggerUtils::getSdsTriggerJobId).toList();
    }

    private Set<String> findSameHttpTriggerPaths(List<ElementRoute> pendingRoutes, List<ElementRoute> existingRoutes, boolean checkGatewayOnly) {
        Set intersectionMethods;
        HashSet<String> equalPaths = new HashSet<String>();
        HashMap<String, Set> pendingPathIntersection = new HashMap<String, Set>();
        for (ElementRoute route : pendingRoutes) {
            if (!StringUtils.isNotBlank((CharSequence)route.getPath()) || checkGatewayOnly && !route.isExternal() && !route.isPrivate()) continue;
            intersectionMethods = (Set)pendingPathIntersection.get(route.getPath());
            if (intersectionMethods != null) {
                if (!route.getMethods().stream().anyMatch(intersectionMethods::contains)) continue;
                equalPaths.add(route.getPath());
                continue;
            }
            pendingPathIntersection.put(route.getPath(), route.getMethods());
        }
        for (ElementRoute route : existingRoutes) {
            if (!StringUtils.isNotBlank((CharSequence)route.getPath()) || checkGatewayOnly && !route.isExternal() && !route.isPrivate() || (intersectionMethods = (Set)pendingPathIntersection.get(route.getPath())) == null) continue;
            if (!route.getMethods().stream().anyMatch(intersectionMethods::contains)) continue;
            equalPaths.add(route.getPath());
        }
        return equalPaths;
    }

    private Set<String> findSameSdsTriggerJobIds(List<String> pendingJobIds, List<String> domainJobIds) {
        return pendingJobIds.stream().filter(domainJobIds::contains).collect(Collectors.toSet());
    }

    @DeploymentModification
    public void deleteAllByChainId(String chainId) throws DeploymentProcessingException {
        List<Deployment> deployments = this.findAllByChainId(chainId);
        this.transactionHandler.runInNewTransaction(() -> this.deploymentRepository.deleteAllByChainId(chainId));
        deployments.forEach(deployment -> this.logDeploymentAction((Deployment)deployment, deployment.getId(), deployment.getChain().getName(), LogOperation.DELETE));
    }

    @DeploymentModification
    public void deleteAllBySnapshotId(String snapshotId) throws DeploymentProcessingException {
        Snapshot snapshot = this.snapshotService.findById(snapshotId);
        snapshot.getDeployments().forEach(deployment -> this.logDeploymentAction((Deployment)deployment, deployment.getId(), deployment.getChain().getName(), LogOperation.DELETE));
        this.transactionHandler.runInNewTransaction(() -> this.deploymentRepository.deleteAllBySnapshotId(snapshotId));
    }

    @DeploymentModification
    public void deleteById(String deploymentId) throws DeploymentProcessingException {
        this.transactionHandler.runInNewTransaction(() -> {
            Deployment deployment = (Deployment)this.deploymentRepository.findById(deploymentId).orElseThrow(() -> new EntityNotFoundException(DEPLOYMENT_WITH_ID_NOT_FOUND_MESSAGE + deploymentId));
            this.deploymentRepository.deleteById(deploymentId);
            this.logDeploymentAction(deployment, deployment.getChain().getId(), deployment.getChain().getName(), LogOperation.DELETE);
        });
    }

    private void logDeploymentAction(Deployment deployment, String parentId, String parentName, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.DEPLOYMENT).entityId(deployment.getId()).entityName(deployment.getDomain()).parentType(parentId == null ? null : EntityType.CHAIN).parentId(parentId).parentName(parentName).operation(operation).build());
    }

    @Transactional(propagation=Propagation.NEVER)
    public DeploymentsUpdate getDeploymentsForDomain(String domainName, EngineDeploymentsDTO engineDeployments) {
        DeploymentsUpdate initialUpdate;
        ArrayList<DeploymentUpdate> update = new ArrayList<DeploymentUpdate>();
        ArrayList<DeploymentUpdate> stop = new ArrayList<DeploymentUpdate>();
        boolean fullDeploymentsRequest = engineDeployments.getExcludeDeployments().isEmpty();
        Long currentDeploymentVersion = deploymentsUpdateVersion;
        if (fullDeploymentsRequest && (initialUpdate = fullDeploymentsUpdateCache.get(domainName)) != null) {
            return initialUpdate;
        }
        List excludeDeployments = engineDeployments.getExcludeDeployments();
        if (CollectionUtils.isEmpty((Collection)excludeDeployments)) {
            update.addAll(this.deploymentBuilderService.buildDeploymentsUpdate(this.deploymentRepository.findAllByDomain(domainName)));
        } else {
            List<String> toExcludeIds = excludeDeployments.stream().map(DeploymentInfo::getDeploymentId).toList();
            List<Deployment> toUpdate = this.deploymentRepository.findDeploymentsToUpdate(domainName, toExcludeIds);
            update.addAll(this.deploymentBuilderService.buildDeploymentsUpdate(toUpdate));
            Set<String> toRemoveIds = this.deploymentRepository.findDeploymentsToRemove(domainName, toExcludeIds);
            List<DeploymentInfo> toRemove = excludeDeployments.stream().filter(ex -> toRemoveIds.contains(ex.getDeploymentId())).toList();
            stop.addAll(this.deploymentBuilderService.buildDeploymentsStop(toRemove));
        }
        DeploymentsUpdate result = DeploymentsUpdate.builder().update(update).stop(stop).build();
        if (fullDeploymentsRequest && Objects.equals(currentDeploymentVersion, deploymentsUpdateVersion)) {
            fullDeploymentsUpdateCache.put(domainName, result);
        }
        return result;
    }

    private List<DeploymentRoute> buildHttpSendersRoutes(String snapshotId) {
        return this.elementRepository.findAllBySnapshotIdAndTypeIn(snapshotId, List.of("http-sender", "graphql-sender")).stream().filter(sender -> {
            Object isExternalCall = sender.getProperty("isExternalCall");
            return isExternalCall == null || (Boolean)isExternalCall != false;
        }).map(sender -> {
            try {
                String targetURL = SimpleHttpUriUtils.extractProtocolAndDomainWithPort((String)sender.getPropertyAsString("uri"));
                String gatewayPrefix = String.format("/%s/%s/%s", sender.getType(), sender.getOriginalId(), this.getEncodedURL(TriggerUtils.getHttpConnectionTimeout((ChainElement)sender), targetURL));
                DeploymentRoute.DeploymentRouteBuilder builder = DeploymentRoute.builder().path(targetURL).variableName(ElementUtils.buildRouteVariableName((ChainElement)sender)).gatewayPrefix(gatewayPrefix).type(RouteType.EXTERNAL_SENDER);
                if (sender.getType().equalsIgnoreCase("http-sender")) {
                    builder.connectTimeout(TriggerUtils.getHttpConnectionTimeout((ChainElement)sender));
                }
                return builder.build();
            }
            catch (MalformedURLException e) {
                throw new DeploymentProcessingException("Failed to post egress routes. Invalid URI in HTTP sender element");
            }
        }).toList();
    }

    private List<DeploymentRoute> buildTriggersRoutes(String snapshotId) {
        return this.elementRepository.findAllBySnapshotIdAndType(snapshotId, TriggerUtils.getHttpTriggerTypeName()).stream().map(TriggerUtils::getHttpTriggerRoute).map(route -> DeploymentRoute.builder().path("/" + route.getPath()).type(RouteType.convertTriggerType((boolean)route.isExternal(), (boolean)route.isPrivate())).connectTimeout(Long.valueOf(route.getConnectionTimeout())).build()).collect(Collectors.toList());
    }

    private List<DeploymentRoute> buildServicesRoutes(String snapshotId) {
        List serviceCallElements = this.elementRepository.findAllBySnapshotIdAndType(snapshotId, "service-call");
        Map systemsIds = serviceCallElements.stream().collect(Collectors.groupingBy(element -> (String)element.getProperty("integrationSystemId"), Collectors.mapping(Function.identity(), Collectors.toList())));
        List<IntegrationSystem> systems = this.systemService.findSystemsRequiredGatewayRoutes(systemsIds.keySet());
        ArrayList<DeploymentRoute> routes = new ArrayList<DeploymentRoute>();
        for (IntegrationSystem system : systems) {
            Environment environment = this.systemService.getActiveEnvironment(system);
            String path = this.systemService.getActiveEnvAddress(environment);
            Long connectionTimeout = this.systemService.getConnectTimeout(environment);
            RouteType routeType = this.getRouteTypeForSystemType(system.getIntegrationSystemType());
            List elements = systemsIds.get(system.getId());
            for (ChainElement element2 : elements) {
                String gatewayPrefix = String.format("/system/%s", element2.getOriginalId());
                routes.add(DeploymentRoute.builder().type(routeType).path(path).gatewayPrefix(gatewayPrefix).variableName(ElementUtils.buildRouteVariableName((ChainElement)element2)).connectTimeout(connectionTimeout).build());
            }
        }
        return routes;
    }

    private RouteType getRouteTypeForSystemType(IntegrationSystemType systemType) {
        RouteType routeType;
        if (Objects.isNull(systemType)) {
            routeType = null;
        } else {
            switch (systemType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EXTERNAL: {
                    routeType = RouteType.EXTERNAL_SERVICE;
                    break;
                }
                case INTERNAL: {
                    routeType = RouteType.INTERNAL_SERVICE;
                    break;
                }
                case IMPLEMENTED: {
                    routeType = RouteType.IMPLEMENTED_SERVICE;
                }
            }
        }
        return routeType;
    }

    public void subscribeMessages(MultiConsumer.Consumer5<String, String, String, GenericMessageType, Map<String, String>> messagesCallback) {
        this.messagesCallback = messagesCallback;
    }

    private String getEncodedURL(Long connectTimeout, String targetURL) {
        Object senderURL = targetURL;
        if (!Objects.isNull(connectTimeout) && connectTimeout > -1L) {
            senderURL = (String)senderURL + connectTimeout;
        }
        return HashUtils.sha1hex((String)senderURL);
    }

    public static void clearDeploymentsUpdateCache(Long version) {
        fullDeploymentsUpdateCache.clear();
        deploymentsUpdateVersion = version;
    }

    public static class LoggingInfo {
        public static LoggingInfo EMPTY_INFO = new LoggingInfo();
        private Long createdWhen;

        public LoggingInfo(Optional<Deployment> deploymentOptional) {
            if (deploymentOptional.isPresent()) {
                Deployment deployment = deploymentOptional.get();
                this.createdWhen = deployment.getCreatedWhen().getTime();
            }
        }

        public static LoggingInfoBuilder builder() {
            return new LoggingInfoBuilder();
        }

        public Long getCreatedWhen() {
            return this.createdWhen;
        }

        public void setCreatedWhen(Long createdWhen) {
            this.createdWhen = createdWhen;
        }

        public LoggingInfo() {
        }

        public LoggingInfo(Long createdWhen) {
            this.createdWhen = createdWhen;
        }

        public static class LoggingInfoBuilder {
            private Long createdWhen;

            LoggingInfoBuilder() {
            }

            public LoggingInfoBuilder createdWhen(Long createdWhen) {
                this.createdWhen = createdWhen;
                return this;
            }

            public LoggingInfo build() {
                return new LoggingInfo(this.createdWhen);
            }

            public String toString() {
                return "DeploymentService.LoggingInfo.LoggingInfoBuilder(createdWhen=" + this.createdWhen + ")";
            }
        }
    }
}

