/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.EnvironmentRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.EnvironmentBaseService;
import org.qubership.integration.platform.catalog.service.SystemBaseService;
import org.qubership.integration.platform.catalog.service.parsers.ParserUtils;
import org.qubership.integration.platform.runtime.catalog.service.SystemService;
import org.qubership.integration.platform.runtime.catalog.service.mapping.ServiceEnvironmentMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EnvironmentService
extends EnvironmentBaseService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentService.class);
    private static final String ENVIRONMENT_WITH_ID_NOT_FOUND_MESSAGE = "Can't find environment with id ";
    private final SystemService systemService;
    private final ServiceEnvironmentMapper serviceEnvironmentMapper;

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, ActionsLogService actionLogger, SystemService systemService, ServiceEnvironmentMapper serviceEnvironmentMapper, ParserUtils parserUtils, @Qualifier(value="primaryObjectMapper") ObjectMapper jsonMapper) {
        super(environmentRepository, (SystemBaseService)systemService, actionLogger, jsonMapper, parserUtils);
        this.serviceEnvironmentMapper = serviceEnvironmentMapper;
        this.systemService = systemService;
    }

    public Environment getByIdForSystem(String systemId, String environmentId) {
        return (Environment)this.environmentRepository.findBySystemIdAndId(systemId, environmentId).orElseThrow(() -> new EntityNotFoundException(ENVIRONMENT_WITH_ID_NOT_FOUND_MESSAGE + environmentId));
    }

    public List<Environment> getActiveEnvironmentsBySystems(List<IntegrationSystem> systems) {
        return systems.stream().map(system -> {
            List systemEnvironments = system.getEnvironments();
            if (systemEnvironments == null || systemEnvironments.isEmpty()) {
                return null;
            }
            switch (system.getIntegrationSystemType()) {
                case INTERNAL: {
                    return (Environment)systemEnvironments.get(0);
                }
                case IMPLEMENTED: {
                    String activeId = system.getActiveEnvironmentId();
                    return StringUtils.isBlank((CharSequence)activeId) ? (Environment)systemEnvironments.get(0) : (Environment)systemEnvironments.stream().filter(environment -> activeId.equals(environment.getId())).findAny().orElse(null);
                }
                case EXTERNAL: {
                    String activeId = system.getActiveEnvironmentId();
                    return StringUtils.isBlank((CharSequence)activeId) ? null : (Environment)systemEnvironments.stream().filter(environment -> activeId.equals(environment.getId())).findAny().orElse(null);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void deleteEnvironment(String systemId, String environmentId) {
        Environment oldEnvironment = this.getByIdForSystem(systemId, environmentId);
        IntegrationSystem system = oldEnvironment.getSystem();
        system.removeEnvironment(oldEnvironment);
        this.environmentRepository.delete((Object)oldEnvironment);
        this.logEnvironmentAction(oldEnvironment, system, LogOperation.DELETE);
    }

    public List<ServiceEnvironment> generateSystemEnvironments(Collection<String> ids) {
        List<IntegrationSystem> systems = ids.stream().map(arg_0 -> ((SystemService)this.systemService).getByIdOrNull(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        List<ServiceEnvironment> result = this.getActiveEnvironmentsBySystems(systems).stream().map(this.serviceEnvironmentMapper::toServiceEnvironment).collect(Collectors.toList());
        for (IntegrationSystem system : systems) {
            if (result.stream().anyMatch(environment -> environment.getSystemId().equals(system.getId()))) continue;
            ServiceEnvironment serviceEnvironment = new ServiceEnvironment();
            serviceEnvironment.setSystemId(system.getId());
            serviceEnvironment.setNotActivated(true);
            result.add(serviceEnvironment);
        }
        return result;
    }
}

