/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingInterpretation;
import org.qubership.integration.platform.runtime.catalog.mapper.MappingInterpreter;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.MappingDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MapperService {
    private static final Logger log = LoggerFactory.getLogger(MapperService.class);
    private final Map<String, MappingInterpreter> interpreters = new HashMap<String, MappingInterpreter>();

    @Autowired
    public MapperService(List<MappingInterpreter> interpreters) {
        for (MappingInterpreter interpreter : interpreters) {
            MappingInterpretation interpretation = interpreter.getClass().getAnnotation(MappingInterpretation.class);
            if (interpretation == null) continue;
            this.interpreters.put(interpretation.value(), interpreter);
        }
    }

    private MappingInterpreter getInterpreter(String interpreterName) {
        return this.interpreters.get(interpreterName);
    }

    public String getMappingInterpretation(MappingDescription mappingDescription) {
        MappingInterpreter interpreter = this.getInterpreter("AtlasMap");
        return interpreter.getInterpretation(mappingDescription);
    }
}

