/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ChainExportException;
import org.qubership.integration.platform.runtime.catalog.service.ChainService;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainExternalEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(readOnly=true)
@Service
public class ExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    private final YAMLMapper yamlMapper;
    private final ObjectMapper objectMapper;
    private final ChainService chainService;
    private final ActionsLogService actionLogger;
    private final ChainExternalEntityMapper chainExternalEntityMapper;

    @Autowired
    public ExportService(YAMLMapper yamlMapper, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, ChainService chainService, ActionsLogService actionLogger, ChainExternalEntityMapper chainExternalEntityMapper) {
        this.yamlMapper = yamlMapper;
        this.objectMapper = objectMapper;
        this.chainService = chainService;
        this.actionLogger = actionLogger;
        this.chainExternalEntityMapper = chainExternalEntityMapper;
    }

    public Pair<String, byte[]> exportAllChains() {
        List<Chain> allChains = this.chainService.findAll();
        return this.exportChain(allChains);
    }

    public Pair<String, byte[]> exportListChains(List<String> chainIds, boolean exportWithSubChains) {
        if (exportWithSubChains) {
            chainIds = this.chainService.getSubChainsIds(chainIds, new ArrayList<String>());
        }
        List<Chain> chains = this.chainService.findAllById(chainIds);
        return this.exportChain(chains);
    }

    public Pair<String, byte[]> exportSingleChain(String chainId) {
        Chain chain = this.chainService.findById(chainId);
        return this.exportChain(List.of(chain));
    }

    private Pair<String, byte[]> exportChain(@NonNull List<Chain> chains) {
        if (chains == null) {
            throw new NullPointerException("chains is marked non-null but is null");
        }
        HashMap<Path, byte[]> fileContentMap = new HashMap<Path, byte[]>();
        try {
            for (Chain chain : chains) {
                fileContentMap.putAll(this.createChainFiles(chain));
            }
            String zipName = this.generateExportZipName();
            byte[] zipBytes = this.zipChainFiles(fileContentMap);
            for (Chain chain : chains) {
                this.logChainExport(chain);
            }
            return Pair.of((Object)zipName, (Object)zipBytes);
        }
        catch (Exception e) {
            throw new ChainExportException(e);
        }
    }

    private Map<Path, byte[]> createChainFiles(Chain chain) throws IOException, JSONException {
        HashMap<Path, byte[]> result = new HashMap<Path, byte[]>();
        Path chainDirectory = this.getChainDirectory(chain);
        String chainFileName = this.generateChainYamlName(chain);
        List deployments = chain.getDeployments();
        if (deployments.size() > 1) {
            String curSnapShot = Optional.ofNullable(chain.getCurrentSnapshot()).map(AbstractEntity::getId).orElse("");
            chain.setDeployments(Collections.singletonList(deployments.stream().filter(deployment -> curSnapShot.equals(deployment.getSnapshot().getId())).findFirst().orElse(deployments.stream().min(Comparator.comparing(Deployment::getCreatedWhen)).orElse(null))));
        }
        ChainExternalMapperEntity entity = this.chainExternalEntityMapper.toExternalEntity(chain);
        String chainYaml = this.yamlMapper.writeValueAsString((Object)entity.getChainExternalEntity());
        result.put(chainDirectory.resolve(chainFileName), chainYaml.getBytes());
        entity.getElementPropertyFiles().forEach((name, data) -> result.put(chainDirectory.resolve((String)name), (byte[])data));
        return result;
    }

    private byte[] zipChainFiles(Map<Path, byte[]> fileContentMap) throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        for (Map.Entry<Path, byte[]> entry : fileContentMap.entrySet()) {
            Path path = Path.of("chains", new String[0]).resolve(entry.getKey());
            ZipEntry zipEntry = new ZipEntry(path.toString());
            zipOut.putNextEntry(zipEntry);
            byte[] data = entry.getValue();
            zipOut.write(data, 0, data.length);
            zipOut.closeEntry();
        }
        zipOut.close();
        fos.close();
        return fos.toByteArray();
    }

    public Path getChainDirectory(Chain chain) {
        return Path.of(chain.getId(), new String[0]);
    }

    public String generateExportZipName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        return "export-" + dateFormat.format(new Date()) + ".zip";
    }

    public String generateChainYamlName(Chain chain) {
        return "chain-" + chain.getId() + ".yaml";
    }

    private void logChainExport(Chain chain) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.CHAIN).entityId(chain.getId()).entityName(chain.getName()).parentType(chain.getParentFolder() == null ? null : EntityType.FOLDER).parentId(chain.getParentFolder() == null ? null : chain.getParentFolder().getId()).parentName(chain.getParentFolder() == null ? null : chain.getParentFolder().getName()).operation(LogOperation.EXPORT).build());
    }

    protected Map<String, String> getPropertiesToSaveInSeparateFile(Chain chain) throws JsonProcessingException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ChainElement element : chain.getElements()) {
            Map beforeProperty;
            ArrayList propsToExportSeparately = ExportImportUtils.getPropertiesToExportInSeparateFile((ChainElement)element);
            if (!CollectionUtils.isEmpty((Collection)propsToExportSeparately)) {
                Map properties = element.getProperties();
                String propString = null;
                if (ExportImportUtils.isPropertiesFileGroove((Map)element.getProperties()) || ExportImportUtils.isPropertiesFileSql((Map)element.getProperties())) {
                    Object propObject = properties.get(propsToExportSeparately.get(0));
                    propString = propObject != null ? propObject.toString() : "";
                } else if (ExportImportUtils.isPropertiesFileJson((Map)element.getProperties())) {
                    Map<String, Object> propsToExportSeparatelyMap = properties.keySet().stream().filter(p -> propsToExportSeparately.contains(p) && properties.get(p) != null).collect(Collectors.toMap(p -> p, properties::get));
                    if (!CollectionUtils.isEmpty((Map)propsToExportSeparatelyMap)) {
                        propString = new JSONObject(this.objectMapper.writeValueAsString((Object)propsToExportSeparatelyMap)).toString(4);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid property 'exportFileExtension' of element " + element.getId());
                }
                if (propString != null) {
                    result.put(ExportImportUtils.generatePropertiesFileName((ChainElement)element), propString);
                }
            }
            if (!"service-call".equals(element.getType())) continue;
            String propString = null;
            List afterPropertyList = (List)element.getProperties().get("after");
            if (!CollectionUtils.isEmpty((Collection)afterPropertyList)) {
                for (Map afterProperty : afterPropertyList) {
                    if ("script".equals(afterProperty.get("type"))) {
                        propString = afterProperty.get("script") != null ? afterProperty.get("script").toString() : "";
                        result.put(ExportImportUtils.generateAfterScriptFileName((String)element.getId(), (Map)afterProperty), propString);
                        continue;
                    }
                    if (null == afterProperty.get("type") || !StringUtils.contains((CharSequence)((String)afterProperty.get("type")), (CharSequence)"mapper")) continue;
                    propString = this.getPropertyStringForMapper(afterProperty);
                    result.put(ExportImportUtils.generateAfterMapperFileName((String)element.getId(), (Map)afterProperty), propString);
                }
            }
            if (CollectionUtils.isEmpty((Map)(beforeProperty = (Map)element.getProperties().get("before")))) continue;
            if ("script".equals(beforeProperty.get("type"))) {
                propString = beforeProperty.get("script") != null ? beforeProperty.get("script").toString() : "";
                result.put(ExportImportUtils.generateBeforeScriptFileName((String)element.getId()), propString);
                continue;
            }
            if (null == beforeProperty.get("type") || !StringUtils.contains((CharSequence)((String)beforeProperty.get("type")), (CharSequence)"mapper")) continue;
            propString = this.getPropertyStringForMapper(beforeProperty);
            result.put(ExportImportUtils.generateBeforeMapperFileName((String)element.getId(), (Map)beforeProperty), propString);
        }
        return result;
    }

    private String getPropertyStringForMapper(Map beforeProperty) throws JsonProcessingException, JSONException {
        String propString = "";
        List<String> props = List.of("mappingDescription", "mapping", "source", "target");
        Map<Object, Object> propsToExportSeparatelyMap = beforeProperty.keySet().stream().filter(p -> props.stream().anyMatch(p1 -> p1.equals(p)) && beforeProperty.get(p) != null).collect(Collectors.toMap(p -> p, beforeProperty::get));
        if (!CollectionUtils.isEmpty(propsToExportSeparatelyMap)) {
            propString = new JSONObject(this.objectMapper.writeValueAsString(propsToExportSeparatelyMap)).toString(4);
        }
        return propString;
    }
}

