/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.internal.lang3.tuple.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.exportimport.ExportImportUtils;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainElementExternalEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ChainElementFilePropertiesSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(ChainElementFilePropertiesSubstitutor.class);
    private final ObjectMapper objectMapper;

    public ChainElementFilePropertiesSubstitutor(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void enrichElementWithFileProperties(ChainElement element, File chainFilesDir, @Nullable String propertiesFilename) {
        try {
            Objects.requireNonNull(chainFilesDir, "Chain directory file must not be null");
            this.restoreProperties(element, chainFilesDir, propertiesFilename);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read element properties file: " + e.getMessage(), e);
        }
    }

    public Map<String, byte[]> getElementPropertiesAsSeparateFiles(ChainElementExternalEntity externalElement) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (MapUtils.isEmpty(externalElement.getProperties())) {
            return result;
        }
        try {
            this.extractPropertyToSeparateFile(externalElement).ifPresent(property -> result.put((String)property.getKey(), (byte[])property.getValue()));
            if ("service-call".equals(externalElement.getType())) {
                result.putAll(this.extractServiceCallPropertiesToSeparateFiles(externalElement));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to save element properties to separate files: " + e.getMessage(), e);
        }
        return result;
    }

    private void restoreProperties(ChainElement element, File chainFilesDir, String propertiesFilename) throws IOException {
        String beforePropertiesFilename;
        Map<String, Object> beforeProperties;
        if (!"service-call".equals(element.getType())) {
            if (propertiesFilename == null) {
                return;
            }
            Object propertiesFileContent = this.extractPropertiesFileContent(element.getProperties(), chainFilesDir, propertiesFilename);
            if (propertiesFileContent instanceof Map) {
                element.getProperties().putAll((Map)propertiesFileContent);
            } else {
                element.getProperties().put((String)element.getProperties().get("propertiesToExportInSeparateFile"), propertiesFileContent);
            }
            element.getProperties().remove("propertiesFilename");
            return;
        }
        List afterPropertiesObj = element.getProperties().getOrDefault("after", Collections.emptyList());
        if (afterPropertiesObj instanceof List) {
            List afterPropertiesList = afterPropertiesObj;
            for (Object obj : afterPropertiesList) {
                if (obj instanceof Map) {
                    Map afterProperties = (Map)obj;
                    String afterPropertiesFilename = (String)afterProperties.get("propertiesFilename");
                    if (afterPropertiesFilename == null) continue;
                    this.addServiceCallHandlerContent(afterProperties, this.extractPropertiesFileContent(afterProperties, chainFilesDir, afterPropertiesFilename));
                    afterProperties.remove("propertiesFilename");
                    continue;
                }
                log.error("Either the 'after' property is missing, or it is not formatted as a key-value pair " + obj.getClass().getName());
                throw new IllegalArgumentException("Either the 'after' property is missing, or it is not formatted as a key-value pair");
            }
        } else {
            log.error("Either the 'after' property is missing or it is not in the required format " + afterPropertiesObj.getClass().getName());
            throw new IllegalArgumentException("Either the 'after' property is missing or it is not in the required format");
        }
        Map<String, Object> beforePropertiesObj = element.getProperties().getOrDefault("before", Collections.emptyMap());
        if (beforePropertiesObj instanceof Map) {
            beforeProperties = beforePropertiesObj;
            beforePropertiesFilename = (String)beforeProperties.get("propertiesFilename");
            if (beforePropertiesFilename == null) {
                return;
            }
        } else {
            log.error("Either the 'before' property is missing, or it is not formatted as a key-value pair " + beforePropertiesObj.getClass().getName());
            throw new IllegalArgumentException("Either the 'before' property is missing, or it is not formatted as a key-value pair");
        }
        this.addServiceCallHandlerContent(beforeProperties, this.extractPropertiesFileContent(beforeProperties, chainFilesDir, beforePropertiesFilename));
        beforeProperties.remove("propertiesFilename");
    }

    private Object extractPropertiesFileContent(Map<String, Object> properties, File chainFilesDir, String propertiesFilename) throws IOException {
        String fileContent = ExportImportUtils.getFileContentByName((File)chainFilesDir, (String)propertiesFilename);
        if (fileContent == null) {
            throw new IllegalArgumentException("Could not find file with properties: " + propertiesFilename);
        }
        if (this.isPropertiesFileGroovy(propertiesFilename, properties) || this.isPropertiesFileSql(propertiesFilename, properties)) {
            return fileContent;
        }
        if (this.isPropertiesFileJson(propertiesFilename, properties)) {
            return this.objectMapper.readValue(fileContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        throw new IllegalArgumentException("The " + propertiesFilename + " properties file must have one of the following extensions: groovy, json or sql");
    }

    private void addServiceCallHandlerContent(Map<String, Object> handlerProperties, Object handlerContent) {
        Object type = handlerProperties.get("type");
        if ("script".equals(type)) {
            handlerProperties.put("script", handlerContent);
        }
        if (String.valueOf(type).startsWith("mapper")) {
            HashMap mapperContent = (HashMap)handlerContent;
            if ("mapper".equals(type)) {
                handlerProperties.put("mapping", mapperContent.get("mapping"));
                handlerProperties.put("source", mapperContent.get("source"));
                handlerProperties.put("target", mapperContent.get("target"));
            } else {
                handlerProperties.put("mappingDescription", mapperContent.get("mappingDescription"));
            }
        }
    }

    private List<String> getPropertiesToExportInSeparateFile(ChainElementExternalEntity externalElement) {
        Map<String, Object> properties = externalElement.getProperties();
        String[] propertyNames = Optional.ofNullable((String)properties.get("propertiesToExportInSeparateFile")).map(props -> props.replace(" ", "").split(",", -1)).orElse(new String[0]);
        return Arrays.asList(propertyNames);
    }

    private Optional<Pair<String, byte[]>> extractPropertyToSeparateFile(ChainElementExternalEntity externalElement) throws JsonProcessingException {
        Map<String, Object> properties = externalElement.getProperties();
        List<String> propsToExportSeparately = this.getPropertiesToExportInSeparateFile(externalElement);
        if (!CollectionUtils.isEmpty(propsToExportSeparately)) {
            String propertyContent = null;
            if (this.isPropertiesFileGroovy("", properties) || this.isPropertiesFileSql("", properties)) {
                propertyContent = Objects.toString(properties.get(propsToExportSeparately.get(0)), "");
            } else if (this.isPropertiesFileJson("", properties)) {
                Map<String, Object> propsToExportSeparatelyMap = properties.keySet().stream().filter(p -> propsToExportSeparately.contains(p) && properties.get(p) != null).collect(Collectors.toMap(p -> p, properties::get));
                if (!MapUtils.isEmpty(propsToExportSeparatelyMap)) {
                    propertyContent = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(propsToExportSeparatelyMap);
                }
            } else {
                throw new IllegalArgumentException("Invalid property 'exportFileExtension' of element " + externalElement.getId());
            }
            if (propertyContent != null) {
                String propertiesFileName = this.generatePropertiesFileName(externalElement, propsToExportSeparately);
                properties.put("propertiesFilename", propertiesFileName);
                propsToExportSeparately.forEach(properties::remove);
                return Optional.of(Pair.of((Object)propertiesFileName, (Object)propertyContent.getBytes()));
            }
        }
        return Optional.empty();
    }

    private Map<String, byte[]> extractServiceCallPropertiesToSeparateFiles(ChainElementExternalEntity externalElement) throws JsonProcessingException {
        String propertyContent;
        String fileName;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Map<String, Object> properties = externalElement.getProperties();
        List afterPropertyList = properties.getOrDefault("after", Collections.emptyList());
        for (Map afterProperty : afterPropertyList) {
            String propertyContent2;
            String fileName2;
            if ("script".equals(afterProperty.get("type"))) {
                fileName2 = this.generateAfterScriptFileName(externalElement.getId(), afterProperty);
                propertyContent2 = afterProperty.get("script") != null ? afterProperty.get("script").toString() : "";
                afterProperty.remove("script");
            } else {
                if (!StringUtils.startsWith((CharSequence)((String)afterProperty.get("type")), (CharSequence)"mapper")) continue;
                fileName2 = this.generateAfterMapperFileName(externalElement.getId(), afterProperty);
                propertyContent2 = this.extractPropertyStringForMapper(afterProperty);
            }
            afterProperty.put("propertiesFilename", fileName2);
            result.put(fileName2, propertyContent2.getBytes());
        }
        Map<String, Object> beforeProperty = properties.getOrDefault("before", Collections.emptyMap());
        if ("script".equals(beforeProperty.get("type"))) {
            fileName = this.generateBeforeScriptFileName(externalElement.getId());
            propertyContent = beforeProperty.get("script") != null ? beforeProperty.get("script").toString() : "";
            beforeProperty.remove("script");
        } else if (StringUtils.startsWith((CharSequence)((String)beforeProperty.get("type")), (CharSequence)"mapper")) {
            fileName = this.generateBeforeMapperFileName(externalElement.getId());
            propertyContent = this.extractPropertyStringForMapper(beforeProperty);
        } else {
            return result;
        }
        beforeProperty.put("propertiesFilename", fileName);
        result.put(fileName, propertyContent.getBytes());
        return result;
    }

    private String generatePropertiesFileName(ChainElementExternalEntity externalElement, List<String> propsToExportInSeparateFile) {
        String prefix = externalElement.getType() != null && externalElement.getType().startsWith("mapper") ? (propsToExportInSeparateFile.size() == 1 ? propsToExportInSeparateFile.get(0) : "mapper") : (propsToExportInSeparateFile.size() == 1 ? propsToExportInSeparateFile.get(0) : "properties");
        String extension = Optional.ofNullable(externalElement.getProperties().get("exportFileExtension")).map(Object::toString).orElse(".txt");
        return prefix + "-" + externalElement.getId() + "." + extension;
    }

    private String generateAfterScriptFileName(String id, Map<String, Object> afterProp) {
        return "script-" + String.valueOf(this.getIdOrCode(afterProp)) + "-" + id + ".groovy";
    }

    private String generateBeforeScriptFileName(String id) {
        return "script-before-" + id + ".groovy";
    }

    private String generateAfterMapperFileName(String id, Map<String, Object> afterProp) {
        return "mappingDescription-" + String.valueOf(this.getIdOrCode(afterProp)) + "-" + id + ".json";
    }

    private String generateBeforeMapperFileName(String id) {
        return "mappingDescription-before-" + id + ".json";
    }

    private Object getIdOrCode(Map<String, Object> mapProp) {
        return mapProp.get("id") == null ? mapProp.get("code") : mapProp.get("id");
    }

    private String extractPropertyStringForMapper(Map<String, Object> properties) throws JsonProcessingException {
        String propertyContent = "";
        List<String> props = List.of("mappingDescription", "mapping", "source", "target");
        Map<String, Object> propsToExportSeparatelyMap = properties.keySet().stream().filter(p -> props.stream().anyMatch(p1 -> p1.equals(p)) && properties.get(p) != null).collect(Collectors.toMap(p -> p, properties::get));
        if (!MapUtils.isEmpty(propsToExportSeparatelyMap)) {
            propertyContent = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(propsToExportSeparatelyMap);
        }
        properties.remove("mappingDescription");
        properties.remove("mapping");
        properties.remove("source");
        properties.remove("target");
        return propertyContent;
    }

    private boolean isPropertiesFileJson(String fileName, Map<String, Object> properties) {
        return "json".equals(properties.get("exportFileExtension")) || fileName.endsWith(".json");
    }

    private boolean isPropertiesFileGroovy(String fileName, Map<String, Object> properties) {
        return "groovy".equals(properties.get("exportFileExtension")) || fileName.endsWith(".groovy");
    }

    private boolean isPropertiesFileSql(String fileName, Map<String, Object> properties) {
        return "sql".equals(properties.get("exportFileExtension")) || fileName.endsWith(".sql");
    }
}

