/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.BaseExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainElementExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainElementsExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.ExternalEntityMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainElementFilePropertiesSubstitutor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ChainElementsExternalEntityMapper
implements ExternalEntityMapper<List<ChainElement>, ChainElementsExternalMapperEntity> {
    private final LibraryElementsService libraryService;
    private final ChainElementFilePropertiesSubstitutor chainElementFilePropertiesSubstitutor;

    public ChainElementsExternalEntityMapper(LibraryElementsService libraryService, ChainElementFilePropertiesSubstitutor chainElementFilePropertiesSubstitutor) {
        this.libraryService = libraryService;
        this.chainElementFilePropertiesSubstitutor = chainElementFilePropertiesSubstitutor;
    }

    @Override
    public List<ChainElement> toInternalEntity(@NonNull ChainElementsExternalMapperEntity elementsExternalMapperEntity) {
        HashMap resultElements = new HashMap();
        elementsExternalMapperEntity.getChainElementExternalEntities().stream().map(externalEntity -> Pair.of((Object)externalEntity, (Object)this.libraryService.getElementDescriptor(externalEntity.getType()))).filter(swimlaneDescriptorPair -> Optional.ofNullable((ElementDescriptor)swimlaneDescriptorPair.getValue()).map(descriptor -> descriptor.getType() == ElementType.SWIMLANE).orElse(false)).forEach(swimlaneDescriptorPair -> this.createInternalEntity((Pair<ChainElementExternalEntity, ElementDescriptor>)swimlaneDescriptorPair, elementsExternalMapperEntity.getChainFilesDirectory(), resultElements));
        elementsExternalMapperEntity.getChainElementExternalEntities().stream().map(externalElement -> Pair.of((Object)externalElement, (Object)this.libraryService.getElementDescriptor(externalElement.getType()))).filter(elementDescriptoPair -> {
            ElementDescriptor descriptor = (ElementDescriptor)elementDescriptoPair.getValue();
            return descriptor == null || descriptor.getType() != ElementType.SWIMLANE;
        }).forEach(elementDescriptorPair -> this.createInternalEntity((Pair<ChainElementExternalEntity, ElementDescriptor>)elementDescriptorPair, elementsExternalMapperEntity.getChainFilesDirectory(), resultElements));
        return resultElements.values().stream().filter(element -> element.getParent() == null).collect(Collectors.toList());
    }

    @Override
    public ChainElementsExternalMapperEntity toExternalEntity(@NonNull List<ChainElement> chainElements) {
        HashMap<String, byte[]> propertyFiles = new HashMap<String, byte[]>();
        List<ChainElementExternalEntity> elementsExternalEntities = chainElements.stream().filter(element -> element.getParent() == null).map(this::createExternalFromInternal).peek(externalElement -> propertyFiles.putAll(this.chainElementFilePropertiesSubstitutor.getElementPropertiesAsSeparateFiles((ChainElementExternalEntity)externalElement))).collect(Collectors.toList());
        return ((ChainElementsExternalMapperEntity.ChainElementsExternalMapperEntityBuilder)((ChainElementsExternalMapperEntity.ChainElementsExternalMapperEntityBuilder)ChainElementsExternalMapperEntity.builder().chainElementExternalEntities(elementsExternalEntities)).elementPropertyFiles(propertyFiles)).build();
    }

    private ChainElement createInternalEntity(Pair<ChainElementExternalEntity, ElementDescriptor> elementDescriptorPair, File chainFilesDir, Map<String, ChainElement> resultElements) {
        ChainElementExternalEntity elementExternalEntity = (ChainElementExternalEntity)elementDescriptorPair.getKey();
        ElementDescriptor descriptor = Optional.ofNullable((ElementDescriptor)elementDescriptorPair.getValue()).orElseGet(() -> {
            if ("container".equals(elementExternalEntity.getType())) {
                ElementDescriptor containerDescriptor = new ElementDescriptor();
                containerDescriptor.setType(ElementType.CONTAINER);
                containerDescriptor.setContainer(true);
                return containerDescriptor;
            }
            throw new IllegalArgumentException("Element of type " + elementExternalEntity.getType() + " not found");
        });
        Object element = descriptor.isContainer() ? new ContainerChainElement() : (ElementType.SWIMLANE == descriptor.getType() ? new SwimlaneChainElement() : new ChainElement());
        if (element instanceof ContainerChainElement) {
            ContainerChainElement containerElement = element;
            for (ChainElementExternalEntity childExternal : elementExternalEntity.getChildren()) {
                ElementDescriptor childDescriptor = this.libraryService.getElementDescriptor(childExternal.getType());
                ChainElement childEntity = this.createInternalEntity((Pair<ChainElementExternalEntity, ElementDescriptor>)Pair.of((Object)childExternal, (Object)childDescriptor), chainFilesDir, resultElements);
                containerElement.addChildElement(childEntity);
            }
        }
        element.setId(elementExternalEntity.getId());
        element.setType(elementExternalEntity.getType());
        element.setName(elementExternalEntity.getName());
        element.setDescription(elementExternalEntity.getDescription());
        element.setOriginalId(elementExternalEntity.getOriginalId());
        element.setEnvironment(elementExternalEntity.getServiceEnvironment());
        element.setProperties(elementExternalEntity.getProperties());
        element.setCreatedWhen(new Timestamp(System.currentTimeMillis()));
        ChainElement chainElement = resultElements.get(elementExternalEntity.getSwimlaneId());
        if (chainElement instanceof SwimlaneChainElement) {
            SwimlaneChainElement swimlane = (SwimlaneChainElement)chainElement;
            element.setSwimlane(swimlane);
        }
        this.chainElementFilePropertiesSubstitutor.enrichElementWithFileProperties((ChainElement)element, chainFilesDir, elementExternalEntity.getPropertiesFilename());
        resultElements.put(element.getId(), (ChainElement)element);
        return element;
    }

    private ChainElementExternalEntity createExternalFromInternal(ChainElement element) {
        ArrayList<ChainElementExternalEntity> childrenExternalEntities = new ArrayList<ChainElementExternalEntity>();
        if (element instanceof ContainerChainElement) {
            ContainerChainElement containerElement = (ContainerChainElement)element;
            for (ChainElement child : containerElement.getElements()) {
                childrenExternalEntities.add(this.createExternalFromInternal(child));
            }
        }
        return ((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)((BaseExternalEntity.BaseExternalEntityBuilder)((ChainElementExternalEntity.ChainElementExternalEntityBuilder)ChainElementExternalEntity.builder().id(element.getId())).type(element.getType())).name(element.getName())).description(element.getDescription())).children(childrenExternalEntities)).swimlaneId(Optional.ofNullable(element.getSwimlane()).map(AbstractEntity::getId).orElse(null))).originalId(element.getOriginalId())).serviceEnvironment(element.getEnvironment())).properties(new TreeMap<String, Object>(ChainElementsExternalEntityMapper.preSortProperties(element.getProperties())))).build();
    }

    public static Map<String, Object> preSortProperties(Map<String, Object> properties) {
        if (properties.containsKey("roles") && properties.get("roles") instanceof List) {
            properties.put("roles", ((List)properties.get("roles")).stream().sorted().toList());
        }
        return properties;
    }
}

