/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.FoldableEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.BaseExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainElementsExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalContentEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.ChainExternalMapperEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.DependencyExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.FolderExternalEntity;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.chain.MaskedFieldExternalEntity;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.ExternalEntityMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.mapper.chain.ChainElementsExternalEntityMapper;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainFileMigrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ChainExternalEntityMapper
implements ExternalEntityMapper<Chain, ChainExternalMapperEntity> {
    private final ChainElementsExternalEntityMapper chainElementsMapper;
    private final ChainFileMigrationService chainFileMigrationService;
    private final URI chainSchemaUri;

    @Autowired
    public ChainExternalEntityMapper(ChainElementsExternalEntityMapper chainElementsMapper, ChainFileMigrationService chainFileMigrationService, @Value(value="${qip.json.schemas.chain:http://qubership.org/schemas/product/qip/chain}") URI chainSchemaUri) {
        this.chainElementsMapper = chainElementsMapper;
        this.chainFileMigrationService = chainFileMigrationService;
        this.chainSchemaUri = chainSchemaUri;
    }

    @Override
    public Chain toInternalEntity(@NonNull ChainExternalMapperEntity externalMapperEntity) {
        ChainExternalEntity externalChain = externalMapperEntity.getChainExternalEntity();
        Chain resultChain = Optional.ofNullable(externalMapperEntity.getExistingChain()).orElse(new Chain());
        Set currentDependencies = resultChain.getDependencies();
        resultChain.setId(externalChain.getId());
        resultChain.setName(externalChain.getName());
        resultChain.setLastImportHash(externalChain.getContent().getLastImportHash());
        resultChain.setDescription(externalChain.getContent().getDescription());
        resultChain.setOverridesChainId(externalChain.getContent().getOverridesChainId());
        resultChain.setOverriddenByChainId(externalChain.getContent().getOverriddenByChainId());
        if (!externalChain.getContent().isOverridden()) {
            resultChain.setOverriddenByChainId(null);
        }
        resultChain.setBusinessDescription(externalChain.getContent().getBusinessDescription());
        resultChain.setAssumptions(externalChain.getContent().getAssumptions());
        resultChain.setOutOfScope(externalChain.getContent().getOutOfScope());
        resultChain.addLabels(this.createMissingChainLabels(externalChain.getContent().getLabels(), resultChain));
        Set resultMaskedFields = resultChain.getMaskedFields();
        Set<MaskedField> externalMaskedFields = this.createMaskedFieldInternalEntities(externalChain.getContent().getMaskedFields(), resultChain);
        Set mergedResultMaskedFields = resultMaskedFields.stream().filter(resultMaskedField -> externalMaskedFields.stream().anyMatch(externalMaskedField -> externalMaskedField.getName().equals(resultMaskedField.getName()))).collect(Collectors.toSet());
        Set mergedExternalMaskedFields = externalMaskedFields.stream().filter(externalMaskedField -> mergedResultMaskedFields.stream().noneMatch(resultMaskedField -> resultMaskedField.getName().equals(externalMaskedField.getName()))).collect(Collectors.toSet());
        resultChain.clearMaskedFields();
        resultChain.addMaskedFields(mergedResultMaskedFields);
        resultChain.addMaskedFields(mergedExternalMaskedFields);
        if (externalChain.getContent().getFolder() != null) {
            Folder newFolder = this.createFolderInternalEntity(externalChain.getContent().getFolder(), externalMapperEntity.getExistingFolder());
            resultChain.setParentFolder(newFolder);
        } else {
            resultChain.setParentFolder(null);
        }
        Object elementsMapperEntity = ((ChainElementsExternalMapperEntity.ChainElementsExternalMapperEntityBuilder)((ChainElementsExternalMapperEntity.ChainElementsExternalMapperEntityBuilder)ChainElementsExternalMapperEntity.builder().chainElementExternalEntities(externalChain.getContent().getElements())).chainFilesDirectory(externalMapperEntity.getChainFilesDirectory())).build();
        resultChain.getElements().clear();
        resultChain.addElementsHierarchy(this.chainElementsMapper.toInternalEntity((ChainElementsExternalMapperEntity)elementsMapperEntity));
        this.specifyChainSwimlanes(externalChain, resultChain);
        if (externalMapperEntity.getActionBeforeDependencyMapping() != null) {
            resultChain = externalMapperEntity.getActionBeforeDependencyMapping().apply(resultChain);
        }
        this.enrichInternalChainWithDependencies(resultChain, currentDependencies, externalChain.getContent().getDependencies());
        return resultChain;
    }

    @Override
    public ChainExternalMapperEntity toExternalEntity(@NonNull Chain chain) {
        ChainElementsExternalMapperEntity elementsExternalMapperEntity = this.chainElementsMapper.toExternalEntity(chain.getElements());
        Object chainExternalEntity = ((ChainExternalEntity.ChainExternalEntityBuilder)((ChainExternalEntity.ChainExternalEntityBuilder)((ChainExternalEntity.ChainExternalEntityBuilder)((ChainExternalEntity.ChainExternalEntityBuilder)ChainExternalEntity.builder().schema(this.chainSchemaUri)).id(chain.getId())).name(chain.getName())).content((ChainExternalContentEntity)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)((ChainExternalContentEntity.ChainExternalContentEntityBuilder)ChainExternalContentEntity.builder().description(chain.getDescription())).businessDescription(chain.getBusinessDescription())).assumptions(chain.getAssumptions())).outOfScope(chain.getOutOfScope())).labels(chain.getLabels().stream().map(AbstractLabel::getName).collect(Collectors.toList()))).folder(this.createFolderExternalEntity((FoldableEntity)chain))).modifiedWhen(chain.getModifiedWhen())).maskedFields(this.createMaskedFieldExternalEntities(chain.getMaskedFields()))).elements(elementsExternalMapperEntity.getChainElementExternalEntities())).dependencies(this.extractExternalDependencies(chain))).migrations(this.chainFileMigrationService.getActualMigrationVersions().stream().sorted().toList().toString())).build())).build();
        return ((ChainExternalMapperEntity.ChainExternalMapperEntityBuilder)((ChainExternalMapperEntity.ChainExternalMapperEntityBuilder)ChainExternalMapperEntity.builder().chainExternalEntity((ChainExternalEntity)chainExternalEntity)).elementPropertyFiles(elementsExternalMapperEntity.getElementPropertyFiles())).build();
    }

    private void specifyChainSwimlanes(ChainExternalEntity externalChain, Chain resultChain) {
        resultChain.setDefaultSwimlane(null);
        resultChain.setReuseSwimlane(null);
        if (externalChain.getContent().getDefaultSwimlaneId() != null) {
            SwimlaneChainElement defaultSwimlane = resultChain.getElements().stream().filter(element -> externalChain.getContent().getDefaultSwimlaneId().equals(element.getId())).filter(element -> element instanceof SwimlaneChainElement).findFirst().map(element -> (SwimlaneChainElement)element).orElseThrow(() -> new IllegalArgumentException("Default swimlane " + externalChain.getContent().getDefaultSwimlaneId() + " not found"));
            resultChain.setDefaultSwimlane(defaultSwimlane);
            defaultSwimlane.setDefaultSwimlane(true);
        }
        if (externalChain.getContent().getReuseSwimlaneId() != null) {
            SwimlaneChainElement reuseSwimlane = resultChain.getElements().stream().filter(element -> externalChain.getContent().getReuseSwimlaneId().equals(element.getId())).filter(element -> element instanceof SwimlaneChainElement).findFirst().map(element -> (SwimlaneChainElement)element).orElseThrow(() -> new IllegalArgumentException("Reuse swimlane " + externalChain.getContent().getReuseSwimlaneId() + " not found"));
            resultChain.setReuseSwimlane(reuseSwimlane);
            reuseSwimlane.setReuseSwimlane(true);
        }
    }

    private void enrichInternalChainWithDependencies(Chain resultChain, Set<Dependency> currentDependencies, List<DependencyExternalEntity> dependencyExternalEntities) {
        Map<String, ChainElement> elements = this.extractAllElements(resultChain.getElements());
        HashMap existingDependencies = new HashMap();
        currentDependencies.forEach(currentDependency -> {
            String fromId = currentDependency.getElementFrom().getId();
            String toId = currentDependency.getElementTo().getId();
            boolean importedDependencyExists = dependencyExternalEntities.stream().anyMatch(dependency -> fromId.equals(dependency.getFrom()) && toId.equals(dependency.getTo()));
            if (importedDependencyExists) {
                existingDependencies.put(this.generateDependencyKey(fromId, toId), (Dependency)currentDependency);
            }
        });
        for (DependencyExternalEntity dependencyEntity : dependencyExternalEntities) {
            ChainElement elementFrom = elements.get(dependencyEntity.getFrom());
            ChainElement elementTo = elements.get(dependencyEntity.getTo());
            if (elementFrom == null || elementTo == null) {
                throw new IllegalArgumentException("Unable to create dependency. At least one element not found: " + String.valueOf(dependencyEntity));
            }
            Dependency dependency = existingDependencies.getOrDefault(this.generateDependencyKey(dependencyEntity.getFrom(), dependencyEntity.getTo()), Dependency.of((ChainElement)elementFrom, (ChainElement)elementTo));
            elementFrom.getOutputDependencies().add(dependency);
            elementTo.getInputDependencies().add(dependency);
        }
    }

    private List<DependencyExternalEntity> extractExternalDependencies(Chain chain) {
        return chain.getElements().stream().flatMap(element -> Stream.concat(element.getInputDependencies().stream(), element.getOutputDependencies().stream())).filter(DistinctByKey.newInstance(Dependency::getId)).map(dependency -> new DependencyExternalEntity(dependency.getElementFrom().getId(), dependency.getElementTo().getId())).collect(Collectors.toList());
    }

    private Folder createFolderInternalEntity(FolderExternalEntity folderExternalEntity, Folder existingRootFolder) {
        Folder resultFolder = null;
        for (FolderExternalEntity currentFolderExternalEntity = folderExternalEntity; currentFolderExternalEntity != null; currentFolderExternalEntity = currentFolderExternalEntity.getSubfolder()) {
            Folder newFolder;
            if (existingRootFolder != null) {
                newFolder = existingRootFolder;
                newFolder.setName(currentFolderExternalEntity.getName());
                newFolder.setDescription(currentFolderExternalEntity.getDescription());
                String subfolderName = Optional.ofNullable(currentFolderExternalEntity.getSubfolder()).map(BaseExternalEntity::getName).orElse("");
                existingRootFolder = existingRootFolder.getFolderList().stream().filter(folder -> subfolderName.equals(folder.getName())).findFirst().orElse(null);
            } else {
                newFolder = ((Folder.FolderBuilder)((Folder.FolderBuilder)Folder.builder().name(currentFolderExternalEntity.getName())).description(currentFolderExternalEntity.getDescription())).build();
                if (resultFolder != null) {
                    resultFolder.addChildFolder(newFolder);
                }
            }
            resultFolder = newFolder;
        }
        return resultFolder;
    }

    private FolderExternalEntity createFolderExternalEntity(FoldableEntity folder) {
        BaseExternalEntity folderExternalEntity = null;
        while (folder.getParentFolder() != null) {
            folder = folder.getParentFolder();
            folderExternalEntity = ((FolderExternalEntity.FolderExternalEntityBuilder)((FolderExternalEntity.FolderExternalEntityBuilder)((FolderExternalEntity.FolderExternalEntityBuilder)FolderExternalEntity.builder().name(folder.getName())).description(folder.getDescription())).subfolder((FolderExternalEntity)folderExternalEntity)).build();
        }
        return folderExternalEntity;
    }

    private Set<ChainLabel> createMissingChainLabels(List<String> labels, Chain resultChain) {
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptySet();
        }
        return labels.stream().filter(label -> !resultChain.getLabels().stream().map(AbstractLabel::getName).toList().contains(label)).map(label -> ((ChainLabel.ChainLabelBuilder)ChainLabel.builder().name(label)).chain(resultChain).build()).collect(Collectors.toSet());
    }

    private Set<MaskedField> createMaskedFieldInternalEntities(Set<MaskedFieldExternalEntity> maskedFieldExtEntities, Chain chain) {
        HashSet<MaskedField> maskedFields = new HashSet<MaskedField>();
        for (MaskedFieldExternalEntity maskedFieldExtEntity : maskedFieldExtEntities) {
            maskedFields.add(((MaskedField.MaskedFieldBuilder)MaskedField.builder().name(maskedFieldExtEntity.getName())).chain(chain).build());
        }
        return maskedFields;
    }

    private Set<MaskedFieldExternalEntity> createMaskedFieldExternalEntities(Set<MaskedField> maskedFields) {
        return maskedFields.stream().map(maskedField -> new MaskedFieldExternalEntity(maskedField.getId(), maskedField.getName())).collect(Collectors.toSet());
    }

    private Map<String, ChainElement> extractAllElements(List<ChainElement> elements) {
        HashMap<String, ChainElement> result = new HashMap<String, ChainElement>();
        for (ChainElement element : elements) {
            result.put(element.getId(), element);
            if (!(element instanceof ContainerChainElement)) continue;
            ContainerChainElement containerElement = (ContainerChainElement)element;
            result.putAll(containerElement.extractAllChildElements());
        }
        return result;
    }

    private String generateDependencyKey(String fromId, String toId) {
        return fromId + "_" + toId;
    }
}

