/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.integration.platform.runtime.catalog.rest.v1.exception.exceptions.ChainImportException;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.ImportFileMigration;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.ChainImportFileMigration;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.versions.ChainFileVersionsGetterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChainFileMigrationService {
    private static final Logger log = LoggerFactory.getLogger(ChainFileMigrationService.class);
    private final YAMLMapper yamlMapper;
    private final Map<Integer, ChainImportFileMigration> chainImportFileMigrationMap;
    private final ChainFileVersionsGetterService chainFileVersionsGetterService;

    @Autowired
    public ChainFileMigrationService(YAMLMapper yamlMapper, Collection<ChainImportFileMigration> chainImportFileMigrations, ChainFileVersionsGetterService chainFileVersionsGetterService) {
        this.yamlMapper = yamlMapper;
        this.chainImportFileMigrationMap = chainImportFileMigrations.stream().collect(Collectors.toMap(ImportFileMigration::getVersion, Function.identity()));
        this.chainFileVersionsGetterService = chainFileVersionsGetterService;
    }

    public String migrateToActualVersion(String data) throws Exception {
        List<Integer> importVersions;
        ObjectNode fileNode = (ObjectNode)this.yamlMapper.readTree(data);
        String chainId = Optional.ofNullable(fileNode.get("id")).map(JsonNode::asText).orElse(null);
        try {
            importVersions = this.chainFileVersionsGetterService.getVersions(fileNode);
        }
        catch (Exception exception) {
            throw new Exception("Failed to retrieve chain migration data for chain with ID: " + chainId, exception);
        }
        log.trace("importVersions = {}", importVersions);
        log.trace("actualVersions = {}", this.getActualMigrationVersions());
        ArrayList<Integer> nonexistentVersions = new ArrayList<Integer>(importVersions);
        nonexistentVersions.removeAll(this.getActualMigrationVersions());
        if (!nonexistentVersions.isEmpty()) {
            String chainName = Optional.ofNullable(fileNode.get("name")).map(JsonNode::asText).orElse(null);
            log.error("Unable to import a chain {} ({}) exported from newer version: nonexistent migrations {} are present", new Object[]{chainName, chainId, nonexistentVersions});
            throw new ChainImportException(chainId, chainName, "Unable to import a chain exported from newer version");
        }
        ArrayList<Integer> versionsToMigrate = new ArrayList<Integer>(this.getActualMigrationVersions());
        versionsToMigrate.removeAll(importVersions);
        versionsToMigrate.sort(null);
        log.trace("versionsToMigrate = {}", versionsToMigrate);
        Iterator iterator = versionsToMigrate.iterator();
        while (iterator.hasNext()) {
            int version = (Integer)iterator.next();
            fileNode = this.chainImportFileMigrationMap.get(version).makeMigration(fileNode);
        }
        return this.yamlMapper.writeValueAsString((Object)fileNode);
    }

    public Collection<Integer> getActualMigrationVersions() {
        return this.chainImportFileMigrationMap.keySet();
    }
}

