/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.versions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.migrations.chain.versions.ChainFileVersionsGetterStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChainFileVersionsGetterService {
    private static final Logger log = LoggerFactory.getLogger(ChainFileVersionsGetterService.class);
    private final List<ChainFileVersionsGetterStrategy> strategies;

    @Autowired
    public ChainFileVersionsGetterService(List<ChainFileVersionsGetterStrategy> strategies) {
        this.strategies = strategies;
    }

    public List<Integer> getVersions(ObjectNode document) throws Exception {
        return this.strategies.stream().map(strategy -> {
            log.trace("Applying chain file migrations getter strategy: {}", (Object)strategy.getClass().getName());
            Optional<List<Integer>> result = strategy.getVersions(document);
            log.trace("Result: {}", result);
            return result;
        }).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new Exception("Failed to get a chain migration data"));
    }
}

