/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.verification;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.ElementPropertiesVerifierFactory;
import org.qubership.integration.platform.runtime.catalog.service.verification.properties.VerificationError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElementPropertiesVerificationService {
    private final ElementPropertiesVerifierFactory elementPropertiesVerifierFactory;

    @Autowired
    public ElementPropertiesVerificationService(ElementPropertiesVerifierFactory elementPropertiesVerifierFactory) {
        this.elementPropertiesVerifierFactory = elementPropertiesVerifierFactory;
    }

    public Collection<VerificationError> verifyProperties(ChainElement element) {
        return this.elementPropertiesVerifierFactory.getElementPropertiesVerifier(element).verify(element);
    }

    public Map<ChainElement, Collection<VerificationError>> verifyElementProperties(Chain chain) {
        return chain.getElements().stream().map(element -> Map.entry(element, this.verifyProperties((ChainElement)element))).filter(e -> !((Collection)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

