/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.runtime.catalog.model.constant;

public final class ConfigConstants {

    /**
     * Constants that are used to build xml configuration
     */
    public static final String SLASH = "/";

    public static final String PROPS_START_SIGN = "?";
    public static final String PROPS_DIVIDER_SIGN = "&amp;";
    public static final String EQUALS_SIGN = "=";
    public static final String COLON = ":";
    public static final String DASH = "-";

    public static final String CDATA = "<![CDATA[\n";
    public static final String CDATA_CLOSE = "\n]]>";
    public static final String DIRECT_URI = "direct:";

    public static final String AUTOGENERATED_MULTICAST_NAME = "Autogenerated multicast";

    private ConfigConstants() {
    }
}
