package org.qubership.integration.platform.runtime.catalog.model.mapper.mapping;

import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.chain.ChainLiteDTO;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-06-26T12:55:50+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class ChainLiteMapperImpl implements ChainLiteMapper {

    @Override
    public ChainLiteDTO asDto(AbstractEntity entity) {
        if ( entity == null ) {
            return null;
        }

        if (entity instanceof Chain) {
            return chainToChainLiteDTO( (Chain) entity );
        }
        else if (entity instanceof Snapshot) {
            return asDto( (Snapshot) entity );
        }
        else {
            ChainLiteDTO.ChainLiteDTOBuilder<?, ?> chainLiteDTO = ChainLiteDTO.builder();

            chainLiteDTO.id( entity.getId() );
            chainLiteDTO.name( entity.getName() );
            chainLiteDTO.description( entity.getDescription() );
            chainLiteDTO.createdWhen( MapperUtils.fromTimestamp( entity.getCreatedWhen() ) );
            chainLiteDTO.createdBy( userToUserDTO( entity.getCreatedBy() ) );
            chainLiteDTO.modifiedWhen( MapperUtils.fromTimestamp( entity.getModifiedWhen() ) );
            chainLiteDTO.modifiedBy( userToUserDTO( entity.getModifiedBy() ) );

            return chainLiteDTO.build();
        }
    }

    @Override
    public ChainLiteDTO asDto(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }

        ChainLiteDTO.ChainLiteDTOBuilder<?, ?> chainLiteDTO = ChainLiteDTO.builder();

        chainLiteDTO.currentSnapshotId( snapshot.getId() );
        chainLiteDTO.currentSnapshotName( snapshot.getName() );
        chainLiteDTO.id( snapshotChainId( snapshot ) );
        chainLiteDTO.name( snapshotChainName( snapshot ) );
        chainLiteDTO.description( snapshot.getDescription() );
        chainLiteDTO.createdWhen( MapperUtils.fromTimestamp( snapshot.getCreatedWhen() ) );
        chainLiteDTO.createdBy( userToUserDTO( snapshot.getCreatedBy() ) );
        chainLiteDTO.modifiedWhen( MapperUtils.fromTimestamp( snapshot.getModifiedWhen() ) );
        chainLiteDTO.modifiedBy( userToUserDTO( snapshot.getModifiedBy() ) );
        chainLiteDTO.dependencies( asDependencyResponses( snapshot.getDependencies() ) );

        return chainLiteDTO.build();
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }

    protected ChainLiteDTO chainToChainLiteDTO(Chain chain) {
        if ( chain == null ) {
            return null;
        }

        ChainLiteDTO.ChainLiteDTOBuilder<?, ?> chainLiteDTO = ChainLiteDTO.builder();

        chainLiteDTO.id( chain.getId() );
        chainLiteDTO.name( chain.getName() );
        chainLiteDTO.description( chain.getDescription() );
        chainLiteDTO.createdWhen( MapperUtils.fromTimestamp( chain.getCreatedWhen() ) );
        chainLiteDTO.createdBy( userToUserDTO( chain.getCreatedBy() ) );
        chainLiteDTO.modifiedWhen( MapperUtils.fromTimestamp( chain.getModifiedWhen() ) );
        chainLiteDTO.modifiedBy( userToUserDTO( chain.getModifiedBy() ) );
        chainLiteDTO.dependencies( asDependencyResponses( chain.getDependencies() ) );

        return chainLiteDTO.build();
    }

    private String snapshotChainId(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }
        Chain chain = snapshot.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String snapshotChainName(Snapshot snapshot) {
        if ( snapshot == null ) {
            return null;
        }
        Chain chain = snapshot.getChain();
        if ( chain == null ) {
            return null;
        }
        String name = chain.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }
}
