package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.UserMapper;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.element.ElementResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.element.ElementsCodeDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.element.PatchElementRequest;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.util.StringTrimmer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-06-26T12:55:48+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class ElementMapperImpl extends ElementMapper {

    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StringTrimmer stringTrimmer;

    @Override
    public void elementToResponse(ElementResponse target, ChainElement element) {
        if ( element == null ) {
            return;
        }

        String id = elementParentId( element );
        if ( id != null ) {
            target.setParentElementId( stringTrimmer.trimString( id ) );
        }
        String id1 = elementChainId( element );
        if ( id1 != null ) {
            target.setChainId( stringTrimmer.trimString( id1 ) );
        }
        String id2 = elementSwimlaneId( element );
        if ( id2 != null ) {
            target.setSwimlaneId( stringTrimmer.trimString( id2 ) );
        }
        if ( element.getId() != null ) {
            target.setId( stringTrimmer.trimString( element.getId() ) );
        }
        if ( element.getName() != null ) {
            target.setName( stringTrimmer.trimString( element.getName() ) );
        }
        if ( element.getDescription() != null ) {
            target.setDescription( stringTrimmer.trimString( element.getDescription() ) );
        }
        if ( element.getCreatedWhen() != null ) {
            target.setCreatedWhen( MapperUtils.fromTimestamp( element.getCreatedWhen() ) );
        }
        if ( element.getCreatedBy() != null ) {
            target.setCreatedBy( userMapper.asDTO( element.getCreatedBy() ) );
        }
        if ( element.getModifiedWhen() != null ) {
            target.setModifiedWhen( MapperUtils.fromTimestamp( element.getModifiedWhen() ) );
        }
        if ( element.getModifiedBy() != null ) {
            target.setModifiedBy( userMapper.asDTO( element.getModifiedBy() ) );
        }
        if ( element.getType() != null ) {
            target.setType( stringTrimmer.trimString( element.getType() ) );
        }
        if ( element.getOriginalId() != null ) {
            target.setOriginalId( stringTrimmer.trimString( element.getOriginalId() ) );
        }
        if ( target.getProperties() != null ) {
            Map<String, Object> map = stringTrimmer.trimMapValue( element.getProperties() );
            if ( map != null ) {
                target.getProperties().clear();
                target.getProperties().putAll( map );
            }
        }
        else {
            Map<String, Object> map = stringTrimmer.trimMapValue( element.getProperties() );
            if ( map != null ) {
                target.setProperties( map );
            }
        }
    }

    @Override
    public void containerElementToResponse(ElementResponse target, ContainerChainElement container) {
        if ( container == null ) {
            return;
        }

        if ( target.getChildren() != null ) {
            List<ElementResponse> list = toElementResponses( container.getElements() );
            if ( list != null ) {
                target.getChildren().clear();
                target.getChildren().addAll( list );
            }
        }
        else {
            List<ElementResponse> list = toElementResponses( container.getElements() );
            if ( list != null ) {
                target.setChildren( list );
            }
        }
        String id = containerParentId( container );
        if ( id != null ) {
            target.setParentElementId( stringTrimmer.trimString( id ) );
        }
        String id1 = containerChainId( container );
        if ( id1 != null ) {
            target.setChainId( stringTrimmer.trimString( id1 ) );
        }
        String id2 = containerSwimlaneId( container );
        if ( id2 != null ) {
            target.setSwimlaneId( stringTrimmer.trimString( id2 ) );
        }
        if ( container.getId() != null ) {
            target.setId( stringTrimmer.trimString( container.getId() ) );
        }
        if ( container.getName() != null ) {
            target.setName( stringTrimmer.trimString( container.getName() ) );
        }
        if ( container.getDescription() != null ) {
            target.setDescription( stringTrimmer.trimString( container.getDescription() ) );
        }
        if ( container.getCreatedWhen() != null ) {
            target.setCreatedWhen( MapperUtils.fromTimestamp( container.getCreatedWhen() ) );
        }
        if ( container.getCreatedBy() != null ) {
            target.setCreatedBy( userMapper.asDTO( container.getCreatedBy() ) );
        }
        if ( container.getModifiedWhen() != null ) {
            target.setModifiedWhen( MapperUtils.fromTimestamp( container.getModifiedWhen() ) );
        }
        if ( container.getModifiedBy() != null ) {
            target.setModifiedBy( userMapper.asDTO( container.getModifiedBy() ) );
        }
        if ( container.getType() != null ) {
            target.setType( stringTrimmer.trimString( container.getType() ) );
        }
        if ( container.getOriginalId() != null ) {
            target.setOriginalId( stringTrimmer.trimString( container.getOriginalId() ) );
        }
        if ( target.getProperties() != null ) {
            Map<String, Object> map = stringTrimmer.trimMapValue( container.getProperties() );
            if ( map != null ) {
                target.getProperties().clear();
                target.getProperties().putAll( map );
            }
        }
        else {
            Map<String, Object> map = stringTrimmer.trimMapValue( container.getProperties() );
            if ( map != null ) {
                target.setProperties( map );
            }
        }
    }

    @Override
    public List<ElementResponse> toElementResponses(List<ChainElement> elements) {
        if ( elements == null ) {
            return null;
        }

        List<ElementResponse> list = new ArrayList<ElementResponse>( elements.size() );
        for ( ChainElement chainElement : elements ) {
            list.add( toElementResponse( chainElement ) );
        }

        return list;
    }

    @Override
    public Map<String, ElementResponse> toElementResponses(Map<String, ChainElement> elements) {
        if ( elements == null ) {
            return null;
        }

        Map<String, ElementResponse> map = new LinkedHashMap<String, ElementResponse>( Math.max( (int) ( elements.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, ChainElement> entry : elements.entrySet() ) {
            String key = stringTrimmer.trimString( entry.getKey() );
            ElementResponse value = toElementResponse( entry.getValue() );
            map.put( key, value );
        }

        return map;
    }

    @Override
    public void patch(ChainElement element, PatchElementRequest request) {
        if ( request == null ) {
            return;
        }

        if ( request.getName() != null ) {
            element.setName( stringTrimmer.trimString( request.getName() ) );
        }
        if ( request.getDescription() != null ) {
            element.setDescription( stringTrimmer.trimString( request.getDescription() ) );
        }
        if ( element.getProperties() != null ) {
            Map<String, Object> map = stringTrimmer.trimMapValue( request.getProperties() );
            if ( map != null ) {
                element.getProperties().clear();
                element.getProperties().putAll( map );
            }
        }
        else {
            Map<String, Object> map = stringTrimmer.trimMapValue( request.getProperties() );
            if ( map != null ) {
                element.setProperties( map );
            }
        }
        if ( request.getType() != null ) {
            element.setType( stringTrimmer.trimString( request.getType() ) );
        }
    }

    @Override
    public void merge(ChainElement element, ChainElement request) {
        if ( request == null ) {
            return;
        }

        if ( request.getId() != null ) {
            element.setId( stringTrimmer.trimString( request.getId() ) );
        }
        if ( request.getName() != null ) {
            element.setName( stringTrimmer.trimString( request.getName() ) );
        }
        if ( request.getDescription() != null ) {
            element.setDescription( stringTrimmer.trimString( request.getDescription() ) );
        }
        if ( request.getCreatedWhen() != null ) {
            element.setCreatedWhen( request.getCreatedWhen() );
        }
        if ( request.getModifiedWhen() != null ) {
            element.setModifiedWhen( request.getModifiedWhen() );
        }
        if ( request.getCreatedBy() != null ) {
            element.setCreatedBy( request.getCreatedBy() );
        }
        if ( request.getModifiedBy() != null ) {
            element.setModifiedBy( request.getModifiedBy() );
        }
        if ( request.getChain() != null ) {
            element.setChain( request.getChain() );
        }
        if ( request.getParent() != null ) {
            if ( element.getParent() == null ) {
                element.setParent( ContainerChainElement.builder().build() );
            }
            merge( element.getParent(), request.getParent() );
        }
        if ( request.getSwimlane() != null ) {
            if ( element.getSwimlane() == null ) {
                element.setSwimlane( SwimlaneChainElement.builder().build() );
            }
            merge( element.getSwimlane(), request.getSwimlane() );
        }
        if ( element.getProperties() != null ) {
            Map<String, Object> map = stringTrimmer.trimMapValue( request.getProperties() );
            if ( map != null ) {
                element.getProperties().clear();
                element.getProperties().putAll( map );
            }
        }
        else {
            Map<String, Object> map = stringTrimmer.trimMapValue( request.getProperties() );
            if ( map != null ) {
                element.setProperties( map );
            }
        }
        if ( request.getEnvironment() != null ) {
            element.setEnvironment( request.getEnvironment() );
        }
        if ( request.getSnapshot() != null ) {
            element.setSnapshot( request.getSnapshot() );
        }
        if ( request.getType() != null ) {
            element.setType( stringTrimmer.trimString( request.getType() ) );
        }
        if ( request.getOriginalId() != null ) {
            element.setOriginalId( stringTrimmer.trimString( request.getOriginalId() ) );
        }
        if ( element.getInputDependencies() != null ) {
            List<Dependency> list = request.getInputDependencies();
            if ( list != null ) {
                element.getInputDependencies().clear();
                element.getInputDependencies().addAll( list );
            }
        }
        else {
            List<Dependency> list = request.getInputDependencies();
            if ( list != null ) {
                element.setInputDependencies( new ArrayList<Dependency>( list ) );
            }
        }
        if ( element.getOutputDependencies() != null ) {
            List<Dependency> list1 = request.getOutputDependencies();
            if ( list1 != null ) {
                element.getOutputDependencies().clear();
                element.getOutputDependencies().addAll( list1 );
            }
        }
        else {
            List<Dependency> list1 = request.getOutputDependencies();
            if ( list1 != null ) {
                element.setOutputDependencies( new ArrayList<Dependency>( list1 ) );
            }
        }
        if ( element.getValidationAlerts() != null ) {
            List<ValidationChainAlert> list2 = request.getValidationAlerts();
            if ( list2 != null ) {
                element.getValidationAlerts().clear();
                element.getValidationAlerts().addAll( list2 );
            }
        }
        else {
            List<ValidationChainAlert> list2 = request.getValidationAlerts();
            if ( list2 != null ) {
                element.setValidationAlerts( new ArrayList<ValidationChainAlert>( list2 ) );
            }
        }
    }

    @Override
    public ElementsCodeDTO elementsCodeToDTO(String yaml) {
        if ( yaml == null ) {
            return null;
        }

        ElementsCodeDTO.ElementsCodeDTOBuilder elementsCodeDTO = ElementsCodeDTO.builder();

        elementsCodeDTO.code( stringTrimmer.trimString( yaml ) );

        return elementsCodeDTO.build();
    }

    private String elementParentId(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }
        ContainerChainElement parent = chainElement.getParent();
        if ( parent == null ) {
            return null;
        }
        String id = parent.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String elementChainId(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }
        Chain chain = chainElement.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String elementSwimlaneId(ChainElement chainElement) {
        if ( chainElement == null ) {
            return null;
        }
        SwimlaneChainElement swimlane = chainElement.getSwimlane();
        if ( swimlane == null ) {
            return null;
        }
        String id = swimlane.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String containerParentId(ContainerChainElement containerChainElement) {
        if ( containerChainElement == null ) {
            return null;
        }
        ContainerChainElement parent = containerChainElement.getParent();
        if ( parent == null ) {
            return null;
        }
        String id = parent.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String containerChainId(ContainerChainElement containerChainElement) {
        if ( containerChainElement == null ) {
            return null;
        }
        Chain chain = containerChainElement.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String containerSwimlaneId(ContainerChainElement containerChainElement) {
        if ( containerChainElement == null ) {
            return null;
        }
        SwimlaneChainElement swimlane = containerChainElement.getSwimlane();
        if ( swimlane == null ) {
            return null;
        }
        String id = swimlane.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
