package org.qubership.integration.platform.runtime.catalog.model.mapper.mapping;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.system.EnvironmentDTO;
import org.qubership.integration.platform.runtime.catalog.model.dto.system.EnvironmentRequestDTO;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.model.system.EnvironmentLabel;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-15T14:47:58+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class EnvironmentMapperImpl extends EnvironmentMapper {

    @Override
    public EnvironmentDTO toDTO(Environment environment) {
        if ( environment == null ) {
            return null;
        }

        EnvironmentDTO environmentDTO = new EnvironmentDTO();

        environmentDTO.setSystemId( environmentSystemId( environment ) );
        environmentDTO.setId( environment.getId() );
        environmentDTO.setName( environment.getName() );
        environmentDTO.setDescription( environment.getDescription() );
        environmentDTO.setAddress( environment.getAddress() );
        List<EnvironmentLabel> list = environment.getLabels();
        if ( list != null ) {
            environmentDTO.setLabels( new ArrayList<EnvironmentLabel>( list ) );
        }
        environmentDTO.setProperties( environment.getProperties() );
        environmentDTO.setCreatedWhen( MapperUtils.fromTimestamp( environment.getCreatedWhen() ) );
        environmentDTO.setCreatedBy( userToUserDTO( environment.getCreatedBy() ) );
        environmentDTO.setModifiedWhen( MapperUtils.fromTimestamp( environment.getModifiedWhen() ) );
        environmentDTO.setModifiedBy( userToUserDTO( environment.getModifiedBy() ) );
        environmentDTO.setSourceType( environment.getSourceType() );
        environmentDTO.setMaasInstanceId( environment.getMaasInstanceId() );

        environmentDTO.setDefaultProperties( getDefaultProperties(environment) );
        environmentDTO.setMaasDefaultProperties( getMaasDefaultProperties(environment) );

        return environmentDTO;
    }

    @Override
    public List<EnvironmentDTO> toDTOs(List<Environment> environments) {
        if ( environments == null ) {
            return null;
        }

        List<EnvironmentDTO> list = new ArrayList<EnvironmentDTO>( environments.size() );
        for ( Environment environment : environments ) {
            list.add( toDTO( environment ) );
        }

        return list;
    }

    @Override
    public Environment toEnvironment(EnvironmentRequestDTO environmentRequestDTO) {
        if ( environmentRequestDTO == null ) {
            return null;
        }

        Environment.EnvironmentBuilder<?, ?> environment = Environment.builder();

        environment.name( environmentRequestDTO.getName() );
        environment.address( environmentRequestDTO.getAddress() );
        environment.sourceType( environmentRequestDTO.getSourceType() );
        List<EnvironmentLabel> list = environmentRequestDTO.getLabels();
        if ( list != null ) {
            environment.labels( new ArrayList<EnvironmentLabel>( list ) );
        }
        environment.maasInstanceId( environmentRequestDTO.getMaasInstanceId() );
        environment.properties( environmentRequestDTO.getProperties() );

        return environment.build();
    }

    @Override
    public void merge(EnvironmentRequestDTO environmentRequestDTO, Environment environment) {
        if ( environmentRequestDTO == null ) {
            return;
        }

        environment.setName( environmentRequestDTO.getName() );
        environment.setAddress( environmentRequestDTO.getAddress() );
        environment.setSourceType( environmentRequestDTO.getSourceType() );
        if ( environment.getLabels() != null ) {
            List<EnvironmentLabel> list = environmentRequestDTO.getLabels();
            if ( list != null ) {
                environment.getLabels().clear();
                environment.getLabels().addAll( list );
            }
            else {
                environment.setLabels( null );
            }
        }
        else {
            List<EnvironmentLabel> list = environmentRequestDTO.getLabels();
            if ( list != null ) {
                environment.setLabels( new ArrayList<EnvironmentLabel>( list ) );
            }
        }
        environment.setMaasInstanceId( environmentRequestDTO.getMaasInstanceId() );
        environment.setProperties( environmentRequestDTO.getProperties() );
    }

    private String environmentSystemId(Environment environment) {
        if ( environment == null ) {
            return null;
        }
        IntegrationSystem system = environment.getSystem();
        if ( system == null ) {
            return null;
        }
        String id = system.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }
}
