package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.deployment.RuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.runtime.catalog.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.runtime.catalog.model.deployment.engine.EngineInfo;
import org.qubership.integration.platform.runtime.catalog.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.runtime.catalog.model.dto.deployment.DeploymentResponse;
import org.qubership.integration.platform.runtime.catalog.model.dto.deployment.DeploymentRuntime;
import org.qubership.integration.platform.runtime.catalog.model.dto.deployment.RuntimeDeploymentState;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.UserMapper;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Snapshot;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.DeploymentRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.deployment.RuntimeDeploymentUpdate;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-15T14:47:59+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class DeploymentMapperImpl extends DeploymentMapper {

    @Autowired
    private UserMapper userMapper;

    @Override
    public DeploymentResponse asResponse(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }

        DeploymentResponse.DeploymentResponseBuilder deploymentResponse = DeploymentResponse.builder();

        deploymentResponse.snapshotId( deploymentSnapshotId( deployment ) );
        deploymentResponse.chainId( deploymentChainId( deployment ) );
        deploymentResponse.id( deployment.getId() );
        deploymentResponse.name( deployment.getName() );
        deploymentResponse.domain( deployment.getDomain() );
        deploymentResponse.createdWhen( MapperUtils.fromTimestamp( deployment.getCreatedWhen() ) );
        deploymentResponse.createdBy( userMapper.asDTO( deployment.getCreatedBy() ) );
        deploymentResponse.suspended( deployment.isSuspended() );

        return deploymentResponse.build();
    }

    @Override
    public DeploymentResponse asResponse(Deployment deployment, RuntimeDeployment state) {
        if ( deployment == null && state == null ) {
            return null;
        }

        DeploymentResponse.DeploymentResponseBuilder deploymentResponse = DeploymentResponse.builder();

        if ( deployment != null ) {
            deploymentResponse.id( deployment.getId() );
            deploymentResponse.chainId( deploymentChainId( deployment ) );
            deploymentResponse.snapshotId( deploymentSnapshotId( deployment ) );
            deploymentResponse.domain( deployment.getDomain() );
            deploymentResponse.suspended( deployment.isSuspended() );
            deploymentResponse.name( deployment.getName() );
            deploymentResponse.createdWhen( MapperUtils.fromTimestamp( deployment.getCreatedWhen() ) );
            deploymentResponse.createdBy( userMapper.asDTO( deployment.getCreatedBy() ) );
        }
        if ( state != null ) {
            deploymentResponse.runtime( runtimeDeploymentToDeploymentRuntime( state ) );
            deploymentResponse.serviceName( state.getServiceName() );
        }

        return deploymentResponse.build();
    }

    @Override
    public RuntimeDeploymentState toDTO(EngineDeployment state) {
        if ( state == null ) {
            return null;
        }

        RuntimeDeploymentState runtimeDeploymentState = new RuntimeDeploymentState();

        runtimeDeploymentState.setStatus( state.getStatus() );
        runtimeDeploymentState.setError( state.getErrorMessage() );
        runtimeDeploymentState.setSuspended( state.isSuspended() );

        return runtimeDeploymentState;
    }

    @Override
    public RuntimeDeploymentUpdate toRuntimeUpdate(EngineDeployment deployment, EngineInfo engineInfo, DeploymentService.LoggingInfo loggingInfo) {
        if ( deployment == null && engineInfo == null && loggingInfo == null ) {
            return null;
        }

        RuntimeDeploymentUpdate runtimeDeploymentUpdate = new RuntimeDeploymentUpdate();

        if ( deployment != null ) {
            runtimeDeploymentUpdate.setState( engineDeploymentToRuntimeDeploymentState( deployment ) );
            runtimeDeploymentUpdate.setId( deploymentDeploymentInfoDeploymentId( deployment ) );
            runtimeDeploymentUpdate.setChainId( deploymentDeploymentInfoChainId( deployment ) );
            runtimeDeploymentUpdate.setChainName( deploymentDeploymentInfoChainName( deployment ) );
            runtimeDeploymentUpdate.setChainStatusCode( deploymentDeploymentInfoChainStatusCode( deployment ) );
            runtimeDeploymentUpdate.setSnapshotId( deploymentDeploymentInfoSnapshotId( deployment ) );
        }
        if ( engineInfo != null ) {
            runtimeDeploymentUpdate.setEngineHost( engineInfo.getHost() );
            runtimeDeploymentUpdate.setDomain( engineInfo.getDomain() );
            runtimeDeploymentUpdate.setServiceName( engineInfo.getEngineDeploymentName() );
        }
        if ( loggingInfo != null ) {
            runtimeDeploymentUpdate.setCreatedWhen( loggingInfo.getCreatedWhen() );
        }

        return runtimeDeploymentUpdate;
    }

    @Override
    public Deployment asEntity(DeploymentRequest request) {
        if ( request == null ) {
            return null;
        }

        Deployment deployment = new Deployment();

        deployment.setSnapshot( deploymentRequestToSnapshot( request ) );
        deployment.setDomain( request.getDomain() );
        deployment.setName( request.getName() );
        if ( request.getSuspended() != null ) {
            deployment.setSuspended( request.getSuspended() );
        }

        return deployment;
    }

    @Override
    public void merge(Deployment entity, DeploymentRequest request) {
        if ( request == null ) {
            return;
        }

        if ( request.getDomain() != null ) {
            entity.setDomain( request.getDomain() );
        }
        if ( request.getName() != null ) {
            entity.setName( request.getName() );
        }
        if ( request.getSuspended() != null ) {
            entity.setSuspended( request.getSuspended() );
        }
    }

    @Override
    public ChainRuntimeDeployment toChainRuntimeDeployment(EngineDeployment deployment, String host) {
        if ( deployment == null && host == null ) {
            return null;
        }

        ChainRuntimeDeployment.ChainRuntimeDeploymentBuilder<?, ?> chainRuntimeDeployment = ChainRuntimeDeployment.builder();

        if ( deployment != null ) {
            chainRuntimeDeployment.deploymentInfo( deployment.getDeploymentInfo() );
            chainRuntimeDeployment.status( deployment.getStatus() );
            chainRuntimeDeployment.suspended( deployment.isSuspended() );
            chainRuntimeDeployment.errorMessage( deployment.getErrorMessage() );
        }
        chainRuntimeDeployment.host( host );

        return chainRuntimeDeployment.build();
    }

    private String deploymentSnapshotId(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }
        Snapshot snapshot = deployment.getSnapshot();
        if ( snapshot == null ) {
            return null;
        }
        String id = snapshot.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String deploymentChainId(Deployment deployment) {
        if ( deployment == null ) {
            return null;
        }
        Chain chain = deployment.getChain();
        if ( chain == null ) {
            return null;
        }
        String id = chain.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected Map<String, RuntimeDeploymentState> stringEngineDeploymentMapToStringRuntimeDeploymentStateMap(Map<String, EngineDeployment> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, RuntimeDeploymentState> map1 = new LinkedHashMap<String, RuntimeDeploymentState>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, EngineDeployment> entry : map.entrySet() ) {
            String key = entry.getKey();
            RuntimeDeploymentState value = toDTO( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected DeploymentRuntime runtimeDeploymentToDeploymentRuntime(RuntimeDeployment runtimeDeployment) {
        if ( runtimeDeployment == null ) {
            return null;
        }

        DeploymentRuntime deploymentRuntime = new DeploymentRuntime();

        deploymentRuntime.setStates( stringEngineDeploymentMapToStringRuntimeDeploymentStateMap( runtimeDeployment.getStates() ) );

        return deploymentRuntime;
    }

    protected RuntimeDeploymentState engineDeploymentToRuntimeDeploymentState(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }

        RuntimeDeploymentState runtimeDeploymentState = new RuntimeDeploymentState();

        runtimeDeploymentState.setError( engineDeployment.getErrorMessage() );
        runtimeDeploymentState.setStatus( engineDeployment.getStatus() );

        return runtimeDeploymentState;
    }

    private String deploymentDeploymentInfoDeploymentId(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }
        DeploymentInfo deploymentInfo = engineDeployment.getDeploymentInfo();
        if ( deploymentInfo == null ) {
            return null;
        }
        String deploymentId = deploymentInfo.getDeploymentId();
        if ( deploymentId == null ) {
            return null;
        }
        return deploymentId;
    }

    private String deploymentDeploymentInfoChainId(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }
        DeploymentInfo deploymentInfo = engineDeployment.getDeploymentInfo();
        if ( deploymentInfo == null ) {
            return null;
        }
        String chainId = deploymentInfo.getChainId();
        if ( chainId == null ) {
            return null;
        }
        return chainId;
    }

    private String deploymentDeploymentInfoChainName(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }
        DeploymentInfo deploymentInfo = engineDeployment.getDeploymentInfo();
        if ( deploymentInfo == null ) {
            return null;
        }
        String chainName = deploymentInfo.getChainName();
        if ( chainName == null ) {
            return null;
        }
        return chainName;
    }

    private String deploymentDeploymentInfoChainStatusCode(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }
        DeploymentInfo deploymentInfo = engineDeployment.getDeploymentInfo();
        if ( deploymentInfo == null ) {
            return null;
        }
        String chainStatusCode = deploymentInfo.getChainStatusCode();
        if ( chainStatusCode == null ) {
            return null;
        }
        return chainStatusCode;
    }

    private String deploymentDeploymentInfoSnapshotId(EngineDeployment engineDeployment) {
        if ( engineDeployment == null ) {
            return null;
        }
        DeploymentInfo deploymentInfo = engineDeployment.getDeploymentInfo();
        if ( deploymentInfo == null ) {
            return null;
        }
        String snapshotId = deploymentInfo.getSnapshotId();
        if ( snapshotId == null ) {
            return null;
        }
        return snapshotId;
    }

    protected Snapshot deploymentRequestToSnapshot(DeploymentRequest deploymentRequest) {
        if ( deploymentRequest == null ) {
            return null;
        }

        Snapshot.SnapshotBuilder<?, ?> snapshot = Snapshot.builder();

        snapshot.id( deploymentRequest.getSnapshotId() );

        return snapshot.build();
    }
}
