package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SpecificationGroupLabel;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SpecificationGroupDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SpecificationGroupLabelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SpecificationGroupRequestDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-15T14:47:59+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class SpecificationGroupMapperImpl implements SpecificationGroupMapper {

    @Autowired
    private SystemModelBaseMapper systemModelBaseMapper;
    @Autowired
    private ChainBaseMapper chainBaseMapper;

    @Override
    public SpecificationGroupDTO toSpecificationGroupDTO(SpecificationGroup specificationGroup) {
        if ( specificationGroup == null ) {
            return null;
        }

        SpecificationGroupDTO specificationGroupDTO = new SpecificationGroupDTO();

        specificationGroupDTO.setSystemId( specificationGroupSystemId( specificationGroup ) );
        specificationGroupDTO.setSpecifications( systemModelBaseMapper.toDTOs( specificationGroup.getSystemModels() ) );
        specificationGroupDTO.setId( specificationGroup.getId() );
        specificationGroupDTO.setName( specificationGroup.getName() );
        specificationGroupDTO.setUrl( specificationGroup.getUrl() );
        specificationGroupDTO.setSynchronization( specificationGroup.isSynchronization() );
        specificationGroupDTO.setCreatedWhen( MapperUtils.fromTimestamp( specificationGroup.getCreatedWhen() ) );
        specificationGroupDTO.setCreatedBy( userToUserDTO( specificationGroup.getCreatedBy() ) );
        specificationGroupDTO.setModifiedWhen( MapperUtils.fromTimestamp( specificationGroup.getModifiedWhen() ) );
        specificationGroupDTO.setModifiedBy( userToUserDTO( specificationGroup.getModifiedBy() ) );
        specificationGroupDTO.setChains( chainBaseMapper.asDTO( specificationGroup.getChains() ) );
        specificationGroupDTO.setLabels( specificationGroupLabelSetToSpecificationGroupLabelDTOList( specificationGroup.getLabels() ) );

        return specificationGroupDTO;
    }

    @Override
    public List<SpecificationGroupDTO> toSpecificationGroupDTOs(List<SpecificationGroup> specificationGroups) {
        if ( specificationGroups == null ) {
            return null;
        }

        List<SpecificationGroupDTO> list = new ArrayList<SpecificationGroupDTO>( specificationGroups.size() );
        for ( SpecificationGroup specificationGroup : specificationGroups ) {
            list.add( toSpecificationGroupDTO( specificationGroup ) );
        }

        return list;
    }

    @Override
    public void mergeWithoutLabels(SpecificationGroupDTO specificationGroupDTO, SpecificationGroup specificationGroup) {
        if ( specificationGroupDTO == null ) {
            return;
        }

        specificationGroup.setId( specificationGroupDTO.getId() );
        specificationGroup.setName( specificationGroupDTO.getName() );
        specificationGroup.setCreatedWhen( MapperUtils.toTimestamp( specificationGroupDTO.getCreatedWhen() ) );
        specificationGroup.setModifiedWhen( MapperUtils.toTimestamp( specificationGroupDTO.getModifiedWhen() ) );
        if ( specificationGroupDTO.getCreatedBy() != null ) {
            if ( specificationGroup.getCreatedBy() == null ) {
                specificationGroup.setCreatedBy( User.builder().build() );
            }
            userDTOToUser( specificationGroupDTO.getCreatedBy(), specificationGroup.getCreatedBy() );
        }
        else {
            specificationGroup.setCreatedBy( null );
        }
        if ( specificationGroupDTO.getModifiedBy() != null ) {
            if ( specificationGroup.getModifiedBy() == null ) {
                specificationGroup.setModifiedBy( User.builder().build() );
            }
            userDTOToUser( specificationGroupDTO.getModifiedBy(), specificationGroup.getModifiedBy() );
        }
        else {
            specificationGroup.setModifiedBy( null );
        }
        if ( specificationGroup.getLabels() != null ) {
            Set<SpecificationGroupLabel> set = specificationGroupLabelDTOListToSpecificationGroupLabelSet( specificationGroupDTO.getLabels() );
            if ( set != null ) {
                specificationGroup.getLabels().clear();
                specificationGroup.getLabels().addAll( set );
            }
            else {
                specificationGroup.setLabels( null );
            }
        }
        else {
            Set<SpecificationGroupLabel> set = specificationGroupLabelDTOListToSpecificationGroupLabelSet( specificationGroupDTO.getLabels() );
            if ( set != null ) {
                specificationGroup.setLabels( set );
            }
        }
        specificationGroup.setUrl( specificationGroupDTO.getUrl() );
        specificationGroup.setSynchronization( specificationGroupDTO.isSynchronization() );
        if ( specificationGroup.getChains() != null ) {
            List<Chain> list = baseResponseListToChainList( specificationGroupDTO.getChains() );
            if ( list != null ) {
                specificationGroup.getChains().clear();
                specificationGroup.getChains().addAll( list );
            }
            else {
                specificationGroup.setChains( null );
            }
        }
        else {
            List<Chain> list = baseResponseListToChainList( specificationGroupDTO.getChains() );
            if ( list != null ) {
                specificationGroup.setChains( list );
            }
        }
    }

    @Override
    public void mergeWithoutLabels(SpecificationGroupRequestDTO specificationGroupDTO, SpecificationGroup specificationGroup) {
        if ( specificationGroupDTO == null ) {
            return;
        }

        specificationGroup.setSynchronization( specificationGroupDTO.isSynchronization() );
    }

    @Override
    public SpecificationGroupLabel asLabelRequest(SpecificationGroupLabelDTO snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SpecificationGroupLabel.SpecificationGroupLabelBuilder<?, ?> specificationGroupLabel = SpecificationGroupLabel.builder();

        specificationGroupLabel.name( snapshotLabel.getName() );
        if ( snapshotLabel.getTechnical() != null ) {
            specificationGroupLabel.technical( snapshotLabel.getTechnical() );
        }

        return specificationGroupLabel.build();
    }

    @Override
    public List<SpecificationGroupLabel> asLabelRequests(List<SpecificationGroupLabelDTO> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SpecificationGroupLabel> list = new ArrayList<SpecificationGroupLabel>( snapshotLabel.size() );
        for ( SpecificationGroupLabelDTO specificationGroupLabelDTO : snapshotLabel ) {
            list.add( asLabelRequest( specificationGroupLabelDTO ) );
        }

        return list;
    }

    @Override
    public SpecificationGroupLabelDTO asLabelResponse(SpecificationGroupLabel snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SpecificationGroupLabelDTO.SpecificationGroupLabelDTOBuilder specificationGroupLabelDTO = SpecificationGroupLabelDTO.builder();

        specificationGroupLabelDTO.name( snapshotLabel.getName() );
        specificationGroupLabelDTO.technical( snapshotLabel.isTechnical() );

        return specificationGroupLabelDTO.build();
    }

    @Override
    public List<SpecificationGroupLabelDTO> asLabelResponse(List<SpecificationGroupLabel> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SpecificationGroupLabelDTO> list = new ArrayList<SpecificationGroupLabelDTO>( snapshotLabel.size() );
        for ( SpecificationGroupLabel specificationGroupLabel : snapshotLabel ) {
            list.add( asLabelResponse( specificationGroupLabel ) );
        }

        return list;
    }

    private String specificationGroupSystemId(SpecificationGroup specificationGroup) {
        if ( specificationGroup == null ) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if ( system == null ) {
            return null;
        }
        String id = system.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }

    protected List<SpecificationGroupLabelDTO> specificationGroupLabelSetToSpecificationGroupLabelDTOList(Set<SpecificationGroupLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<SpecificationGroupLabelDTO> list = new ArrayList<SpecificationGroupLabelDTO>( set.size() );
        for ( SpecificationGroupLabel specificationGroupLabel : set ) {
            list.add( asLabelResponse( specificationGroupLabel ) );
        }

        return list;
    }

    protected void userDTOToUser(UserDTO userDTO, User mappingTarget) {
        if ( userDTO == null ) {
            return;
        }

        mappingTarget.setId( userDTO.getId() );
        mappingTarget.setUsername( userDTO.getUsername() );
    }

    protected Set<SpecificationGroupLabel> specificationGroupLabelDTOListToSpecificationGroupLabelSet(List<SpecificationGroupLabelDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<SpecificationGroupLabel> set = new LinkedHashSet<SpecificationGroupLabel>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( SpecificationGroupLabelDTO specificationGroupLabelDTO : list ) {
            set.add( asLabelRequest( specificationGroupLabelDTO ) );
        }

        return set;
    }

    protected User userDTOToUser1(UserDTO userDTO) {
        if ( userDTO == null ) {
            return null;
        }

        User.UserBuilder user = User.builder();

        user.id( userDTO.getId() );
        user.username( userDTO.getUsername() );

        return user.build();
    }

    protected Chain baseResponseToChain(BaseResponse baseResponse) {
        if ( baseResponse == null ) {
            return null;
        }

        Chain.ChainBuilder<?, ?> chain = Chain.builder();

        chain.id( baseResponse.getId() );
        chain.name( baseResponse.getName() );
        chain.description( baseResponse.getDescription() );
        chain.createdWhen( MapperUtils.toTimestamp( baseResponse.getCreatedWhen() ) );
        chain.modifiedWhen( MapperUtils.toTimestamp( baseResponse.getModifiedWhen() ) );
        chain.createdBy( userDTOToUser1( baseResponse.getCreatedBy() ) );
        chain.modifiedBy( userDTOToUser1( baseResponse.getModifiedBy() ) );

        return chain.build();
    }

    protected List<Chain> baseResponseListToChainList(List<BaseResponse> list) {
        if ( list == null ) {
            return null;
        }

        List<Chain> list1 = new ArrayList<Chain>( list.size() );
        for ( BaseResponse baseResponse : list ) {
            list1.add( baseResponseToChain( baseResponse ) );
        }

        return list1;
    }
}
