package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.discovery.DiscoveredServiceDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.discovery.DiscoveredServiceGroupDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-22T15:10:56+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class DiscoveryServiceMapperImpl extends DiscoveryServiceMapper {

    @Override
    public DiscoveredServiceDTO toDiscoveredServiceDTO(IntegrationSystem system) {
        if ( system == null ) {
            return null;
        }

        DiscoveredServiceDTO discoveredServiceDTO = new DiscoveredServiceDTO();

        discoveredServiceDTO.setId( system.getId() );
        discoveredServiceDTO.setName( system.getName() );
        discoveredServiceDTO.setInternalServiceName( system.getInternalServiceName() );
        discoveredServiceDTO.setCreatedWhen( MapperUtils.fromTimestamp( system.getCreatedWhen() ) );

        after( system, discoveredServiceDTO );

        return discoveredServiceDTO;
    }

    @Override
    public DiscoveredServiceGroupDTO toDiscoveredServiceGroupDTO(SpecificationGroup group) {
        if ( group == null ) {
            return null;
        }

        DiscoveredServiceGroupDTO discoveredServiceGroupDTO = new DiscoveredServiceGroupDTO();

        discoveredServiceGroupDTO.setId( group.getId() );
        discoveredServiceGroupDTO.setName( group.getName() );
        discoveredServiceGroupDTO.setSynchronization( group.isSynchronization() );
        discoveredServiceGroupDTO.setCreatedWhen( MapperUtils.fromTimestamp( group.getCreatedWhen() ) );

        afterGroup( group, discoveredServiceGroupDTO );

        return discoveredServiceGroupDTO;
    }

    @Override
    public List<DiscoveredServiceDTO> toDiscoveredServiceDTOs(List<IntegrationSystem> systems) {
        if ( systems == null ) {
            return null;
        }

        List<DiscoveredServiceDTO> list = new ArrayList<DiscoveredServiceDTO>( systems.size() );
        for ( IntegrationSystem integrationSystem : systems ) {
            list.add( toDiscoveredServiceDTO( integrationSystem ) );
        }

        return list;
    }

    @Override
    public List<DiscoveredServiceGroupDTO> toDiscoveredServiceGroupDTOs(List<SpecificationGroup> groups) {
        if ( groups == null ) {
            return null;
        }

        List<DiscoveredServiceGroupDTO> list = new ArrayList<DiscoveredServiceGroupDTO>( groups.size() );
        for ( SpecificationGroup specificationGroup : groups ) {
            list.add( toDiscoveredServiceGroupDTO( specificationGroup ) );
        }

        return list;
    }
}
