package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystemLabel;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.SystemDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.SystemLabelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.SystemRequestDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-22T15:10:57+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class SystemMapperImpl implements SystemMapper {

    @Override
    public SystemDTO toDTO(IntegrationSystem system) {
        if ( system == null ) {
            return null;
        }

        SystemDTO systemDTO = new SystemDTO();

        systemDTO.setType( system.getIntegrationSystemType() );
        systemDTO.setProtocol( systemProtocolValue( system ) );
        systemDTO.setExtendedProtocol( protocolToString( system.getProtocol() ) );
        systemDTO.setSpecification( systemProtocolType( system ) );
        systemDTO.setId( system.getId() );
        systemDTO.setName( system.getName() );
        systemDTO.setDescription( system.getDescription() );
        systemDTO.setInternalServiceName( system.getInternalServiceName() );
        systemDTO.setLabels( integrationSystemLabelSetToSystemLabelDTOList( system.getLabels() ) );
        systemDTO.setCreatedWhen( MapperUtils.fromTimestamp( system.getCreatedWhen() ) );
        systemDTO.setCreatedBy( userToUserDTO( system.getCreatedBy() ) );
        systemDTO.setModifiedWhen( MapperUtils.fromTimestamp( system.getModifiedWhen() ) );
        systemDTO.setModifiedBy( userToUserDTO( system.getModifiedBy() ) );

        systemDTO.setActiveEnvironmentId( getActiveEnvironmentId(system) );

        return systemDTO;
    }

    @Override
    public IntegrationSystem toSystem(SystemRequestDTO dto) {
        if ( dto == null ) {
            return null;
        }

        IntegrationSystem.IntegrationSystemBuilder<?, ?> integrationSystem = IntegrationSystem.builder();

        integrationSystem.integrationSystemType( dto.getType() );
        integrationSystem.name( dto.getName() );
        integrationSystem.description( dto.getDescription() );
        integrationSystem.activeEnvironmentId( dto.getActiveEnvironmentId() );
        integrationSystem.labels( systemLabelDTOListToIntegrationSystemLabelSet( dto.getLabels() ) );

        return integrationSystem.build();
    }

    @Override
    public List<SystemDTO> toResponseDTOs(List<IntegrationSystem> systems) {
        if ( systems == null ) {
            return null;
        }

        List<SystemDTO> list = new ArrayList<SystemDTO>( systems.size() );
        for ( IntegrationSystem integrationSystem : systems ) {
            list.add( toDTO( integrationSystem ) );
        }

        return list;
    }

    @Override
    public void mergeWithoutLabels(SystemRequestDTO systemDto, IntegrationSystem system) {
        if ( systemDto == null ) {
            return;
        }

        system.setName( systemDto.getName() );
        system.setDescription( systemDto.getDescription() );
        system.setActiveEnvironmentId( systemDto.getActiveEnvironmentId() );
    }

    @Override
    public void patchMergeWithoutLabels(SystemRequestDTO systemDto, IntegrationSystem system) {
        if ( systemDto == null ) {
            return;
        }

        if ( systemDto.getName() != null ) {
            system.setName( systemDto.getName() );
        }
        if ( systemDto.getDescription() != null ) {
            system.setDescription( systemDto.getDescription() );
        }
        if ( systemDto.getActiveEnvironmentId() != null ) {
            system.setActiveEnvironmentId( systemDto.getActiveEnvironmentId() );
        }
    }

    @Override
    public IntegrationSystemLabel asLabelRequest(SystemLabelDTO snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        IntegrationSystemLabel.IntegrationSystemLabelBuilder<?, ?> integrationSystemLabel = IntegrationSystemLabel.builder();

        integrationSystemLabel.name( snapshotLabel.getName() );
        if ( snapshotLabel.getTechnical() != null ) {
            integrationSystemLabel.technical( snapshotLabel.getTechnical() );
        }

        return integrationSystemLabel.build();
    }

    @Override
    public List<IntegrationSystemLabel> asLabelRequests(List<SystemLabelDTO> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<IntegrationSystemLabel> list = new ArrayList<IntegrationSystemLabel>( snapshotLabel.size() );
        for ( SystemLabelDTO systemLabelDTO : snapshotLabel ) {
            list.add( asLabelRequest( systemLabelDTO ) );
        }

        return list;
    }

    @Override
    public SystemLabelDTO asLabelResponse(IntegrationSystemLabel snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SystemLabelDTO.SystemLabelDTOBuilder systemLabelDTO = SystemLabelDTO.builder();

        systemLabelDTO.name( snapshotLabel.getName() );
        systemLabelDTO.technical( snapshotLabel.isTechnical() );

        return systemLabelDTO.build();
    }

    @Override
    public List<SystemLabelDTO> asLabelResponse(List<IntegrationSystemLabel> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SystemLabelDTO> list = new ArrayList<SystemLabelDTO>( snapshotLabel.size() );
        for ( IntegrationSystemLabel integrationSystemLabel : snapshotLabel ) {
            list.add( asLabelResponse( integrationSystemLabel ) );
        }

        return list;
    }

    private String systemProtocolValue(IntegrationSystem integrationSystem) {
        if ( integrationSystem == null ) {
            return null;
        }
        OperationProtocol protocol = integrationSystem.getProtocol();
        if ( protocol == null ) {
            return null;
        }
        String value = protocol.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    private String systemProtocolType(IntegrationSystem integrationSystem) {
        if ( integrationSystem == null ) {
            return null;
        }
        OperationProtocol protocol = integrationSystem.getProtocol();
        if ( protocol == null ) {
            return null;
        }
        String type = protocol.getType();
        if ( type == null ) {
            return null;
        }
        return type;
    }

    protected List<SystemLabelDTO> integrationSystemLabelSetToSystemLabelDTOList(Set<IntegrationSystemLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<SystemLabelDTO> list = new ArrayList<SystemLabelDTO>( set.size() );
        for ( IntegrationSystemLabel integrationSystemLabel : set ) {
            list.add( asLabelResponse( integrationSystemLabel ) );
        }

        return list;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }

    protected Set<IntegrationSystemLabel> systemLabelDTOListToIntegrationSystemLabelSet(List<SystemLabelDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<IntegrationSystemLabel> set = new LinkedHashSet<IntegrationSystemLabel>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( SystemLabelDTO systemLabelDTO : list ) {
            set.add( asLabelRequest( systemLabelDTO ) );
        }

        return set;
    }
}
