package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SystemModelBaseDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SystemModelLabelDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-22T15:10:56+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class SystemModelBaseMapperImpl implements SystemModelBaseMapper {

    @Autowired
    private ChainBaseMapper chainBaseMapper;

    @Override
    public SystemModelBaseDTO toDTO(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }

        SystemModelBaseDTO systemModelBaseDTO = new SystemModelBaseDTO();

        systemModelBaseDTO.setSpecificationGroupId( systemModelSpecificationGroupId( systemModel ) );
        systemModelBaseDTO.setSystemId( systemModelSpecificationGroupSystemId( systemModel ) );
        systemModelBaseDTO.setId( systemModel.getId() );
        systemModelBaseDTO.setDescription( systemModel.getDescription() );
        systemModelBaseDTO.setName( systemModel.getName() );
        systemModelBaseDTO.setDeprecated( systemModel.isDeprecated() );
        systemModelBaseDTO.setVersion( systemModel.getVersion() );
        if ( systemModel.getSource() != null ) {
            systemModelBaseDTO.setSource( systemModel.getSource().name() );
        }
        systemModelBaseDTO.setCreatedWhen( MapperUtils.fromTimestamp( systemModel.getCreatedWhen() ) );
        systemModelBaseDTO.setCreatedBy( userToUserDTO( systemModel.getCreatedBy() ) );
        systemModelBaseDTO.setModifiedWhen( MapperUtils.fromTimestamp( systemModel.getModifiedWhen() ) );
        systemModelBaseDTO.setModifiedBy( userToUserDTO( systemModel.getModifiedBy() ) );
        systemModelBaseDTO.setChains( chainBaseMapper.asDTO( systemModel.getChains() ) );
        systemModelBaseDTO.setLabels( systemModelLabelSetToSystemModelLabelDTOList( systemModel.getLabels() ) );

        return systemModelBaseDTO;
    }

    @Override
    public List<SystemModelBaseDTO> toDTOs(List<SystemModel> systemModels) {
        if ( systemModels == null ) {
            return null;
        }

        List<SystemModelBaseDTO> list = new ArrayList<SystemModelBaseDTO>( systemModels.size() );
        for ( SystemModel systemModel : systemModels ) {
            list.add( toDTO( systemModel ) );
        }

        return list;
    }

    @Override
    public SystemModelLabel asLabelRequest(SystemModelLabelDTO snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SystemModelLabel.SystemModelLabelBuilder<?, ?> systemModelLabel = SystemModelLabel.builder();

        systemModelLabel.name( snapshotLabel.getName() );
        if ( snapshotLabel.getTechnical() != null ) {
            systemModelLabel.technical( snapshotLabel.getTechnical() );
        }

        return systemModelLabel.build();
    }

    @Override
    public List<SystemModelLabel> asLabelRequests(List<SystemModelLabelDTO> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SystemModelLabel> list = new ArrayList<SystemModelLabel>( snapshotLabel.size() );
        for ( SystemModelLabelDTO systemModelLabelDTO : snapshotLabel ) {
            list.add( asLabelRequest( systemModelLabelDTO ) );
        }

        return list;
    }

    @Override
    public SystemModelLabelDTO asLabelResponse(SystemModelLabel snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SystemModelLabelDTO.SystemModelLabelDTOBuilder systemModelLabelDTO = SystemModelLabelDTO.builder();

        systemModelLabelDTO.name( snapshotLabel.getName() );
        systemModelLabelDTO.technical( snapshotLabel.isTechnical() );

        return systemModelLabelDTO.build();
    }

    @Override
    public List<SystemModelLabelDTO> asLabelResponse(List<SystemModelLabel> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>( snapshotLabel.size() );
        for ( SystemModelLabel systemModelLabel : snapshotLabel ) {
            list.add( asLabelResponse( systemModelLabel ) );
        }

        return list;
    }

    private String systemModelSpecificationGroupId(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if ( specificationGroup == null ) {
            return null;
        }
        String id = specificationGroup.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String systemModelSpecificationGroupSystemId(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if ( specificationGroup == null ) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if ( system == null ) {
            return null;
        }
        String id = system.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }

    protected List<SystemModelLabelDTO> systemModelLabelSetToSystemModelLabelDTOList(Set<SystemModelLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>( set.size() );
        for ( SystemModelLabel systemModelLabel : set ) {
            list.add( asLabelResponse( systemModelLabel ) );
        }

        return list;
    }
}
