package org.qubership.integration.platform.runtime.catalog.rest.v2.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.UserMapper;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.ChainLabel;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.chain.ChainLabelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.ItemType;
import org.qubership.integration.platform.runtime.catalog.rest.v1.mapper.ChainLabelsMapper;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.ChainItem;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.qubership.integration.platform.runtime.catalog.util.StringTrimmer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-22T15:10:57+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class ChainItemMapperImpl implements ChainItemMapper {

    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StringTrimmer stringTrimmer;
    @Autowired
    private ChainLabelsMapper chainLabelsMapper;

    @Override
    public ChainItem asChainItem(Chain chain) {
        if ( chain == null ) {
            return null;
        }

        ChainItem.ChainItemBuilder<?, ?> chainItem = ChainItem.builder();

        chainItem.parentId( stringTrimmer.trimString( chainParentFolderId( chain ) ) );
        chainItem.id( stringTrimmer.trimString( chain.getId() ) );
        chainItem.name( stringTrimmer.trimString( chain.getName() ) );
        chainItem.description( stringTrimmer.trimString( chain.getDescription() ) );
        chainItem.createdWhen( MapperUtils.fromTimestamp( chain.getCreatedWhen() ) );
        chainItem.createdBy( userMapper.asDTO( chain.getCreatedBy() ) );
        chainItem.modifiedWhen( MapperUtils.fromTimestamp( chain.getModifiedWhen() ) );
        chainItem.modifiedBy( userMapper.asDTO( chain.getModifiedBy() ) );
        chainItem.labels( chainLabelSetToChainLabelDTOList( chain.getLabels() ) );

        chainItem.itemType( ItemType.CHAIN );

        return chainItem.build();
    }

    private String chainParentFolderId(Chain chain) {
        if ( chain == null ) {
            return null;
        }
        Folder parentFolder = chain.getParentFolder();
        if ( parentFolder == null ) {
            return null;
        }
        String id = parentFolder.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected List<ChainLabelDTO> chainLabelSetToChainLabelDTOList(Set<ChainLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<ChainLabelDTO> list = new ArrayList<ChainLabelDTO>( set.size() );
        for ( ChainLabel chainLabel : set ) {
            list.add( chainLabelsMapper.asDTO( chainLabel ) );
        }

        return list;
    }
}
