package org.qubership.integration.platform.runtime.catalog.rest.v2.mapper;

import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.UserMapper;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.ItemType;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.CreateFolderRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.FolderItem;
import org.qubership.integration.platform.runtime.catalog.rest.v2.dto.UpdateFolderRequest;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-22T15:10:57+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.7 (Eclipse Adoptium)"
)
@Component
public class FolderItemMapperImpl implements FolderItemMapper {

    @Autowired
    private UserMapper userMapper;

    @Override
    public Folder asFolder(CreateFolderRequest request) {
        if ( request == null ) {
            return null;
        }

        Folder.FolderBuilder<?, ?> folder = Folder.builder();

        if ( request.getId() != null ) {
            folder.id( request.getId() );
        }
        folder.name( request.getName() );
        folder.description( request.getDescription() );

        return folder.build();
    }

    @Override
    public Folder asFolder(UpdateFolderRequest request) {
        if ( request == null ) {
            return null;
        }

        Folder.FolderBuilder<?, ?> folder = Folder.builder();

        folder.name( request.getName() );
        folder.description( request.getDescription() );

        return folder.build();
    }

    @Override
    public FolderItem asFolderItem(Folder folder) {
        if ( folder == null ) {
            return null;
        }

        FolderItem.FolderItemBuilder<?, ?> folderItem = FolderItem.builder();

        folderItem.parentId( folderParentFolderId( folder ) );
        folderItem.id( folder.getId() );
        folderItem.name( folder.getName() );
        folderItem.description( folder.getDescription() );
        folderItem.createdWhen( MapperUtils.fromTimestamp( folder.getCreatedWhen() ) );
        folderItem.createdBy( userMapper.asDTO( folder.getCreatedBy() ) );
        folderItem.modifiedWhen( MapperUtils.fromTimestamp( folder.getModifiedWhen() ) );
        folderItem.modifiedBy( userMapper.asDTO( folder.getModifiedBy() ) );

        folderItem.itemType( ItemType.FOLDER );

        return folderItem.build();
    }

    private String folderParentFolderId(Folder folder) {
        if ( folder == null ) {
            return null;
        }
        Folder parentFolder = folder.getParentFolder();
        if ( parentFolder == null ) {
            return null;
        }
        String id = parentFolder.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
