package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.context.ContextSystem;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.context.ContextSystemResponseDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.context.ContextSystemUpdateRequestDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-06T18:59:31+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class ContextSystemMapperImpl implements ContextSystemMapper {

    @Override
    public List<ContextSystemResponseDTO> toContextSystemResponsesDTOs(List<ContextSystem> contextSystems) {
        if ( contextSystems == null ) {
            return null;
        }

        List<ContextSystemResponseDTO> list = new ArrayList<ContextSystemResponseDTO>( contextSystems.size() );
        for ( ContextSystem contextSystem : contextSystems ) {
            list.add( toContextSystemResponseDTO( contextSystem ) );
        }

        return list;
    }

    @Override
    public ContextSystemResponseDTO toContextSystemResponseDTO(ContextSystem contextSystem) {
        if ( contextSystem == null ) {
            return null;
        }

        ContextSystemResponseDTO contextSystemResponseDTO = new ContextSystemResponseDTO();

        contextSystemResponseDTO.setId( contextSystem.getId() );
        contextSystemResponseDTO.setName( contextSystem.getName() );
        contextSystemResponseDTO.setDescription( contextSystem.getDescription() );
        contextSystemResponseDTO.setCreatedWhen( MapperUtils.fromTimestamp( contextSystem.getCreatedWhen() ) );
        contextSystemResponseDTO.setCreatedBy( userToUserDTO( contextSystem.getCreatedBy() ) );
        contextSystemResponseDTO.setModifiedWhen( MapperUtils.fromTimestamp( contextSystem.getModifiedWhen() ) );
        contextSystemResponseDTO.setModifiedBy( userToUserDTO( contextSystem.getModifiedBy() ) );

        return contextSystemResponseDTO;
    }

    @Override
    public ContextSystem update(ContextSystem contextSystem, ContextSystemUpdateRequestDTO request) {
        if ( request == null ) {
            return contextSystem;
        }

        if ( request.getName() != null ) {
            contextSystem.setName( request.getName() );
        }
        if ( request.getDescription() != null ) {
            contextSystem.setDescription( request.getDescription() );
        }

        return contextSystem;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }
}
