package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.UserMapper;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Folder;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.FolderItemRequest;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.FolderItemResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.FolderResponse;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.folder.SearchFilterItemResponse;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-06T18:59:34+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class FolderMapperImpl extends FolderMapper {

    @Autowired
    private UserMapper userMapper;

    @Override
    public Folder asEntity(FolderItemRequest request) {
        if ( request == null ) {
            return null;
        }

        Folder.FolderBuilder<?, ?> folder = Folder.builder();

        folder.name( request.getName() );
        folder.description( request.getDescription() );

        return folder.build();
    }

    @Override
    public SearchFilterItemResponse asSearchItemResponse(Folder entity) {
        if ( entity == null ) {
            return null;
        }

        SearchFilterItemResponse.SearchFilterItemResponseBuilder<?, ?> searchFilterItemResponse = SearchFilterItemResponse.builder();

        searchFilterItemResponse.parentId( entityParentFolderId( entity ) );
        searchFilterItemResponse.id( entity.getId() );
        searchFilterItemResponse.name( entity.getName() );
        searchFilterItemResponse.description( entity.getDescription() );
        searchFilterItemResponse.createdWhen( MapperUtils.fromTimestamp( entity.getCreatedWhen() ) );
        searchFilterItemResponse.createdBy( userMapper.asDTO( entity.getCreatedBy() ) );
        searchFilterItemResponse.modifiedWhen( MapperUtils.fromTimestamp( entity.getModifiedWhen() ) );
        searchFilterItemResponse.modifiedBy( userMapper.asDTO( entity.getModifiedBy() ) );

        return searchFilterItemResponse.build();
    }

    @Override
    public List<FolderItemResponse> asFolderItemResponse(Collection<Folder> folder) {
        if ( folder == null ) {
            return null;
        }

        List<FolderItemResponse> list = new ArrayList<FolderItemResponse>( folder.size() );
        for ( Folder folder1 : folder ) {
            list.add( asFolderItemResponse( folder1 ) );
        }

        return list;
    }

    @Override
    public FolderItemResponse asFolderItemResponse(Folder entity) {
        if ( entity == null ) {
            return null;
        }

        FolderItemResponse.FolderItemResponseBuilder<?, ?> folderItemResponse = FolderItemResponse.builder();

        folderItemResponse.parentId( entityParentFolderId( entity ) );
        folderItemResponse.id( entity.getId() );
        folderItemResponse.name( entity.getName() );
        folderItemResponse.description( entity.getDescription() );
        folderItemResponse.createdWhen( MapperUtils.fromTimestamp( entity.getCreatedWhen() ) );
        folderItemResponse.createdBy( userMapper.asDTO( entity.getCreatedBy() ) );
        folderItemResponse.modifiedWhen( MapperUtils.fromTimestamp( entity.getModifiedWhen() ) );
        folderItemResponse.modifiedBy( userMapper.asDTO( entity.getModifiedBy() ) );

        return folderItemResponse.build();
    }

    @Override
    public void merge(FolderResponse dto, Folder entity) {
        if ( entity == null ) {
            return;
        }

        dto.setParentId( entityParentFolderId( entity ) );
        dto.setId( entity.getId() );
        dto.setName( entity.getName() );
        dto.setDescription( entity.getDescription() );
        dto.setCreatedWhen( MapperUtils.fromTimestamp( entity.getCreatedWhen() ) );
        dto.setCreatedBy( userMapper.asDTO( entity.getCreatedBy() ) );
        dto.setModifiedWhen( MapperUtils.fromTimestamp( entity.getModifiedWhen() ) );
        dto.setModifiedBy( userMapper.asDTO( entity.getModifiedBy() ) );
    }

    private String entityParentFolderId(Folder folder) {
        if ( folder == null ) {
            return null;
        }
        Folder parentFolder = folder.getParentFolder();
        if ( parentFolder == null ) {
            return null;
        }
        String id = parentFolder.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
