package org.qubership.integration.platform.runtime.catalog.rest.v1.mapper;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.runtime.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.runtime.catalog.model.system.SystemModelSource;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.OperationBaseDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SystemModelDTO;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.SystemModelLabelDTO;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-06T18:59:34+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class SystemModelMapperImpl implements SystemModelMapper {

    @Autowired
    private ChainBaseMapper chainBaseMapper;
    @Autowired
    private OperationBaseMapper operationBaseMapper;

    @Override
    public SystemModelDTO toSystemModelDTO(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }

        SystemModelDTO systemModelDTO = new SystemModelDTO();

        systemModelDTO.setId( systemModel.getId() );
        systemModelDTO.setName( systemModel.getName() );
        systemModelDTO.setSpecificationGroupId( systemModelSpecificationGroupId( systemModel ) );
        systemModelDTO.setDeprecated( systemModel.isDeprecated() );
        systemModelDTO.setSystemId( systemModelSpecificationGroupSystemId( systemModel ) );
        systemModelDTO.setDescription( systemModel.getDescription() );
        systemModelDTO.setVersion( systemModel.getVersion() );
        if ( systemModel.getSource() != null ) {
            systemModelDTO.setSource( systemModel.getSource().name() );
        }
        systemModelDTO.setCreatedWhen( MapperUtils.fromTimestamp( systemModel.getCreatedWhen() ) );
        systemModelDTO.setCreatedBy( userToUserDTO( systemModel.getCreatedBy() ) );
        systemModelDTO.setModifiedWhen( MapperUtils.fromTimestamp( systemModel.getModifiedWhen() ) );
        systemModelDTO.setModifiedBy( userToUserDTO( systemModel.getModifiedBy() ) );
        systemModelDTO.setChains( chainBaseMapper.asDTO( systemModel.getChains() ) );
        systemModelDTO.setLabels( systemModelLabelSetToSystemModelLabelDTOList( systemModel.getLabels() ) );
        systemModelDTO.setOperations( operationBaseMapper.toDTOs( systemModel.getOperations() ) );

        return systemModelDTO;
    }

    @Override
    public List<SystemModelDTO> toSystemModelDTOs(List<SystemModel> systemModels) {
        if ( systemModels == null ) {
            return null;
        }

        List<SystemModelDTO> list = new ArrayList<SystemModelDTO>( systemModels.size() );
        for ( SystemModel systemModel : systemModels ) {
            list.add( toSystemModelDTO( systemModel ) );
        }

        return list;
    }

    @Override
    public void merge(SystemModelDTO systemDto, SystemModel systemModel) {
        if ( systemDto == null ) {
            return;
        }

        systemModel.setId( systemDto.getId() );
        systemModel.setName( systemDto.getName() );
        systemModel.setDescription( systemDto.getDescription() );
        systemModel.setCreatedWhen( MapperUtils.toTimestamp( systemDto.getCreatedWhen() ) );
        systemModel.setModifiedWhen( MapperUtils.toTimestamp( systemDto.getModifiedWhen() ) );
        if ( systemDto.getCreatedBy() != null ) {
            if ( systemModel.getCreatedBy() == null ) {
                systemModel.setCreatedBy( User.builder().build() );
            }
            userDTOToUser( systemDto.getCreatedBy(), systemModel.getCreatedBy() );
        }
        else {
            systemModel.setCreatedBy( null );
        }
        if ( systemDto.getModifiedBy() != null ) {
            if ( systemModel.getModifiedBy() == null ) {
                systemModel.setModifiedBy( User.builder().build() );
            }
            userDTOToUser( systemDto.getModifiedBy(), systemModel.getModifiedBy() );
        }
        else {
            systemModel.setModifiedBy( null );
        }
        if ( systemModel.getLabels() != null ) {
            Set<SystemModelLabel> set = systemModelLabelDTOListToSystemModelLabelSet( systemDto.getLabels() );
            if ( set != null ) {
                systemModel.getLabels().clear();
                systemModel.getLabels().addAll( set );
            }
            else {
                systemModel.setLabels( null );
            }
        }
        else {
            Set<SystemModelLabel> set = systemModelLabelDTOListToSystemModelLabelSet( systemDto.getLabels() );
            if ( set != null ) {
                systemModel.setLabels( set );
            }
        }
        if ( systemDto.getDeprecated() != null ) {
            systemModel.setDeprecated( systemDto.getDeprecated() );
        }
        systemModel.setVersion( systemDto.getVersion() );
        if ( systemDto.getSource() != null ) {
            systemModel.setSource( Enum.valueOf( SystemModelSource.class, systemDto.getSource() ) );
        }
        else {
            systemModel.setSource( null );
        }
        if ( systemModel.getOperations() != null ) {
            List<Operation> list = operationBaseDTOListToOperationList( systemDto.getOperations() );
            if ( list != null ) {
                systemModel.getOperations().clear();
                systemModel.getOperations().addAll( list );
            }
            else {
                systemModel.setOperations( null );
            }
        }
        else {
            List<Operation> list = operationBaseDTOListToOperationList( systemDto.getOperations() );
            if ( list != null ) {
                systemModel.setOperations( list );
            }
        }
        if ( systemModel.getChains() != null ) {
            List<Chain> list1 = baseResponseListToChainList( systemDto.getChains() );
            if ( list1 != null ) {
                systemModel.getChains().clear();
                systemModel.getChains().addAll( list1 );
            }
            else {
                systemModel.setChains( null );
            }
        }
        else {
            List<Chain> list1 = baseResponseListToChainList( systemDto.getChains() );
            if ( list1 != null ) {
                systemModel.setChains( list1 );
            }
        }
    }

    @Override
    public SystemModel asEntity(SystemModelDTO model) {
        if ( model == null ) {
            return null;
        }

        SystemModel.SystemModelBuilder<?, ?> systemModel = SystemModel.builder();

        systemModel.id( model.getId() );
        systemModel.name( model.getName() );
        systemModel.description( model.getDescription() );
        systemModel.createdWhen( MapperUtils.toTimestamp( model.getCreatedWhen() ) );
        systemModel.modifiedWhen( MapperUtils.toTimestamp( model.getModifiedWhen() ) );
        systemModel.createdBy( userDTOToUser1( model.getCreatedBy() ) );
        systemModel.modifiedBy( userDTOToUser1( model.getModifiedBy() ) );
        if ( model.getDeprecated() != null ) {
            systemModel.deprecated( model.getDeprecated() );
        }
        systemModel.version( model.getVersion() );
        if ( model.getSource() != null ) {
            systemModel.source( Enum.valueOf( SystemModelSource.class, model.getSource() ) );
        }
        systemModel.operations( operationBaseDTOListToOperationList( model.getOperations() ) );
        systemModel.labels( systemModelLabelDTOListToSystemModelLabelSet( model.getLabels() ) );
        systemModel.chains( baseResponseListToChainList( model.getChains() ) );

        return systemModel.build();
    }

    @Override
    public SystemModelLabel asLabelRequest(SystemModelLabelDTO snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SystemModelLabel.SystemModelLabelBuilder<?, ?> systemModelLabel = SystemModelLabel.builder();

        systemModelLabel.name( snapshotLabel.getName() );
        if ( snapshotLabel.getTechnical() != null ) {
            systemModelLabel.technical( snapshotLabel.getTechnical() );
        }

        return systemModelLabel.build();
    }

    @Override
    public List<SystemModelLabel> asLabelRequests(List<SystemModelLabelDTO> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SystemModelLabel> list = new ArrayList<SystemModelLabel>( snapshotLabel.size() );
        for ( SystemModelLabelDTO systemModelLabelDTO : snapshotLabel ) {
            list.add( asLabelRequest( systemModelLabelDTO ) );
        }

        return list;
    }

    @Override
    public SystemModelLabelDTO asLabelResponse(SystemModelLabel snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        SystemModelLabelDTO.SystemModelLabelDTOBuilder systemModelLabelDTO = SystemModelLabelDTO.builder();

        systemModelLabelDTO.name( snapshotLabel.getName() );
        systemModelLabelDTO.technical( snapshotLabel.isTechnical() );

        return systemModelLabelDTO.build();
    }

    @Override
    public List<SystemModelLabelDTO> asLabelResponse(List<SystemModelLabel> snapshotLabel) {
        if ( snapshotLabel == null ) {
            return null;
        }

        List<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>( snapshotLabel.size() );
        for ( SystemModelLabel systemModelLabel : snapshotLabel ) {
            list.add( asLabelResponse( systemModelLabel ) );
        }

        return list;
    }

    private String systemModelSpecificationGroupId(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if ( specificationGroup == null ) {
            return null;
        }
        String id = specificationGroup.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private String systemModelSpecificationGroupSystemId(SystemModel systemModel) {
        if ( systemModel == null ) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if ( specificationGroup == null ) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if ( system == null ) {
            return null;
        }
        String id = system.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if ( user == null ) {
            return null;
        }

        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();

        userDTO.id( user.getId() );
        userDTO.username( user.getUsername() );

        return userDTO.build();
    }

    protected List<SystemModelLabelDTO> systemModelLabelSetToSystemModelLabelDTOList(Set<SystemModelLabel> set) {
        if ( set == null ) {
            return null;
        }

        List<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>( set.size() );
        for ( SystemModelLabel systemModelLabel : set ) {
            list.add( asLabelResponse( systemModelLabel ) );
        }

        return list;
    }

    protected void userDTOToUser(UserDTO userDTO, User mappingTarget) {
        if ( userDTO == null ) {
            return;
        }

        mappingTarget.setId( userDTO.getId() );
        mappingTarget.setUsername( userDTO.getUsername() );
    }

    protected Set<SystemModelLabel> systemModelLabelDTOListToSystemModelLabelSet(List<SystemModelLabelDTO> list) {
        if ( list == null ) {
            return null;
        }

        Set<SystemModelLabel> set = new LinkedHashSet<SystemModelLabel>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( SystemModelLabelDTO systemModelLabelDTO : list ) {
            set.add( asLabelRequest( systemModelLabelDTO ) );
        }

        return set;
    }

    protected User userDTOToUser1(UserDTO userDTO) {
        if ( userDTO == null ) {
            return null;
        }

        User.UserBuilder user = User.builder();

        user.id( userDTO.getId() );
        user.username( userDTO.getUsername() );

        return user.build();
    }

    protected Chain baseResponseToChain(BaseResponse baseResponse) {
        if ( baseResponse == null ) {
            return null;
        }

        Chain.ChainBuilder<?, ?> chain = Chain.builder();

        chain.id( baseResponse.getId() );
        chain.name( baseResponse.getName() );
        chain.description( baseResponse.getDescription() );
        chain.createdWhen( MapperUtils.toTimestamp( baseResponse.getCreatedWhen() ) );
        chain.modifiedWhen( MapperUtils.toTimestamp( baseResponse.getModifiedWhen() ) );
        chain.createdBy( userDTOToUser1( baseResponse.getCreatedBy() ) );
        chain.modifiedBy( userDTOToUser1( baseResponse.getModifiedBy() ) );

        return chain.build();
    }

    protected List<Chain> baseResponseListToChainList(List<BaseResponse> list) {
        if ( list == null ) {
            return null;
        }

        List<Chain> list1 = new ArrayList<Chain>( list.size() );
        for ( BaseResponse baseResponse : list ) {
            list1.add( baseResponseToChain( baseResponse ) );
        }

        return list1;
    }

    protected Operation operationBaseDTOToOperation(OperationBaseDTO operationBaseDTO) {
        if ( operationBaseDTO == null ) {
            return null;
        }

        Operation.OperationBuilder<?, ?> operation = Operation.builder();

        operation.id( operationBaseDTO.getId() );
        operation.name( operationBaseDTO.getName() );
        operation.description( operationBaseDTO.getDescription() );
        operation.method( operationBaseDTO.getMethod() );
        operation.path( operationBaseDTO.getPath() );
        operation.chains( baseResponseListToChainList( operationBaseDTO.getChains() ) );

        return operation.build();
    }

    protected List<Operation> operationBaseDTOListToOperationList(List<OperationBaseDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<Operation> list1 = new ArrayList<Operation>( list.size() );
        for ( OperationBaseDTO operationBaseDTO : list ) {
            list1.add( operationBaseDTOToOperation( operationBaseDTO ) );
        }

        return list1;
    }
}
