package org.qubership.integration.platform.runtime.catalog.service.mapping;

import javax.annotation.processing.Generated;
import org.qubership.integration.platform.runtime.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.Environment;
import org.qubership.integration.platform.runtime.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.runtime.catalog.util.MapperUtils;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-06T18:59:32+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 21.0.8 (Eclipse Adoptium)"
)
@Component
public class ServiceEnvironmentMapperImpl extends ServiceEnvironmentMapper {

    @Override
    public ServiceEnvironment toServiceEnvironment(Environment environment) {
        if ( environment == null ) {
            return null;
        }

        ServiceEnvironment serviceEnvironment = new ServiceEnvironment();

        serviceEnvironment.setSystemId( environmentSystemId( environment ) );
        serviceEnvironment.setId( environment.getId() );
        serviceEnvironment.setSourceType( environment.getSourceType() );
        serviceEnvironment.setName( environment.getName() );
        serviceEnvironment.setDescription( environment.getDescription() );
        serviceEnvironment.setAddress( environment.getAddress() );
        serviceEnvironment.setProperties( jsonNodeToMap( environment.getProperties() ) );
        serviceEnvironment.setCreatedWhen( MapperUtils.fromTimestamp( environment.getCreatedWhen() ) );
        serviceEnvironment.setModifiedWhen( MapperUtils.fromTimestamp( environment.getModifiedWhen() ) );

        return serviceEnvironment;
    }

    private String environmentSystemId(Environment environment) {
        if ( environment == null ) {
            return null;
        }
        IntegrationSystem system = environment.getSystem();
        if ( system == null ) {
            return null;
        }
        String id = system.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
