/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.sessions.dto.AbstractRunnableElement;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.qubership.integration.platform.sessions.dto.SessionElementProperty;
import org.qubership.integration.platform.sessions.dto.opensearch.ExceptionInfoElastic;

@Schema(description="Single element(step) from the session")
public class SessionElement
extends AbstractRunnableElement {
    @Schema(description="Id of the object")
    private String elementId;
    @Schema(description="Id of the session linked to session element")
    private String sessionId;
    @Schema(description="Id of the chain element linked to session element")
    private String chainElementId;
    @Schema(description="Id of the sub-chain element linked to session element in case (in case it is element from sub-chain)")
    private String actualElementChainId;
    @Schema(description="Id of the parent object for current object")
    private String parentElement;
    @Schema(description="Previous object id in execution chain")
    private String previousElement;
    @Schema(description="Name of the object (step)")
    private String elementName;
    @Schema(description="Type of the element if it is chain element step (not sub-step)")
    private String camelName;
    @Schema(description="Body before step execution")
    private String bodyBefore;
    @Schema(description="Body after step execution")
    private String bodyAfter;
    @Schema(description="Map of headers before step execution")
    private Map<String, String> headersBefore;
    @Schema(description="Map of headers after step execution")
    private Map<String, String> headersAfter;
    @Schema(description="Map of properties before step execution")
    private Map<String, SessionElementProperty> propertiesBefore;
    @Schema(description="Map of properties after step execution")
    private Map<String, SessionElementProperty> propertiesAfter;
    @Schema(description="Map of context properties before step execution")
    private Map<String, String> contextBefore;
    @Schema(description="Map of context properties after step execution")
    private Map<String, String> contextAfter;
    @Schema(description="List of child elements (sub-elements) for the current object (step)")
    private List<SessionElement> children;
    private ExceptionInfoElastic exceptionInfo;

    protected SessionElement(SessionElementBuilder<?, ?> b) {
        super((AbstractRunnableElement.AbstractRunnableElementBuilder)b);
        this.elementId = b.elementId;
        this.sessionId = b.sessionId;
        this.chainElementId = b.chainElementId;
        this.actualElementChainId = b.actualElementChainId;
        this.parentElement = b.parentElement;
        this.previousElement = b.previousElement;
        this.elementName = b.elementName;
        this.camelName = b.camelName;
        this.bodyBefore = b.bodyBefore;
        this.bodyAfter = b.bodyAfter;
        this.headersBefore = b.headersBefore;
        this.headersAfter = b.headersAfter;
        this.propertiesBefore = b.propertiesBefore;
        this.propertiesAfter = b.propertiesAfter;
        this.contextBefore = b.contextBefore;
        this.contextAfter = b.contextAfter;
        this.children = b.children;
        this.exceptionInfo = b.exceptionInfo;
    }

    public static SessionElementBuilder<?, ?> builder() {
        return new SessionElementBuilderImpl();
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getChainElementId() {
        return this.chainElementId;
    }

    public String getActualElementChainId() {
        return this.actualElementChainId;
    }

    public String getParentElement() {
        return this.parentElement;
    }

    public String getPreviousElement() {
        return this.previousElement;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getCamelName() {
        return this.camelName;
    }

    public String getBodyBefore() {
        return this.bodyBefore;
    }

    public String getBodyAfter() {
        return this.bodyAfter;
    }

    public Map<String, String> getHeadersBefore() {
        return this.headersBefore;
    }

    public Map<String, String> getHeadersAfter() {
        return this.headersAfter;
    }

    public Map<String, SessionElementProperty> getPropertiesBefore() {
        return this.propertiesBefore;
    }

    public Map<String, SessionElementProperty> getPropertiesAfter() {
        return this.propertiesAfter;
    }

    public Map<String, String> getContextBefore() {
        return this.contextBefore;
    }

    public Map<String, String> getContextAfter() {
        return this.contextAfter;
    }

    public List<SessionElement> getChildren() {
        return this.children;
    }

    public ExceptionInfoElastic getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setChainElementId(String chainElementId) {
        this.chainElementId = chainElementId;
    }

    public void setActualElementChainId(String actualElementChainId) {
        this.actualElementChainId = actualElementChainId;
    }

    public void setParentElement(String parentElement) {
        this.parentElement = parentElement;
    }

    public void setPreviousElement(String previousElement) {
        this.previousElement = previousElement;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setCamelName(String camelName) {
        this.camelName = camelName;
    }

    public void setBodyBefore(String bodyBefore) {
        this.bodyBefore = bodyBefore;
    }

    public void setBodyAfter(String bodyAfter) {
        this.bodyAfter = bodyAfter;
    }

    public void setHeadersBefore(Map<String, String> headersBefore) {
        this.headersBefore = headersBefore;
    }

    public void setHeadersAfter(Map<String, String> headersAfter) {
        this.headersAfter = headersAfter;
    }

    public void setPropertiesBefore(Map<String, SessionElementProperty> propertiesBefore) {
        this.propertiesBefore = propertiesBefore;
    }

    public void setPropertiesAfter(Map<String, SessionElementProperty> propertiesAfter) {
        this.propertiesAfter = propertiesAfter;
    }

    public void setContextBefore(Map<String, String> contextBefore) {
        this.contextBefore = contextBefore;
    }

    public void setContextAfter(Map<String, String> contextAfter) {
        this.contextAfter = contextAfter;
    }

    public void setChildren(List<SessionElement> children) {
        this.children = children;
    }

    public void setExceptionInfo(ExceptionInfoElastic exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public SessionElement() {
    }
}

