/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.configuration.opensearch;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.qubership.integration.platform.sessions.opensearch.DefaultOpenSearchClientSupplier;
import org.qubership.integration.platform.sessions.opensearch.OpenSearchClientSupplier;
import org.qubership.integration.platform.sessions.properties.opensearch.ClientProperties;
import org.qubership.integration.platform.sessions.properties.opensearch.OpenSearchProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={OpenSearchProperties.class})
public class OpenSearchAutoConfiguration {
    private OpenSearchClient createOpenSearchClient(ClientProperties properties) {
        AuthScope authScope = new AuthScope(null, null, -1, null, null);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(properties.username(), properties.password().toCharArray());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{new HttpHost(properties.protocol(), properties.host(), properties.port().intValue())}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider));
        return new OpenSearchClient((OpenSearchTransport)builder.build());
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenSearchClientSupplier.class})
    public OpenSearchClientSupplier openSearchClientSupplier(OpenSearchProperties properties) {
        OpenSearchClient client = this.createOpenSearchClient(properties.client());
        return new DefaultOpenSearchClientSupplier(client, properties.index().prefix());
    }
}

