/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.qubership.integration.platform.sessions.dto.AbstractRunnableElement;
import org.qubership.integration.platform.sessions.dto.Session;
import org.qubership.integration.platform.sessions.dto.SessionElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(description="Single session object")
public class Session
extends AbstractRunnableElement {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    @Schema(description="Id")
    private String id;
    @Schema(description="Whether this is imported session")
    private boolean importedSession;
    @Schema(description="External id (if it was set during chain execution)")
    private String externalSessionCipId;
    @Schema(description="Id of the chain it was executed on")
    private String chainId;
    @Schema(description="Name of the chain it was executed on")
    private String chainName;
    @Schema(description="Domain on which chain was executed")
    private String domain;
    @Schema(description="qubership-integration-platform-engine pod ip address on which chain was executed")
    private String engineAddress;
    @Schema(description="Value of logging level on a chain at a time chain was executed")
    private String loggingLevel;
    @Schema(description="Deployed snapshot name for the chain")
    private String snapshotName;
    @Schema(description="Correlation id for that execution (if it was set)")
    private String correlationId;
    @Schema(description="Parent of session id for the current session")
    private String parentSessionId;
    @Schema(description="List of session elements (steps) created by this session")
    private List<SessionElement> sessionElements;

    protected Session(SessionBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.importedSession = b.importedSession;
        this.externalSessionCipId = b.externalSessionCipId;
        this.chainId = b.chainId;
        this.chainName = b.chainName;
        this.domain = b.domain;
        this.engineAddress = b.engineAddress;
        this.loggingLevel = b.loggingLevel;
        this.snapshotName = b.snapshotName;
        this.correlationId = b.correlationId;
        this.parentSessionId = b.parentSessionId;
        this.sessionElements = b.sessionElements;
    }

    public static SessionBuilder<?, ?> builder() {
        return new SessionBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public boolean isImportedSession() {
        return this.importedSession;
    }

    public String getExternalSessionCipId() {
        return this.externalSessionCipId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEngineAddress() {
        return this.engineAddress;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public List<SessionElement> getSessionElements() {
        return this.sessionElements;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImportedSession(boolean importedSession) {
        this.importedSession = importedSession;
    }

    public void setExternalSessionCipId(String externalSessionCipId) {
        this.externalSessionCipId = externalSessionCipId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEngineAddress(String engineAddress) {
        this.engineAddress = engineAddress;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setParentSessionId(String parentSessionId) {
        this.parentSessionId = parentSessionId;
    }

    public void setSessionElements(List<SessionElement> sessionElements) {
        this.sessionElements = sessionElements;
    }

    public Session() {
    }
}

