/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.sessions.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.sessions.service.ExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sessions/export"})
@Tag(name="export-controller", description="Export Controller")
public class ExportController {
    private static final Logger log = LoggerFactory.getLogger(ExportController.class);
    private final ExportService exportService;

    @Autowired
    public ExportController(ExportService exportService) {
        this.exportService = exportService;
    }

    @Operation(description="Export sessions by given sessionId's as a file")
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<String> exportSessions(@RequestBody @NotEmpty @Valid @Parameter(description="List of session Ids to export") List<String> sessionsIds) {
        try {
            return this.asResponse(this.exportService.exportSessions(sessionsIds));
        }
        catch (JsonProcessingException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<String> asResponse(Pair<String, String> export) {
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Disposition", "attachment; filename=" + (String)export.getKey());
        header.add("Access-Control-Expose-Headers", "Content-Disposition");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(header)).body((Object)((String)export.getValue()));
    }
}

